/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.core.command;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.eclipse.egerrit.internal.core.GerritRepository;
import org.eclipse.egerrit.internal.core.command.AuthentificationRequired;
import org.eclipse.egerrit.internal.core.command.BaseCommand;
import org.eclipse.egerrit.internal.core.command.ChangeOption;
import org.eclipse.egerrit.internal.core.command.ChangeStatus;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.model.ChangeInfo;

public class QueryChangesCommand
extends BaseCommand<ChangeInfo[]> {
    String queryString;

    public QueryChangesCommand(GerritRepository gerritRepository) {
        super(gerritRepository, AuthentificationRequired.DEPENDS, (Class<? extends HttpRequestBase>)HttpGet.class, (Type)((Object)ChangeInfo[].class));
        this.setPathFormat("/changes/");
    }

    public void addQuery(String query) {
        this.queryString = this.queryString == null ? query : String.valueOf(this.queryString) + "+" + query;
    }

    public void setMaxNumberOfResults(int limit) {
        this.addQueryParameter("n", Integer.toString(limit));
    }

    public void setSkipNumberOfResults(int skip) {
        this.addQueryParameter("start", Integer.toString(skip));
    }

    public void addOption(ChangeOption ... options) {
        ChangeOption[] changeOptionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeOption opt = changeOptionArray[n2];
            this.addQueryParameter("o", opt.getValue());
            ++n2;
        }
    }

    public void addTopic(String topic) {
        this.addQuery("topic:" + topic);
    }

    public void addConflicts(String changeId) {
        this.addQuery("conflicts:" + changeId);
    }

    public void addStatus(ChangeStatus status) {
        this.addQuery(status.getValue());
    }

    public void addMergeable() {
        this.addQuery("is:mergeable");
    }

    @Override
    public ChangeInfo[] call() throws EGerritException {
        if (this.queryString != null) {
            try {
                this.addQueryParameter("q", URLDecoder.decode(this.queryString, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalStateException("Problem decoding query string " + this.queryString);
            }
        }
        return (ChangeInfo[])super.call();
    }
}

