/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.utils;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.CreateDraftCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.ModelHelpers;
import org.eclipse.egerrit.internal.model.ModelPackage;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.compare.CommentableCompareItem;
import org.eclipse.egerrit.internal.ui.editors.ChangeDetailEditor;
import org.eclipse.egerrit.internal.ui.editors.EGerritCommentMarkers;
import org.eclipse.egerrit.internal.ui.editors.OpenCompareEditor;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveWorkspaceRevision {
    private static Logger logger = LoggerFactory.getLogger(ChangeDetailEditor.class);
    private static final ActiveWorkspaceRevision INSTANCE = new ActiveWorkspaceRevision();
    private GerritClient fGerritClient = null;
    private ChangeInfo fChangeInfo = null;
    private RevisionInfo fRevisionInContext = null;
    private CommentAndDraftListener listener;
    private Map<String, IMarker> markersManaged = new HashMap<String, IMarker>();
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private ActiveWorkspaceRevision() {
    }

    public static ActiveWorkspaceRevision getInstance() {
        return INSTANCE;
    }

    public void activateCurrentRevision(GerritClient gerrit, RevisionInfo revisionInfo) {
        if (revisionInfo == null) {
            throw new IllegalAccessError("Revision can't be null.");
        }
        if (this.fRevisionInContext != null) {
            this.deactiveCurrentRevision();
        }
        this.fGerritClient = gerrit;
        this.fRevisionInContext = revisionInfo;
        this.fChangeInfo = revisionInfo.getChangeInfo();
        this.forceLoadRevision();
        this.createMarkers();
        this.hookListeners();
        this.firePropertyChange("activeRevision", null, this.fRevisionInContext);
        this.openMarkerView();
    }

    private void openMarkerView() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.AllMarkersView");
        }
        catch (PartInitException e1) {
            EGerritCorePlugin.logError((String)(String.valueOf(this.fGerritClient.getRepository().formatGerritVersion()) + e1.getMessage()));
        }
    }

    private void forceLoadRevision() {
        QueryHelpers.loadRevisionDetails(this.fGerritClient, this.fRevisionInContext);
    }

    private void hookListeners() {
        this.listener = new CommentAndDraftListener();
        this.fRevisionInContext.eAdapters().add((Object)this.listener);
    }

    public void newComment(CommentInfo newComment) {
        if (this.fRevisionInContext == null) {
            logger.debug("No active revision set.");
            return;
        }
        FileInfo fileInfo = this.getFileInfoInRevision(newComment.getPath());
        if (fileInfo == null) {
            logger.debug("Problem creating the marker. The active revision does not contain the expected file." + newComment.getPath());
            return;
        }
        CreateDraftCommand publishDraft = this.fGerritClient.createDraftComments(this.fChangeInfo.getId(), this.fRevisionInContext.getId());
        newComment.setSide("right");
        publishDraft.setCommandInput(newComment);
        newComment.setPath(fileInfo.getPath());
        try {
            fileInfo.getDraftComments().add((Object)((CommentInfo)publishDraft.call()));
        }
        catch (EGerritException eGerritException) {
            throw new RuntimeException(CommentableCompareItem.class.getName(), new Throwable(String.valueOf(this.hashCode())));
        }
    }

    private FileInfo getFileInfoInRevision(String path) {
        Collection files = this.fRevisionInContext.getFiles().values();
        for (FileInfo aFile : files) {
            if (aFile.getPath() == null || ("/" + aFile.getPath()).compareTo(path) != 0) continue;
            return aFile;
        }
        return null;
    }

    public boolean isFilePartOfReview(String reviewFileName) {
        if (this.fRevisionInContext == null) {
            logger.debug("No active revision set.");
            return false;
        }
        return this.getFileInfoInRevision(reviewFileName) != null;
    }

    private void deleteAllMarkers() {
        HashSet<String> allMarkers = new HashSet<String>(this.markersManaged.keySet());
        for (String entry : allMarkers) {
            IMarker m = this.markersManaged.remove(entry);
            if (m == null) continue;
            try {
                m.delete();
            }
            catch (CoreException e) {
                logger.debug("Failed to delete marker", (Throwable)e);
            }
        }
    }

    private void createMarkers() {
        Collection files = this.fRevisionInContext.getFiles().values();
        this.deleteAllMarkers();
        for (FileInfo fileInfo : files) {
            IFile workspaceFile = new OpenCompareEditor(this.fGerritClient, this.fChangeInfo).getCorrespondingWorkspaceFile(fileInfo);
            if (workspaceFile == null) {
                workspaceFile = ResourcesPlugin.getWorkspace().getRoot();
            }
            EList sortedComments = ModelHelpers.sortComments((EList)fileInfo.getAllComments());
            for (CommentInfo commentInfo : sortedComments) {
                this.addMarker(commentInfo, (IResource)workspaceFile);
            }
        }
    }

    public void deactiveCurrentRevision() {
        if (this.fRevisionInContext == null) {
            return;
        }
        this.fRevisionInContext.eAdapters().remove((Object)this.listener);
        this.deleteAllMarkers();
        if (this.hasDrafts()) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            UIUtils.replyToChange(shell, this.fRevisionInContext, String.valueOf(Messages.ActiveWorkspaceRevision_0) + this.fRevisionInContext.getChangeInfo().getSubject() + "\"\n\n", this.fGerritClient, false);
        }
        this.fRevisionInContext = null;
        this.firePropertyChange("activeRevision", null, null);
    }

    private boolean hasDrafts() {
        Collection files = this.fRevisionInContext.getFiles().values();
        for (FileInfo fileInfo : files) {
            if (fileInfo.getDraftsCount() <= 0) continue;
            return true;
        }
        return false;
    }

    private void deleteMarker(CommentInfo commentToDelete) {
        IMarker marker = this.markersManaged.remove(commentToDelete.getId());
        if (marker != null) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                logger.debug("Failed to delete marker", (Throwable)e);
            }
        }
    }

    private void addMarker(CommentInfo newComment, IResource workspaceFile) {
        if (workspaceFile == null) {
            workspaceFile = new OpenCompareEditor(this.fGerritClient, this.fChangeInfo).getCorrespondingWorkspaceFile(ModelHelpers.getFileInfo((CommentInfo)newComment));
        }
        if (workspaceFile == null) {
            workspaceFile = ResourcesPlugin.getWorkspace().getRoot();
        }
        try {
            IMarker commentMarker = workspaceFile.createMarker(EGerritCommentMarkers.COMMENT_MARKER_ID);
            if (workspaceFile == ResourcesPlugin.getWorkspace().getRoot()) {
                commentMarker.setAttribute("message", (Object)(String.valueOf(this.resourceMissingMessage(newComment)) + UIUtils.formatMessageForMarkerView(newComment)));
            } else {
                commentMarker.setAttribute("lineNumber", newComment.getLine() == 0 ? 1 : newComment.getLine());
                commentMarker.setAttribute("message", (Object)UIUtils.formatMessageForMarkerView(newComment));
            }
            commentMarker.setAttribute("priority", 1);
            commentMarker.setAttribute("severity", 0);
            commentMarker.setAttribute(EGerritCommentMarkers.ATTR_COMMENT_INFO, (Object)newComment);
            commentMarker.setAttribute(EGerritCommentMarkers.ATTR_FILE_INFO, (Object)newComment);
            commentMarker.setAttribute(EGerritCommentMarkers.ATTR_GERRIT_CLIENT, (Object)this.fGerritClient);
            commentMarker.setAttribute(EGerritCommentMarkers.ATTR_IS_DRAFT, newComment.getAuthor() == null);
            this.markersManaged.put(newComment.getId(), commentMarker);
        }
        catch (CoreException e) {
            logger.debug("Failed to create marker", (Throwable)e);
        }
    }

    private String resourceMissingMessage(CommentInfo comment) {
        return NLS.bind((String)Messages.ActiveWorkspaceRevision_1, (Object)ModelHelpers.getFileInfo((CommentInfo)comment).getPath());
    }

    public RevisionInfo getActiveRevision() {
        return this.fRevisionInContext;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    private final class CommentAndDraftListener
    extends EContentAdapter {
        private CommentAndDraftListener() {
        }

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            if (msg.getFeature() == null) {
                return;
            }
            if (msg.getFeature().equals(ModelPackage.Literals.FILE_INFO__COMMENTS) || msg.getFeature().equals(ModelPackage.Literals.FILE_INFO__DRAFT_COMMENTS)) {
                if (msg.getEventType() == 3) {
                    ActiveWorkspaceRevision.this.addMarker((CommentInfo)msg.getNewValue(), null);
                }
                if (msg.getEventType() == 4) {
                    ActiveWorkspaceRevision.this.deleteMarker((CommentInfo)msg.getOldValue());
                }
            }
        }
    }
}

