/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.model.internal;

import org.eclipse.fx.ide.model.IFXEnumProperty;
import org.eclipse.fx.ide.model.internal.FXClass;
import org.eclipse.fx.ide.model.internal.FXProperty;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class FXEnumProperty
extends FXProperty
implements IFXEnumProperty {
    private String enumTypeAsString;
    private IType enumType;

    public FXEnumProperty(FXClass fxClass, String name, IJavaElement javaElement, String erasedFQNType, boolean isStatic) {
        super(fxClass, name, javaElement, isStatic);
        this.enumTypeAsString = erasedFQNType;
    }

    public static boolean isEnum(IJavaProject jp, String erasedFQNType) throws JavaModelException {
        return jp.findType(erasedFQNType).isEnum();
    }

    public String toString() {
        return "FXEnumProperty(" + this.getName() + ")";
    }

    @Override
    public String getEnumTypeAsString(boolean fqn) {
        return fqn ? this.enumTypeAsString : Signature.getSimpleName((String)this.enumTypeAsString);
    }

    @Override
    public IType getEnumType() {
        if (this.enumType == null) {
            try {
                this.enumType = this.getFXClass().getJavaProject().findType(this.enumTypeAsString);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return this.enumType;
    }
}

