/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.specs.ISolverService;
import org.sat4j.specs.Lbool;
import org.sat4j.specs.RandomAccessModel;
import org.sat4j.tools.SearchListenerAdapter;
import org.sat4j.tools.SolutionFoundListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchMinOneListener
extends SearchListenerAdapter<ISolverService> {
    private static final long serialVersionUID = 1L;
    private ISolverService solverService;
    private final SolutionFoundListener sfl;

    public SearchMinOneListener(SolutionFoundListener sfl) {
        this.sfl = sfl;
    }

    @Override
    public void init(ISolverService solverService) {
        this.solverService = solverService;
    }

    @Override
    public void solutionFound(int[] model, RandomAccessModel lazyModel) {
        int degree = 0;
        int[] variables = new int[model.length];
        int i = 0;
        while (i < model.length) {
            if (model[i] > 0) {
                ++degree;
                variables[i] = model[i];
            } else {
                variables[i] = -model[i];
            }
            ++i;
        }
        System.out.println(String.valueOf(this.solverService.getLogPrefix()) + " #one " + degree);
        this.solverService.addAtMostOnTheFly(variables, degree - 1);
        this.sfl.onSolutionFound(model);
    }

    @Override
    public void end(Lbool result) {
        assert (result != Lbool.TRUE);
    }
}

