/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jdt.internal.core.nd.util.CharArrayUtils;

public final class CharArrayMap<V> {
    private final Map<Key, V> map;

    private static void checkBoundaries(char[] chars, int start, int length) {
        if (start < 0 || length < 0 || start >= chars.length || start + length > chars.length) {
            throw new IndexOutOfBoundsException("Buffer length: " + chars.length + ", Start index: " + start + ", Length: " + length);
        }
    }

    public CharArrayMap() {
        this.map = new HashMap<Key, V>();
    }

    public static <V> CharArrayMap<V> createOrderedMap() {
        return new CharArrayMap(new TreeMap());
    }

    private CharArrayMap(Map<Key, V> map) {
        assert (map != null);
        this.map = map;
    }

    public CharArrayMap(int initialCapacity) {
        this.map = new HashMap<Key, V>(initialCapacity);
    }

    public void put(char[] chars, int start, int length, V value) {
        CharArrayMap.checkBoundaries(chars, start, length);
        this.map.put(new Key(chars, start, length), value);
    }

    public void put(char[] chars, V value) {
        this.map.put(new Key(chars), value);
    }

    public V get(char[] chars, int start, int length) {
        CharArrayMap.checkBoundaries(chars, start, length);
        return this.map.get(new Key(chars, start, length));
    }

    public V get(char[] chars) {
        return this.map.get(new Key(chars));
    }

    public V remove(char[] chars, int start, int length) {
        CharArrayMap.checkBoundaries(chars, start, length);
        return this.map.remove(new Key(chars, start, length));
    }

    public V remove(char[] chars) {
        return this.map.remove(new Key(chars));
    }

    public boolean containsKey(char[] chars, int start, int length) {
        CharArrayMap.checkBoundaries(chars, start, length);
        return this.map.containsKey(new Key(chars, start, length));
    }

    public boolean containsKey(char[] chars) {
        return this.map.containsKey(new Key(chars));
    }

    public boolean containsValue(V value) {
        return this.map.containsValue(value);
    }

    public Collection<V> values() {
        return this.map.values();
    }

    public Collection<char[]> keys() {
        Set<Key> keys = this.map.keySet();
        ArrayList<char[]> r = new ArrayList<char[]>(keys.size());
        for (Key key : keys) {
            r.add(CharArrayUtils.extract(key.buffer, key.start, key.length));
        }
        return r;
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return this.map.toString();
    }

    private static final class Key
    implements Comparable<Key> {
        final char[] buffer;
        final int start;
        final int length;

        public Key(char[] buffer, int start, int length) {
            this.buffer = buffer;
            this.length = length;
            this.start = start;
        }

        public Key(char[] buffer) {
            this.buffer = buffer;
            this.length = buffer.length;
            this.start = 0;
        }

        public boolean equals(Object x) {
            if (this == x) {
                return true;
            }
            if (!(x instanceof Key)) {
                return false;
            }
            Key k = (Key)x;
            if (this.length != k.length) {
                return false;
            }
            int i = this.start;
            int j = k.start;
            while (i < this.length) {
                if (this.buffer[i] != k.buffer[j]) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }

        public int hashCode() {
            int result = 17;
            int i = this.start;
            while (i < this.start + this.length) {
                result = 37 * result + this.buffer[i];
                ++i;
            }
            return result;
        }

        public String toString() {
            String slice = new String(this.buffer, this.start, this.length);
            return "'" + slice + "'@(" + this.start + "," + this.length + ")";
        }

        @Override
        public int compareTo(Key other) {
            char[] b1 = this.buffer;
            char[] b2 = other.buffer;
            int i = this.start;
            int j = other.start;
            while (i < b1.length && j < b2.length) {
                if (b1[i] != b2[j]) {
                    return b1[i] < b2[j] ? -1 : 1;
                }
                ++i;
                ++j;
            }
            return b1.length - b2.length;
        }
    }
}

