/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.e4.ui.workbench.modeling.IWindowCloseHandler;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.EventProcessor;
import org.eclipse.fx.ui.workbench.renderers.base.services.MaximizationService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WTrimBar;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWindow;
import org.eclipse.fx.ui.workbench.services.ELifecycleService;
import org.eclipse.fx.ui.workbench.services.lifecycle.annotation.PreClose;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.event.Event;

public abstract class BaseWindowRenderer<N>
extends BaseRenderer<MWindow, WWindow<N>> {
    public static final String KEY_FULL_SCREEN = "efx.window.fullscreen";
    public static final String TAG_SHELLMAXIMIZED = "shellMaximized";
    public static final String TAG_SECONDARY_WINDOW = "secondaryMainWindow";
    public static final String TAG_REMOVE_ON_HIDE = "removeOnHide";
    @Inject
    @Log
    Logger logger;
    @Inject
    ELifecycleService lifecycleService;
    @Inject
    IPresentationEngine presentationEngine;

    @PostConstruct
    void init(@NonNull IEventBroker eventBroker) {
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/basic/Window/x/*");
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/basic/Window/y/*");
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/basic/Window/width/*");
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/basic/Window/height/*");
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/ui/UILabel/label/*");
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/ui/UILabel/tooltip/*");
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/ui/UIElement/visible/*");
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this::handleChildrenEvent);
        eventBroker.subscribe("org/eclipse/e4/ui/model/basic/Window/windows/*", this::handleChildrenEvent);
        eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/bringToTop", BaseWindowRenderer::handleBringToTop);
        EventProcessor.attachVisibleProcessor(eventBroker, this);
    }

    static void handleBringToTop(Event event) {
        WWidget widget;
        MWindow w;
        Object changedObj = event.getProperty("ChangedElement");
        if (changedObj instanceof MWindow && ((MUIElement)changedObj).getParent() == null && (w = (MWindow)changedObj).getWidget() instanceof WWidget && (widget = (WWidget)w.getWidget()) != null) {
            widget.activate();
        }
    }

    void handleChildrenEvent(Event event) {
        MWindow window;
        Object changedObj = event.getProperty("ChangedElement");
        if (changedObj instanceof MWindow && this == (window = (MWindow)changedObj).getRenderer()) {
            String eventType = (String)event.getProperty("EventType");
            if ("ADD".equals(eventType)) {
                MUIElement element = (MUIElement)event.getProperty("NewValue");
                if (element instanceof MWindow) {
                    this.handleWindowAdd((MWindow)element);
                } else if (element instanceof MWindowElement) {
                    this.handleChildAdd(window, (MWindowElement)element);
                }
            } else if ("REMOVE".equals(eventType)) {
                MUIElement element = (MUIElement)event.getProperty("OldValue");
                if (element instanceof MWindow) {
                    this.handleWindowRemove(window, (MWindow)element);
                } else if (element instanceof MWindowElement) {
                    this.handleChildRemove(window, (MWindowElement)element);
                }
            }
        }
    }

    void handleWindowAdd(@NonNull MWindow element) {
        this.engineCreateWidget(element);
    }

    void handleWindowRemove(@NonNull MWindow parent, @NonNull MWindow element) {
        if (element.isToBeRendered() && element.getWidget() != null) {
            this.hideChild(parent, (MUIElement)element);
        }
    }

    void handleChildAdd(@NonNull MWindow window, @NonNull MWindowElement element) {
        if (element.getWidget() != null) {
            this.childRendered(window, (MUIElement)element);
        } else {
            this.engineCreateWidget(element);
        }
    }

    void handleChildRemove(@NonNull MWindow window, MWindowElement element) {
        if (element.isToBeRendered() && element.getWidget() != null) {
            this.hideChild(window, (MUIElement)element);
        }
    }

    @Override
    protected void initWidget(final @NonNull MWindow element, @NonNull WWindow<N> widget) {
        widget.registerActivationCallback(new WCallback<Boolean, Void>(){

            @Override
            public Void call(Boolean param) {
                if (param.booleanValue()) {
                    MElementContainer parentME = element.getParent();
                    if (parentME instanceof MApplication) {
                        MApplication app = (MApplication)parentME;
                        app.setSelectedElement((MUIElement)element);
                        element.getContext().activate();
                    } else if (parentME == null && (parentME = (MUIElement)((EObject)element).eContainer()) instanceof MContext) {
                        element.getContext().activate();
                    }
                }
                return null;
            }
        });
        widget.setOnCloseCallback(new WCallback<WWindow<N>, Boolean>(){

            @Override
            public Boolean call(WWindow<N> param) {
                MWindow element2;
                @Nullable IEclipseContext modelContext = BaseWindowRenderer.this.getModelContext((MUIElement)element);
                if (modelContext != null) {
                    boolean close;
                    IWindowCloseHandler closeHandler = (IWindowCloseHandler)modelContext.get(IWindowCloseHandler.class);
                    if (closeHandler != null && !(close = closeHandler.close(element))) {
                        return Boolean.FALSE;
                    }
                    if (!BaseWindowRenderer.this.lifecycleService.validateAnnotation(PreClose.class, (MUIElement)element, modelContext)) {
                        return Boolean.FALSE;
                    }
                } else {
                    BaseWindowRenderer.this.logger.error("No model context attached to " + element);
                }
                if ((element2 = (MWindow)param.getDomElement()) != null) {
                    if (!(element2.getParent() instanceof MApplication)) {
                        BaseWindowRenderer.this.presentationEngine.removeGui((MUIElement)element2);
                        element2.setToBeRendered(false);
                    } else if (element2.getParent().getChildren().stream().filter(c -> c.isToBeRendered()).count() > 1L) {
                        BaseWindowRenderer.this.presentationEngine.removeGui((MUIElement)element2);
                        element2.setToBeRendered(false);
                    } else {
                        BaseWindowRenderer.this.presentationEngine.removeGui((MUIElement)element2);
                    }
                }
                if (element2 != null && BaseWindowRenderer.this.shouldRemoveWindowFromModel(element2)) {
                    BaseWindowRenderer.this.presentationEngine.removeGui((MUIElement)element2);
                    EObject eo = (EObject)element2;
                    EStructuralFeature feature = eo.eContainingFeature();
                    if (feature.isMany()) {
                        List l = (List)eo.eContainer().eGet(feature);
                        l.remove(eo);
                    } else {
                        eo.eContainer().eSet(feature, null);
                    }
                }
                return Boolean.TRUE;
            }
        });
        IEclipseContext modelContext = this.getModelContext((MUIElement)element);
        if (modelContext != null) {
            modelContext.set(ISaveHandler.class, (Object)new DefaultSaveHandler(element, widget));
        } else {
            this.getLogger().error("The model context is null which is not expected at this point");
        }
    }

    protected boolean shouldRemoveWindowFromModel(MWindow element) {
        return element != null && ((EObject)element).eContainer() instanceof MApplication && element.getTags().contains(TAG_REMOVE_ON_HIDE);
    }

    protected abstract @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ISaveHandler.Save> promptToSave(@NonNull MWindow var1, @NonNull Collection<MPart> var2, @NonNull WWindow<N> var3);

    protected abstract ISaveHandler.Save promptToSave(@NonNull MWindow var1, @NonNull MPart var2, @NonNull WWindow<N> var3);

    @Override
    public void doProcessContent(MWindow element) {
        MaximizationService maxService;
        MUIElement maxElement;
        WWidget widget;
        WLayoutedWidget menuWidget;
        WWindow windowWidget = (WWindow)this.getWidget((MUIElement)element);
        if (windowWidget == null) {
            this.getLogger().error("Could not find widget for '" + element + "'");
            return;
        }
        Object nativeWidget = windowWidget.getWidget();
        element.getContext().set(nativeWidget.getClass().getName(), nativeWidget);
        if (element.getMainMenu() != null && (menuWidget = (WLayoutedWidget)this.engineCreateWidget(element.getMainMenu())) != null) {
            windowWidget.setMainMenu(menuWidget);
        }
        if (element instanceof MTrimmedWindow) {
            for (MTrimBar tm : ((MTrimmedWindow)element).getTrimBars()) {
                WLayoutedWidget trimWidget;
                if (!tm.isToBeRendered() || !this.isChildRenderedAndVisible((MUIElement)tm) || (trimWidget = (WLayoutedWidget)this.engineCreateWidget(tm)) == null) continue;
                trimWidget.addStyleClasses(tm.getSide().name());
                switch (tm.getSide()) {
                    case TOP: {
                        windowWidget.setTopTrim(trimWidget);
                        break;
                    }
                    case RIGHT: {
                        windowWidget.setRightTrim(trimWidget);
                        break;
                    }
                    case BOTTOM: {
                        windowWidget.setBottomTrim(trimWidget);
                        break;
                    }
                    case LEFT: {
                        windowWidget.setLeftTrim(trimWidget);
                        break;
                    }
                }
            }
        }
        for (MWindowElement e : element.getChildren()) {
            widget = (WLayoutedWidget)this.engineCreateWidget(e);
            if (widget == null || !this.isChildRenderedAndVisible((MUIElement)e)) continue;
            windowWidget.addChild((WLayoutedWidget<MWindowElement>)widget);
        }
        for (MWindow w : element.getWindows()) {
            widget = (WWindow)this.engineCreateWidget(w);
            if (widget == null || !this.isChildRenderedAndVisible((MUIElement)w)) continue;
            windowWidget.addChildWindow((WWindow<?>)widget);
        }
        String maxElementId = (String)element.getPersistedState().get("MAXIMIZED");
        if (maxElementId != null && (maxElement = this.modelService.find(maxElementId, (MUIElement)element)) != null && (maxService = (MaximizationService)element.getContext().get(MaximizationService.class)) != null) {
            maxService.maximize(maxElement);
        }
    }

    @Override
    public void postProcess(MWindow element) {
        WWindow window;
        super.postProcess(element);
        if (((EObject)element).eContainer() instanceof MApplication && this.isChildRenderedAndVisible((MUIElement)element) && (window = (WWindow)this.getWidget((MUIElement)element)) != null) {
            window.show();
        }
        this.activateLeafPart((MUIElement)element);
    }

    public void childRendered(MWindow parentElement, MUIElement element) {
        if (this.inContentProcessing((MUIElement)parentElement) || !this.isChildRenderedAndVisible(element)) {
            return;
        }
        if (element instanceof MWindowElement) {
            WWindow window = (WWindow)this.getWidget((MUIElement)parentElement);
            if (window != null) {
                int idx = this.getRenderedIndex((MUIElement)parentElement, element);
                WLayoutedWidget widget = (WLayoutedWidget)element.getWidget();
                if (widget != null) {
                    window.addChild(idx, widget);
                } else {
                    this.logger.error("Widget for element '" + element + "' should not be null");
                }
            }
        } else if (element instanceof MWindow) {
            WWindow window = (WWindow)this.getWidget((MUIElement)parentElement);
            if (window != null) {
                WWindow ww = (WWindow)element.getWidget();
                if (ww != null) {
                    window.addChildWindow(ww);
                } else {
                    this.logger.error("Widget for element '" + element + "' should not be null");
                }
            }
        } else if (element instanceof MTrimBar) {
            MTrimBar tm = (MTrimBar)element;
            WTrimBar trimWidget = (WTrimBar)element.getWidget();
            WWindow windowWidget = (WWindow)parentElement.getWidget();
            if (trimWidget != null) {
                trimWidget.addStyleClasses(tm.getSide().name());
                switch (tm.getSide()) {
                    case TOP: {
                        windowWidget.setTopTrim(trimWidget);
                        break;
                    }
                    case RIGHT: {
                        windowWidget.setRightTrim(trimWidget);
                        break;
                    }
                    case BOTTOM: {
                        windowWidget.setBottomTrim(trimWidget);
                        break;
                    }
                    case LEFT: {
                        windowWidget.setLeftTrim(trimWidget);
                        break;
                    }
                }
            }
        }
    }

    public void hideChild(MWindow container, MUIElement changedObj) {
        WWindow windowWidget;
        if (changedObj instanceof MWindowElement) {
            WWindow window = (WWindow)this.getWidget((MUIElement)container);
            if (window != null) {
                WLayoutedWidget widget = (WLayoutedWidget)changedObj.getWidget();
                if (widget != null) {
                    window.removeChild(widget);
                } else {
                    this.logger.error("Widget for element '" + changedObj + "' should not be null");
                }
            }
        } else if (changedObj instanceof MWindow) {
            WWindow window = (WWindow)this.getWidget((MUIElement)container);
            if (window != null) {
                WWindow ww = (WWindow)changedObj.getWidget();
                if (ww != null) {
                    window.removeChildWindow(ww);
                } else {
                    this.logger.error("Widget for element '" + changedObj + "' should not be null");
                }
            }
        } else if (changedObj instanceof MTrimBar && (windowWidget = (WWindow)this.getWidget((MUIElement)container)) != null) {
            MTrimBar tm = (MTrimBar)changedObj;
            WTrimBar trimWidget = (WTrimBar)changedObj.getWidget();
            if (trimWidget != null) {
                trimWidget.addStyleClasses(tm.getSide().name());
                switch (tm.getSide()) {
                    case TOP: {
                        windowWidget.setTopTrim(null);
                        break;
                    }
                    case RIGHT: {
                        windowWidget.setRightTrim(null);
                        break;
                    }
                    case BOTTOM: {
                        windowWidget.setBottomTrim(null);
                        break;
                    }
                    case LEFT: {
                        windowWidget.setLeftTrim(null);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void destroyWidget(MWindow element) {
        if (element.getWidget() instanceof WWindow) {
            WWindow w = (WWindow)element.getWidget();
            w.close();
        }
        super.destroyWidget(element);
    }

    private class DefaultSaveHandler
    implements ISaveHandler {
        private @NonNull MWindow element;
        private @NonNull WWindow<N> widget;

        DefaultSaveHandler(@NonNull MWindow element, WWindow<N> widget) {
            this.element = element;
            this.widget = widget;
        }

        public boolean saveParts(Collection<MPart> dirtyParts, boolean confirm) {
            if (confirm) {
                ISaveHandler.Save[] decisions;
                List<MPart> dirtyPartsList = Collections.unmodifiableList(new ArrayList<MPart>(dirtyParts));
                ISaveHandler.Save[] saveArray = decisions = this.promptToSave(dirtyPartsList);
                int n = decisions.length;
                int n2 = 0;
                while (n2 < n) {
                    ISaveHandler.Save decision = saveArray[n2];
                    if (decision == ISaveHandler.Save.CANCEL) {
                        return false;
                    }
                    ++n2;
                }
                int i = 0;
                while (i < decisions.length) {
                    if (decisions[i] == ISaveHandler.Save.YES && !this.save(dirtyPartsList.get(i), false)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            for (MPart dirtyPart : dirtyParts) {
                if (this.save(dirtyPart, false)) continue;
                return false;
            }
            return true;
        }

        public boolean save(MPart dirtyPart, boolean confirm) {
            if (confirm) {
                switch (this.promptToSave(dirtyPart)) {
                    case NO: {
                        return true;
                    }
                    case CANCEL: {
                        return false;
                    }
                }
            }
            Object client = dirtyPart.getObject();
            try {
                ContextInjectionFactory.invoke((Object)client, Persist.class, (IEclipseContext)dirtyPart.getContext());
            }
            catch (InjectionException e) {
                BaseWindowRenderer.this.getLogger().error("Failed to persist contents of part", (Throwable)e);
                return false;
            }
            catch (RuntimeException e) {
                BaseWindowRenderer.this.getLogger().error("Failed to persist contents of part via DI", (Throwable)e);
                return false;
            }
            return true;
        }

        public ISaveHandler.Save[] promptToSave(Collection<MPart> dirtyParts) {
            return BaseWindowRenderer.this.promptToSave(this.element, dirtyParts, this.widget).toArray(new ISaveHandler.Save[0]);
        }

        public ISaveHandler.Save promptToSave(MPart dirtyPart) {
            return BaseWindowRenderer.this.promptToSave(this.element, dirtyPart, this.widget);
        }
    }
}

