/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.core.URI;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.workbench.renderers.base.BasePartRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenu;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPart;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WToolBar;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.CustomContainerSupport;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DefPartRenderer
extends BasePartRenderer<Pane, Node, Node> {
    protected Class<? extends WPart<Pane, Node, Node>> getWidgetClass(MPart part) {
        return PartImpl.class;
    }

    protected boolean requiresFocus(WPart<Pane, Node, Node> widget) {
        return true;
    }

    public void focus(MUIElement element) {
        super.focus(element);
        if (element.getWidget() instanceof WPart) {
            WPart part = (WPart)element.getWidget();
            if (part == null) {
                return;
            }
            if (!DefPartRenderer.checkFocusControl((Node)part.getWidget())) {
                Node node = (Node)part.getWidget();
                node.requestFocus();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    static boolean checkFocusControl(Node check) {
        if (check.getScene() == null) {
            return false;
        }
        n = check.getScene().getFocusOwner();
        if (n != null) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            if (n.getParent() == check) {
                return true;
            }
            n = n.getParent();
lbl9:
            // 2 sources

            ** while (n.getParent() != null)
        }
lbl10:
        // 1 sources

        return false;
    }

    static class HandleGroup
    extends Group {
        public double minHeight(double width) {
            return 11.0;
        }

        public double maxWidth(double height) {
            return 20.0;
        }

        public HandleGroup() {
            Rectangle r = new Rectangle(16.0, 1.0);
            r.setFill((Paint)Color.WHITE);
            r.setStroke((Paint)Color.BLACK);
            r.setLayoutX(0.0);
            r.setLayoutY(1.0);
            r.setStrokeType(StrokeType.OUTSIDE);
            this.getChildren().add((Object)r);
            r = new Rectangle(16.0, 1.0);
            r.setFill((Paint)Color.WHITE);
            r.setStroke((Paint)Color.BLACK);
            r.setLayoutX(0.0);
            r.setLayoutY(4.0);
            r.setStrokeType(StrokeType.OUTSIDE);
            this.getChildren().add((Object)r);
            r = new Rectangle(16.0, 1.0);
            r.setFill((Paint)Color.WHITE);
            r.setStroke((Paint)Color.BLACK);
            r.setLayoutX(0.0);
            r.setLayoutY(7.0);
            r.setStrokeType(StrokeType.OUTSIDE);
            this.getChildren().add((Object)r);
        }
    }

    static class PartImpl
    extends WLayoutedWidgetImpl<Pane, AnchorPane, MPart>
    implements WPart<Pane, Node, Node> {
        @Inject
        @NonNull IEclipseContext context;
        @Inject
        private GraphicsLoader graphicsLoader;
        AnchorPane contentArea;
        private BorderPane dataArea;
        private StackPane expandGroup;
        StackPane toolbarGroup;
        Group menuGroup;
        private WMenu<Node> viewMenuWidget;
        private WToolBar<Node> viewToolbarWidget;
        private StackPane overlayContainer;
        private Label titleLabel;
        private MPart domElement;

        @Inject
        public PartImpl(@Named(value="fx.rendering.domElement") @NonNull MPart domElement) {
            this.domElement = domElement;
        }

        @Override
        protected Pane createWidget() {
            Pane tmp = CustomContainerSupport.createContainerPane(this.logger, this.context);
            final Pane p = tmp == null ? new BorderPane() : tmp;
            p.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    MPart domElement = (MPart)this.getDomElement();
                    if (domElement != null) {
                        ((EPartService)domElement.getContext().get(EPartService.class)).activate(domElement, true);
                        if (!DefPartRenderer.checkFocusControl((Node)this.getWidget()) && domElement.getObject() != null) {
                            p.requestFocus();
                        }
                    }
                }
            });
            return p;
        }

        @Override
        public AnchorPane getWidgetNode() {
            if (this.contentArea == null) {
                this.menuGroup = new Group();
                this.menuGroup.setVisible(false);
                this.menuGroup.setManaged(false);
                this.expandGroup = new StackPane();
                this.expandGroup.getStyleClass().add((Object)"part-expand-group");
                this.expandGroup.setOpacity(0.5);
                HandleGroup handler = new HandleGroup();
                handler.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        toolbarGroup.getParent().setVisible(true);
                    }
                });
                this.expandGroup.getChildren().add((Object)handler);
                this.contentArea = new AnchorPane(){

                    protected void layoutChildren() {
                        super.layoutChildren();
                        if (menuGroup.isVisible()) {
                            menuGroup.relocate(contentArea.getWidth() - 20.0, 0.0);
                        }
                    }
                };
                this.dataArea = new BorderPane();
                if (this.domElement != null && this.domElement.getTags().contains("showTopTrimArea")) {
                    HBox box = new HBox();
                    box.getStyleClass().add((Object)"tool-bar");
                    this.titleLabel = new Label();
                    box.getChildren().add((Object)this.titleLabel);
                    this.dataArea.setTop((Node)box);
                }
                AnchorPane.setTopAnchor((Node)this.dataArea, (Double)0.0);
                AnchorPane.setLeftAnchor((Node)this.dataArea, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)this.dataArea, (Double)0.0);
                AnchorPane.setRightAnchor((Node)this.dataArea, (Double)0.0);
                this.contentArea.getChildren().addAll((Object[])new Node[]{this.dataArea, this.menuGroup});
                Node n = (Node)this.getWidget();
                n.getStyleClass().add((Object)"part-content");
                this.dataArea.setCenter(n);
            }
            return this.contentArea;
        }

        private void initToolbarMenu() {
            if (this.toolbarGroup == null) {
                this.getStaticLayoutNode();
                this.toolbarGroup = new StackPane();
                MPart element = (MPart)this.getDomElement();
                if (element != null && element.getTags().contains("Part-Toolbar-FullSpan")) {
                    final BorderPane p = new BorderPane();
                    p.setCenter((Node)this.toolbarGroup);
                    p.getStyleClass().add((Object)"view-toolbar-container");
                    if (element.getTags().contains("Part-ToolBarMenu-Floating")) {
                        AnchorPane.setLeftAnchor((Node)p, (Double)0.0);
                        AnchorPane.setRightAnchor((Node)p, (Double)0.0);
                        AnchorPane.setTopAnchor((Node)p, (Double)0.0);
                        this.contentArea.getChildren().add((Object)p);
                        p.setVisible(false);
                        this.dataArea.setTop((Node)this.expandGroup);
                        this.expandGroup.setVisible(true);
                        p.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                            public void handle(MouseEvent event) {
                                p.setVisible(false);
                            }
                        });
                    } else if (element.getTags().contains("Part-ToolBarMenu-Bottom")) {
                        this.dataArea.setBottom((Node)p);
                    } else {
                        this.dataArea.setTop((Node)p);
                    }
                } else {
                    BorderPane p = new BorderPane();
                    p.setRight((Node)this.toolbarGroup);
                    p.getStyleClass().add((Object)"view-toolbar-container");
                    if (element != null && element.getTags().contains("Part-ToolBarMenu-Bottom")) {
                        this.dataArea.setBottom((Node)p);
                    } else {
                        this.dataArea.setTop((Node)p);
                    }
                }
            }
        }

        public void setToolbar(WToolBar<Node> widget) {
            if (widget == null) {
                if (this.toolbarGroup != null) {
                    this.toolbarGroup.getChildren().clear();
                    this.dataArea.setTop(null);
                    this.dataArea.setBottom(null);
                    this.toolbarGroup = null;
                }
            } else {
                this.initToolbarMenu();
                Node n = (Node)widget.getWidget();
                n.addEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        MPart element = (MPart)this.getDomElement();
                        if (element != null && element.getTags().contains("Part-ToolBarMenu-Floating")) {
                            toolbarGroup.getParent().setVisible(false);
                        }
                    }
                });
                n.getStyleClass().add((Object)"view-toolbar");
                this.toolbarGroup.getChildren().setAll((Object[])new Node[]{n});
            }
            this.viewToolbarWidget = widget;
        }

        public void setMenu(WMenu<Node> widget) {
            if (widget == null) {
                if (this.menuGroup != null) {
                    this.menuGroup.setVisible(false);
                    this.menuGroup.getChildren().clear();
                }
            } else {
                this.menuGroup.setVisible(true);
                this.menuGroup.getChildren().setAll((Object[])new Node[]{(Node)widget.getWidget()});
                this.contentArea.requestLayout();
            }
            this.viewMenuWidget = widget;
        }

        public WMenu<Node> getMenu() {
            return this.viewMenuWidget;
        }

        public @Nullable WToolBar<Node> getToolbar() {
            return this.viewToolbarWidget;
        }

        @Inject
        public void setLabel(@Named(value="localizedLabel") String label) {
            this.getWidget();
            if (this.titleLabel != null) {
                this.titleLabel.setText(label);
            }
        }

        @Inject
        public void setGraphic(@Named(value="iconURI") String iconURI) {
            this.getWidget();
            if (this.titleLabel != null) {
                if (iconURI != null) {
                    this.titleLabel.setGraphic(this.graphicsLoader.getGraphicsNode(URI.create((String)iconURI)));
                } else {
                    this.titleLabel.setGraphic(null);
                }
            }
        }

        public void setDialog(Object dialogNode) {
            @NonNull Pane staticLayoutNode = (Pane)this.getStaticLayoutNode();
            if (dialogNode == null) {
                if (this.overlayContainer != null) {
                    staticLayoutNode.getChildren().remove((Object)this.overlayContainer);
                    this.overlayContainer.getChildren().clear();
                }
            } else {
                if (this.overlayContainer == null) {
                    this.overlayContainer = new StackPane();
                    this.overlayContainer.getStyleClass().add((Object)"overlay-container");
                    this.overlayContainer.setManaged(false);
                    this.overlayContainer.setMouseTransparent(false);
                    staticLayoutNode.layoutBoundsProperty().addListener(o -> {
                        staticLayoutNode.layoutBoundsProperty().get();
                        this.overlayContainer.resize(staticLayoutNode.getWidth(), staticLayoutNode.getHeight());
                    });
                }
                this.overlayContainer.resize(staticLayoutNode.getWidth(), staticLayoutNode.getHeight());
                this.overlayContainer.getChildren().setAll((Object[])new Node[]{(Node)dialogNode});
                staticLayoutNode.getChildren().add((Object)this.overlayContainer);
            }
        }
    }
}

