/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.analyzer;

import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.tools.analyzer.IUAnalyzer;

public class VersionAnalyzer
extends IUAnalyzer {
    public void analyzeIU(IInstallableUnit iu) {
        String qualifier;
        if (iu.getVersion().equals(Version.emptyVersion)) {
            this.error(iu, "[ERROR] IU: " + iu.getId() + " has not replaced its qualifiier");
            return;
        }
        if (iu.getVersion().isOSGiCompatible() && (qualifier = VersionAnalyzer.toOSGiVersion(iu.getVersion()).getQualifier()) != null && qualifier.equals("qualifier")) {
            this.error(iu, "[ERROR] IU: " + iu.getId() + " has not replaced its qualifiier");
            return;
        }
    }

    private static org.osgi.framework.Version toOSGiVersion(Version version) {
        if (version == null) {
            return null;
        }
        if (version == Version.emptyVersion) {
            return org.osgi.framework.Version.emptyVersion;
        }
        if (version == Version.MAX_VERSION) {
            return new org.osgi.framework.Version(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        return new org.osgi.framework.Version(version.toString());
    }

    public void preAnalysis(IMetadataRepository repo) {
    }
}

