/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationAnnotationValue;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmByteAnnotationValue;
import org.eclipse.xtext.common.types.JvmCharAnnotationValue;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmCustomAnnotationValue;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmDoubleAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFloatAnnotationValue;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmIntAnnotationValue;
import org.eclipse.xtext.common.types.JvmLongAnnotationValue;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmShortAnnotationValue;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.documentation.IEObjectDocumentationProviderExtension;
import org.eclipse.xtext.documentation.IFileHeaderProvider;
import org.eclipse.xtext.documentation.IJavaDocTypeReferenceProvider;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.trace.AbsoluteURI;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.ITraceURIConverter;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.DisableCodeGenerationAdapter;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.compiler.ErrorSafeExtensions;
import org.eclipse.xtext.xbase.compiler.FileHeaderAdapter;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.JavaKeywords;
import org.eclipse.xtext.xbase.compiler.LoopExtensions;
import org.eclipse.xtext.xbase.compiler.LoopParams;
import org.eclipse.xtext.xbase.compiler.TreeAppendableUtil;
import org.eclipse.xtext.xbase.compiler.XbaseCompiler;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.compiler.output.ImportingStringConcatenation;
import org.eclipse.xtext.xbase.compiler.output.SharedAppendableState;
import org.eclipse.xtext.xbase.compiler.output.TreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public class JvmModelGenerator
implements IGenerator {
    @Inject
    @Extension
    protected ILogicalContainerProvider _iLogicalContainerProvider;
    @Inject
    @Extension
    protected TypeReferences _typeReferences;
    @Inject
    @Extension
    protected TreeAppendableUtil _treeAppendableUtil;
    @Inject
    @Extension
    protected JvmTypeExtensions _jvmTypeExtensions;
    @Inject
    @Extension
    protected LoopExtensions _loopExtensions;
    @Inject
    @Extension
    protected ErrorSafeExtensions _errorSafeExtensions;
    @Inject
    private CommonTypeComputationServices commonServices;
    @Inject
    private XbaseCompiler compiler;
    @Inject
    private ILocationInFileProvider locationProvider;
    @Inject
    private IEObjectDocumentationProvider documentationProvider;
    @Inject
    private IFileHeaderProvider fileHeaderProvider;
    @Inject
    private IJvmModelAssociations jvmModelAssociations;
    @Inject
    private JavaKeywords keywords;
    @Inject
    private IGeneratorConfigProvider generatorConfigProvider;
    @Inject
    private ITraceURIConverter converter;
    @Inject
    private IJavaDocTypeReferenceProvider javaDocTypeReferenceProvider;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public void doGenerate(Resource input, IFileSystemAccess fsa) {
        EList _contents = input.getContents();
        for (EObject obj : _contents) {
            this.internalDoGenerate(obj, fsa);
        }
    }

    protected void _internalDoGenerate(EObject obj, IFileSystemAccess fsa) {
    }

    protected void _internalDoGenerate(JvmDeclaredType type, IFileSystemAccess fsa) {
        boolean _tripleNotEquals;
        boolean _isDisabled = DisableCodeGenerationAdapter.isDisabled(type);
        if (_isDisabled) {
            return;
        }
        String _qualifiedName = type.getQualifiedName();
        boolean bl = _tripleNotEquals = _qualifiedName != null;
        if (_tripleNotEquals) {
            String _replace = type.getQualifiedName().replace(".", "/");
            String _plus = String.valueOf(_replace) + ".java";
            fsa.generateFile(_plus, this.generateType(type, this.generatorConfigProvider.get((EObject)type)));
        }
    }

    protected ImportManager createImportManager(JvmDeclaredType type) {
        return new ImportManager(true, type);
    }

    public CharSequence generateType(JvmDeclaredType type, GeneratorConfig config) {
        boolean _not;
        boolean _tripleNotEquals;
        ImportManager importManager = this.createImportManager(type);
        TreeAppendable bodyAppendable = this.createAppendable((EObject)type, importManager, config);
        bodyAppendable.openScope();
        this.assignThisAndSuper(bodyAppendable, type, config);
        this.generateBody(type, bodyAppendable, config);
        bodyAppendable.closeScope();
        TreeAppendable importAppendable = this.createAppendable((EObject)type, importManager, config);
        this.generateFileHeader(type, importAppendable, config);
        String _packageName = type.getPackageName();
        boolean bl = _tripleNotEquals = _packageName != null;
        if (_tripleNotEquals) {
            importAppendable.append("package ").append(type.getPackageName()).append(";");
            importAppendable.newLine().newLine();
        }
        List<String> _imports = importManager.getImports();
        for (String i : _imports) {
            importAppendable.append("import ").append(i).append(";").newLine();
        }
        boolean _isEmpty = importManager.getImports().isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            importAppendable.newLine();
        }
        importAppendable.append(bodyAppendable);
        return importAppendable;
    }

    protected ITreeAppendable _generateBody(JvmGenericType it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _xblockexpression = null;
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable childAppendable = appendable.trace((EObject)it);
        this.generateAnnotations((Iterable<JvmAnnotationReference>)it.getAnnotations(), childAppendable, true, config);
        this.generateModifier((JvmMember)it, childAppendable, config);
        boolean _isInterface = it.isInterface();
        if (_isInterface) {
            childAppendable.append("interface ");
        } else {
            childAppendable.append("class ");
        }
        this._treeAppendableUtil.traceSignificant(childAppendable, (EObject)it).append(this.makeJavaIdentifier(it.getSimpleName()));
        this.generateTypeParameterDeclaration((JvmTypeParameterDeclarator)it, childAppendable, config);
        boolean _isEmpty = it.getTypeParameters().isEmpty();
        if (_isEmpty) {
            childAppendable.append(" ");
        }
        this.generateExtendsClause((JvmDeclaredType)it, childAppendable, config);
        this.generateMembersInBody((JvmDeclaredType)it, childAppendable, config);
        ITreeAppendable _xifexpression = null;
        if (!it.isAnonymous() && !(it.eContainer() instanceof JvmType)) {
            _xifexpression = appendable.newLine();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public ITreeAppendable generateMembersInBody(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _xblockexpression = null;
        appendable.append("{").increaseIndentation();
        Procedures.Procedure1 _function = it_1 -> it_1.setSeparator(this.memberSeparator());
        Procedures.Procedure1 _function_1 = it_1 -> {
            ITreeAppendable memberAppendable = this._treeAppendableUtil.traceWithComments(appendable, (EObject)it_1);
            memberAppendable.openScope();
            this.generateMember((JvmMember)it_1, memberAppendable, config);
            memberAppendable.closeScope();
        };
        this._loopExtensions.forEach(appendable, this.getMembersToBeCompiled(it), (Procedures.Procedure1<? super LoopParams>)_function, _function_1);
        _xblockexpression = appendable.decreaseIndentation().newLine().append("}");
        return _xblockexpression;
    }

    protected Functions.Function1<? super ITreeAppendable, ? extends ITreeAppendable> memberSeparator() {
        Functions.Function1 _function = it -> it.blankLine();
        return _function;
    }

    @Deprecated
    public ITreeAppendable generateAnnotationsWithSyntheticSuppressWarnings(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _tripleEquals;
        Functions.Function1 _function;
        ITreeAppendable _xblockexpression = null;
        Functions.Function1 noSuppressWarningsFilter = _function = it_1 -> {
            String _name;
            JvmAnnotationType _annotation = it_1.getAnnotation();
            String _identifier = null;
            if (_annotation != null) {
                _identifier = _annotation.getIdentifier();
            }
            return !Objects.equal((Object)_identifier, (Object)(_name = SuppressWarnings.class.getName()));
        };
        this.generateAnnotations(IterableExtensions.filter((Iterable)it.getAnnotations(), (Functions.Function1)noSuppressWarningsFilter), appendable, true, config);
        ITreeAppendable _xifexpression = null;
        EObject _eContainer = it.eContainer();
        boolean bl = _tripleEquals = _eContainer == null;
        if (_tripleEquals) {
            _xifexpression = appendable.append("@SuppressWarnings(\"all\")").newLine();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ITreeAppendable _generateBody(JvmEnumerationType it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _not;
        ITreeAppendable _xblockexpression = null;
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable childAppendable = appendable.trace((EObject)it);
        this.generateAnnotations((Iterable<JvmAnnotationReference>)it.getAnnotations(), childAppendable, true, config);
        this.generateModifier((JvmMember)it, childAppendable, config);
        childAppendable.append("enum ");
        this._treeAppendableUtil.traceSignificant(childAppendable, (EObject)it).append(this.makeJavaIdentifier(it.getSimpleName()));
        childAppendable.append(" ");
        this.generateExtendsClause((JvmDeclaredType)it, childAppendable, config);
        childAppendable.append("{").increaseIndentation();
        Procedures.Procedure1 _function = it_1 -> {
            Functions.Function1 _function_1 = it_2 -> it_2.append(",").blankLine();
            it_1.setSeparator((Functions.Function1<? super ITreeAppendable, ? extends ITreeAppendable>)_function_1);
            it_1.setSuffix(";");
        };
        Procedures.Procedure1 _function_1 = it_1 -> this.generateEnumLiteral((JvmEnumerationLiteral)it_1, childAppendable.trace((EObject)it_1), config);
        this._loopExtensions.forEach(childAppendable, it.getLiterals(), (Procedures.Procedure1<? super LoopParams>)_function, _function_1);
        Functions.Function1 _function_2 = it_1 -> !(it_1 instanceof JvmEnumerationLiteral);
        Procedures.Procedure1 _function_3 = it_1 -> it_1.setSeparator(this.memberSeparator());
        Procedures.Procedure1 _function_4 = it_1 -> this.generateMember((JvmMember)it_1, childAppendable.trace((EObject)it_1), config);
        this._loopExtensions.forEach(childAppendable, IterableExtensions.filter(this.getMembersToBeCompiled((JvmDeclaredType)it), (Functions.Function1)_function_2), (Procedures.Procedure1<? super LoopParams>)_function_3, _function_4);
        childAppendable.decreaseIndentation().newLine().append("}");
        ITreeAppendable _xifexpression = null;
        EObject _eContainer = it.eContainer();
        boolean bl = _not = !(_eContainer instanceof JvmType);
        if (_not) {
            _xifexpression = appendable.newLine();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void generateEnumLiteral(JvmEnumerationLiteral it, ITreeAppendable appendable, GeneratorConfig config) {
        appendable.newLine();
        this.generateJavaDoc((EObject)it, appendable, config);
        this.generateAnnotations((Iterable<JvmAnnotationReference>)it.getAnnotations(), appendable, true, config);
        appendable.append(this.makeJavaIdentifier(it.getSimpleName()));
    }

    protected ITreeAppendable _generateBody(JvmAnnotationType it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _not;
        ITreeAppendable _xblockexpression = null;
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable childAppendable = appendable.trace((EObject)it);
        this.generateAnnotations((Iterable<JvmAnnotationReference>)it.getAnnotations(), childAppendable, true, config);
        this.generateModifier((JvmMember)it, childAppendable, config);
        childAppendable.append("@interface ");
        this._treeAppendableUtil.traceSignificant(childAppendable, (EObject)it).append(this.makeJavaIdentifier(it.getSimpleName()));
        childAppendable.append(" {");
        Iterable _filter = Iterables.filter(this.getMembersToBeCompiled((JvmDeclaredType)it), JvmDeclaredType.class);
        for (JvmDeclaredType innerType : _filter) {
            ITreeAppendable innerTypeAppendable = childAppendable.trace((EObject)innerType);
            innerTypeAppendable.increaseIndentation();
            this.generateMember((JvmMember)innerType, innerTypeAppendable, config);
            innerTypeAppendable.decreaseIndentation();
        }
        Iterable _filter_1 = Iterables.filter(this.getMembersToBeCompiled((JvmDeclaredType)it), JvmOperation.class);
        for (JvmOperation operation : _filter_1) {
            this.generateAnnotationMethod(operation, childAppendable, config);
        }
        childAppendable.newLine().append("}");
        ITreeAppendable _xifexpression = null;
        EObject _eContainer = it.eContainer();
        boolean bl = _not = !(_eContainer instanceof JvmType);
        if (_not) {
            _xifexpression = appendable.newLine();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void generateAnnotationMethod(JvmOperation it, ITreeAppendable appendable, GeneratorConfig config) {
        appendable.increaseIndentation().newLine();
        appendable.openScope();
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        this.generateAnnotations((Iterable<JvmAnnotationReference>)it.getAnnotations(), tracedAppendable, true, config);
        this.generateModifier((JvmMember)it, tracedAppendable, config);
        this._errorSafeExtensions.serializeSafely(it.getReturnType(), "Object", tracedAppendable);
        tracedAppendable.append(" ");
        this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it).append(this.makeJavaIdentifier(it.getSimpleName()));
        tracedAppendable.append("()");
        this.generateDefaultExpression(it, tracedAppendable, config);
        tracedAppendable.append(";");
        appendable.decreaseIndentation();
        appendable.closeScope();
    }

    public void generateDefaultExpression(JvmOperation it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _tripleNotEquals;
        Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it);
        boolean bl = _tripleNotEquals = _compilationStrategy != null;
        if (_tripleNotEquals) {
            appendable.append(" default ");
            appendable.increaseIndentation();
            this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it).apply((Object)appendable);
            appendable.decreaseIndentation();
        } else {
            boolean _tripleNotEquals_1;
            StringConcatenationClient _compilationTemplate = this._jvmTypeExtensions.getCompilationTemplate((JvmIdentifiableElement)it);
            boolean bl2 = _tripleNotEquals_1 = _compilationTemplate != null;
            if (_tripleNotEquals_1) {
                appendable.append(" default ").increaseIndentation();
                this.appendCompilationTemplate(appendable, (JvmIdentifiableElement)it);
                appendable.decreaseIndentation();
            } else {
                boolean _isGenerateExpressions = config.isGenerateExpressions();
                if (_isGenerateExpressions) {
                    XExpression body = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)it);
                    if (body != null) {
                        boolean _hasErrors = this._errorSafeExtensions.hasErrors(body);
                        if (_hasErrors) {
                            appendable.append("/* skipped default expression with errors */");
                        } else {
                            appendable.append(" default ");
                            this.compiler.compileAsJavaExpression(body, appendable, it.getReturnType());
                        }
                    } else {
                        boolean _tripleNotEquals_2;
                        JvmAnnotationValue _defaultValue = it.getDefaultValue();
                        boolean bl3 = _tripleNotEquals_2 = _defaultValue != null;
                        if (_tripleNotEquals_2) {
                            boolean _hasErrors_1 = this._errorSafeExtensions.hasErrors((EObject)it.getDefaultValue());
                            if (_hasErrors_1) {
                                appendable.append("/* skipped default expression with errors */");
                            } else {
                                appendable.append(" default ");
                                this.toJavaLiteral(it.getDefaultValue(), appendable, config);
                            }
                        }
                    }
                }
            }
        }
    }

    protected void appendCompilationTemplate(ITreeAppendable appendable, JvmIdentifiableElement it) {
        boolean _matched = false;
        if (appendable instanceof TreeAppendable) {
            _matched = true;
            SharedAppendableState _state = ((TreeAppendable)appendable).getState();
            StandardTypeReferenceOwner _standardTypeReferenceOwner = new StandardTypeReferenceOwner(this.commonServices, (EObject)it);
            ImportingStringConcatenation target = this.createImportingStringConcatenation(_state, _standardTypeReferenceOwner);
            target.append(this._jvmTypeExtensions.getCompilationTemplate(it));
            ((TreeAppendable)appendable).append((CharSequence)((Object)target));
        }
        if (!_matched) {
            String _name = appendable.getClass().getName();
            String _plus = "unexpected appendable: " + _name;
            throw new IllegalStateException(_plus);
        }
    }

    protected ImportingStringConcatenation createImportingStringConcatenation(SharedAppendableState state, ITypeReferenceOwner owner) {
        return new ImportingStringConcatenation(state, owner);
    }

    protected ITreeAppendable _generateModifier(JvmGenericType it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _isFinal;
        boolean _not;
        ITreeAppendable _xblockexpression = null;
        this.generateVisibilityModifier((JvmMember)it, appendable);
        boolean _isInterface = it.isInterface();
        boolean bl = _not = !_isInterface;
        if (_not) {
            boolean _isAbstract;
            if (it.isStatic() && !this.isDeclaredWithinInterface((JvmMember)it)) {
                appendable.append("static ");
            }
            if (_isAbstract = it.isAbstract()) {
                appendable.append("abstract ");
            }
        }
        if (_isFinal = it.isFinal()) {
            appendable.append("final ");
        }
        ITreeAppendable _xifexpression = null;
        boolean _isStrictFloatingPoint = it.isStrictFloatingPoint();
        if (_isStrictFloatingPoint) {
            _xifexpression = appendable.append("strictfp ");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private boolean isDeclaredWithinInterface(JvmMember it) {
        return it.getDeclaringType() instanceof JvmGenericType && ((JvmGenericType)it.getDeclaringType()).isInterface();
    }

    protected ITreeAppendable _generateModifier(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        return this.generateVisibilityModifier((JvmMember)it, appendable);
    }

    protected ITreeAppendable _generateModifier(JvmField it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _isTransient;
        boolean _isFinal;
        ITreeAppendable _xblockexpression = null;
        this.generateVisibilityModifier((JvmMember)it, appendable);
        boolean _isStatic = it.isStatic();
        if (_isStatic) {
            appendable.append("static ");
        }
        if (_isFinal = it.isFinal()) {
            appendable.append("final ");
        }
        if (_isTransient = it.isTransient()) {
            appendable.append("transient ");
        }
        ITreeAppendable _xifexpression = null;
        boolean _isVolatile = it.isVolatile();
        if (_isVolatile) {
            _xifexpression = appendable.append("volatile ");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ITreeAppendable _generateModifier(JvmOperation it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _isStrictFloatingPoint;
        boolean _isSynchronized;
        boolean _isFinal;
        boolean _isStatic;
        ITreeAppendable _xblockexpression = null;
        this.generateVisibilityModifier((JvmMember)it, appendable);
        if (it.isAbstract() && !this.isDeclaredWithinInterface((JvmMember)it)) {
            appendable.append("abstract ");
        }
        if (_isStatic = it.isStatic()) {
            appendable.append("static ");
        }
        if (!it.isAbstract() && !it.isStatic() && config.getJavaSourceVersion().isAtLeast(JavaVersion.JAVA8) && this.isDeclaredWithinInterface((JvmMember)it)) {
            appendable.append("default ");
        }
        if (_isFinal = it.isFinal()) {
            appendable.append("final ");
        }
        if (_isSynchronized = it.isSynchronized()) {
            appendable.append("synchronized ");
        }
        if (_isStrictFloatingPoint = it.isStrictFloatingPoint()) {
            appendable.append("strictfp ");
        }
        ITreeAppendable _xifexpression = null;
        boolean _isNative = it.isNative();
        if (_isNative) {
            _xifexpression = appendable.append("native ");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public ITreeAppendable generateVisibilityModifier(JvmMember it, ITreeAppendable result) {
        return result.append(this.javaName(it.getVisibility()));
    }

    protected ITreeAppendable _generateModifier(JvmConstructor it, ITreeAppendable appendable, GeneratorConfig config) {
        return this.generateVisibilityModifier((JvmMember)it, appendable);
    }

    public String javaName(JvmVisibility visibility) {
        if (visibility != null) {
            String _switchResult = null;
            if (visibility != null) {
                switch (visibility) {
                    case PRIVATE: {
                        _switchResult = "private ";
                        break;
                    }
                    case PUBLIC: {
                        _switchResult = "public ";
                        break;
                    }
                    case PROTECTED: {
                        _switchResult = "protected ";
                        break;
                    }
                    case DEFAULT: {
                        _switchResult = "";
                        break;
                    }
                }
            }
            return _switchResult;
        }
        return "";
    }

    public void generateExtendsClause(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        String _switchResult = null;
        boolean _matched = false;
        if (it instanceof JvmAnnotationType) {
            _matched = true;
            _switchResult = "java.lang.Annotation";
        }
        if (!_matched && it instanceof JvmEnumerationType) {
            _matched = true;
            String _identifier = ((JvmEnumerationType)it).getIdentifier();
            String _plus = "java.lang.Enum<" + _identifier;
            _switchResult = String.valueOf(_plus) + ">";
        }
        if (!_matched) {
            _switchResult = "java.lang.Object";
        }
        String implicitSuperType = _switchResult;
        if (it instanceof JvmAnnotationType || it instanceof JvmGenericType && ((JvmGenericType)it).isInterface()) {
            Functions.Function1 _function = typeRef -> {
                String _identifier = typeRef.getIdentifier();
                return !Objects.equal((Object)_identifier, (Object)implicitSuperType);
            };
            Iterable withoutObject = IterableExtensions.filter((Iterable)it.getSuperTypes(), (Functions.Function1)_function);
            Procedures.Procedure1 _function_1 = it_1 -> {
                it_1.setPrefix("extends ");
                it_1.setSeparator(", ");
                it_1.setSuffix(" ");
            };
            Procedures.Procedure2 _function_2 = (it_1, app) -> this._errorSafeExtensions.serializeSafely((JvmTypeReference)it_1, (ITreeAppendable)app);
            this._errorSafeExtensions.forEachSafely(appendable, withoutObject, (Procedures.Procedure1<? super LoopParams>)_function_1, _function_2);
        } else {
            Functions.Function1 _function_3 = typeRef -> {
                String _identifier = typeRef.getIdentifier();
                return !Objects.equal((Object)_identifier, (Object)implicitSuperType);
            };
            Iterable withoutObject_1 = IterableExtensions.filter((Iterable)it.getSuperTypes(), (Functions.Function1)_function_3);
            Functions.Function1 _function_4 = typeRef -> typeRef.getType() instanceof JvmGenericType && !((JvmGenericType)typeRef.getType()).isInterface();
            JvmTypeReference superClazz = (JvmTypeReference)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)withoutObject_1, (Functions.Function1)_function_4));
            Functions.Function1 _function_5 = typeRef -> !Objects.equal((Object)typeRef, (Object)superClazz);
            Iterable superInterfaces = IterableExtensions.filter((Iterable)withoutObject_1, (Functions.Function1)_function_5);
            if (superClazz != null) {
                boolean hasErrors;
                block10: {
                    hasErrors = this._errorSafeExtensions.hasErrors((EObject)superClazz);
                    if (hasErrors) {
                        appendable.append("/* ");
                    }
                    try {
                        appendable.append("extends ");
                        this._errorSafeExtensions.serializeSafely(superClazz, appendable);
                        appendable.append(" ");
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) break block10;
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
                if (hasErrors) {
                    appendable.append(" */");
                }
            }
            Procedures.Procedure1 _function_6 = it_1 -> {
                it_1.setPrefix("implements ");
                it_1.setSeparator(", ");
                it_1.setSuffix(" ");
            };
            Procedures.Procedure2 _function_7 = (it_1, app) -> this._errorSafeExtensions.serializeSafely((JvmTypeReference)it_1, (ITreeAppendable)app);
            this._errorSafeExtensions.forEachSafely(appendable, superInterfaces, (Procedures.Procedure1<? super LoopParams>)_function_6, _function_7);
        }
    }

    protected ITreeAppendable _generateMember(JvmMember it, ITreeAppendable appendable, GeneratorConfig config) {
        Class<?> _class = null;
        if (it != null) {
            _class = it.getClass();
        }
        String _name = null;
        if (_class != null) {
            _name = _class.getName();
        }
        String _plus = "generateMember not implemented for elements of type " + _name;
        throw new UnsupportedOperationException(_plus);
    }

    protected ITreeAppendable _generateMember(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _xblockexpression = null;
        appendable.newLine();
        appendable.openScope();
        this.assignThisAndSuper(appendable, it, config);
        ITreeAppendable _xtrycatchfinallyexpression = null;
        try {
            _xtrycatchfinallyexpression = this.generateBody(it, appendable, config);
        }
        finally {
            appendable.closeScope();
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    protected ITreeAppendable _generateMember(JvmField it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _xblockexpression = null;
        appendable.newLine();
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        this.generateAnnotations((Iterable<JvmAnnotationReference>)it.getAnnotations(), tracedAppendable, true, config);
        this.generateModifier((JvmMember)it, tracedAppendable, config);
        this._errorSafeExtensions.serializeSafely(it.getType(), "Object", tracedAppendable);
        tracedAppendable.append(" ");
        String name = tracedAppendable.declareVariable(it, this.makeJavaIdentifier(it.getSimpleName()));
        this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it).append(name);
        this.generateInitialization(it, tracedAppendable, config);
        _xblockexpression = tracedAppendable.append(";");
        return _xblockexpression;
    }

    protected ITreeAppendable _generateMember(JvmOperation it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _tripleEquals;
        ITreeAppendable _xblockexpression = null;
        appendable.newLine();
        appendable.openScope();
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        this.generateAnnotations((Iterable<JvmAnnotationReference>)it.getAnnotations(), tracedAppendable, true, config);
        this.generateModifier((JvmMember)it, tracedAppendable, config);
        this.generateTypeParameterDeclaration((JvmTypeParameterDeclarator)it, tracedAppendable, config);
        JvmTypeReference _returnType = it.getReturnType();
        boolean bl = _tripleEquals = _returnType == null;
        if (_tripleEquals) {
            tracedAppendable.append("void");
        } else {
            this._errorSafeExtensions.serializeSafely(it.getReturnType(), "Object", tracedAppendable);
        }
        tracedAppendable.append(" ");
        this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it).append(this.makeJavaIdentifier(it.getSimpleName()));
        tracedAppendable.append("(");
        this.generateParameters((JvmExecutable)it, tracedAppendable, config);
        tracedAppendable.append(")");
        this.generateThrowsClause((JvmExecutable)it, tracedAppendable, config);
        if (it.isAbstract() || !this.hasBody((JvmExecutable)it)) {
            tracedAppendable.append(";");
        } else {
            tracedAppendable.append(" ");
            this.generateExecutableBody((JvmExecutable)it, tracedAppendable, config);
        }
        appendable.closeScope();
        _xblockexpression = appendable;
        return _xblockexpression;
    }

    protected ITreeAppendable _generateMember(JvmConstructor it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _xblockexpression = null;
        appendable.newLine();
        appendable.openScope();
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        this.generateAnnotations((Iterable<JvmAnnotationReference>)it.getAnnotations(), tracedAppendable, true, config);
        this.generateModifier((JvmMember)it, tracedAppendable, config);
        this.generateTypeParameterDeclaration((JvmTypeParameterDeclarator)it, tracedAppendable, config);
        this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it).append(this.makeJavaIdentifier(it.getSimpleName()));
        tracedAppendable.append("(");
        this.generateParameters((JvmExecutable)it, tracedAppendable, config);
        tracedAppendable.append(")");
        this.generateThrowsClause((JvmExecutable)it, tracedAppendable, config);
        tracedAppendable.append(" ");
        this.generateExecutableBody((JvmExecutable)it, tracedAppendable, config);
        appendable.closeScope();
        _xblockexpression = appendable;
        return _xblockexpression;
    }

    public void generateInitialization(JvmField it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _tripleNotEquals;
        Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it);
        boolean bl = _tripleNotEquals = _compilationStrategy != null;
        if (_tripleNotEquals) {
            Iterable<Issue> errors = this.getDirectErrorsOrLogicallyContainedErrors((JvmFeature)it);
            boolean _isEmpty = IterableExtensions.isEmpty(errors);
            if (_isEmpty) {
                appendable.append(" = ");
                appendable.increaseIndentation();
                this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it).apply((Object)appendable);
                appendable.decreaseIndentation();
            } else {
                appendable.append(" /* Skipped initializer because of errors */");
            }
        } else {
            boolean _tripleNotEquals_1;
            StringConcatenationClient _compilationTemplate = this._jvmTypeExtensions.getCompilationTemplate((JvmIdentifiableElement)it);
            boolean bl2 = _tripleNotEquals_1 = _compilationTemplate != null;
            if (_tripleNotEquals_1) {
                Iterable<Issue> errors_1 = this.getDirectErrorsOrLogicallyContainedErrors((JvmFeature)it);
                boolean _isEmpty_1 = IterableExtensions.isEmpty(errors_1);
                if (_isEmpty_1) {
                    appendable.append(" = ").increaseIndentation();
                    this.appendCompilationTemplate(appendable, (JvmIdentifiableElement)it);
                    appendable.decreaseIndentation();
                } else {
                    appendable.append(" /* Skipped initializer because of errors */");
                }
            } else {
                XExpression expression = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)it);
                if (expression != null && config.isGenerateExpressions()) {
                    boolean _hasErrors = this._errorSafeExtensions.hasErrors(expression);
                    if (_hasErrors) {
                        appendable.append(" /* Skipped initializer because of errors */");
                    } else {
                        appendable.append(" = ");
                        this.compiler.compileAsJavaExpression(expression, appendable, it.getType());
                    }
                }
            }
        }
    }

    public void generateTypeParameterDeclaration(JvmTypeParameterDeclarator it, ITreeAppendable appendable, GeneratorConfig config) {
        Procedures.Procedure1 _function = it_1 -> {
            it_1.setPrefix("<");
            it_1.setSeparator(", ");
            it_1.setSuffix("> ");
        };
        Procedures.Procedure1 _function_1 = it_1 -> this.generateTypeParameterDeclaration((JvmTypeParameter)it_1, appendable, config);
        this._loopExtensions.forEach(appendable, it.getTypeParameters(), (Procedures.Procedure1<? super LoopParams>)_function, _function_1);
    }

    public void generateTypeParameterDeclaration(JvmTypeParameter it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it).append(it.getName());
        this.generateTypeParameterConstraints(it, tracedAppendable, config);
    }

    public void generateTypeParameterConstraints(JvmTypeParameter it, ITreeAppendable appendable, GeneratorConfig config) {
        Iterable upperBounds = Iterables.filter((Iterable)it.getConstraints(), JvmUpperBound.class);
        Procedures.Procedure1 _function = it_1 -> {
            it_1.setPrefix(" extends ");
            it_1.setSeparator(" & ");
        };
        Procedures.Procedure2 _function_1 = (it_1, app) -> this._errorSafeExtensions.serializeSafely(it_1.getTypeReference(), (ITreeAppendable)app);
        this._errorSafeExtensions.forEachSafely(appendable, upperBounds, (Procedures.Procedure1<? super LoopParams>)_function, _function_1);
    }

    public void generateThrowsClause(JvmExecutable it, ITreeAppendable appendable, GeneratorConfig config) {
        LinkedHashMap toBeGenerated = CollectionLiterals.newLinkedHashMap();
        Consumer<JvmTypeReference> _function = it_1 -> {
            boolean _not;
            boolean _containsKey = toBeGenerated.containsKey(it_1.getType());
            boolean bl = _not = !_containsKey;
            if (_not) {
                toBeGenerated.put(it_1.getType(), it_1);
            }
        };
        it.getExceptions().forEach(_function);
        Procedures.Procedure1 _function_1 = it_1 -> {
            it_1.setPrefix(" throws ");
            it_1.setSeparator(", ");
        };
        Procedures.Procedure2 _function_2 = (it_1, app) -> app.trace((EObject)it_1).append(it_1.getType());
        this._errorSafeExtensions.forEachSafely(appendable, toBeGenerated.values(), (Procedures.Procedure1<? super LoopParams>)_function_1, _function_2);
    }

    public void generateParameters(JvmExecutable it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _not;
        boolean _isEmpty = it.getParameters().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            int _size = it.getParameters().size();
            int _minus = _size - 1;
            IntegerRange _upTo = new IntegerRange(0, _minus);
            for (Integer i : _upTo) {
                int _size_1 = it.getParameters().size();
                boolean last = i + 1 == _size_1;
                JvmFormalParameter p = (JvmFormalParameter)it.getParameters().get(i.intValue());
                this.generateParameter(p, appendable, last && it.isVarArgs(), config);
                if (last) continue;
                appendable.append(", ");
            }
        }
    }

    public void generateParameter(JvmFormalParameter it, ITreeAppendable appendable, boolean vararg, GeneratorConfig config) {
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        this.generateAnnotations((Iterable<JvmAnnotationReference>)it.getAnnotations(), tracedAppendable, false, config);
        tracedAppendable.append("final ");
        if (vararg) {
            boolean _not;
            JvmTypeReference _parameterType = it.getParameterType();
            boolean bl = _not = !(_parameterType instanceof JvmGenericArrayTypeReference);
            if (_not) {
                tracedAppendable.append("/* Internal Error: Parameter was vararg but not an array type. */");
            } else {
                JvmTypeReference _parameterType_1 = it.getParameterType();
                this._errorSafeExtensions.serializeSafely(((JvmGenericArrayTypeReference)_parameterType_1).getComponentType(), "Object", tracedAppendable);
            }
            tracedAppendable.append("...");
        } else {
            this._errorSafeExtensions.serializeSafely(it.getParameterType(), "Object", tracedAppendable);
        }
        tracedAppendable.append(" ");
        String name = tracedAppendable.declareVariable(it, this.makeJavaIdentifier(it.getSimpleName()));
        this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it).append(name);
    }

    public boolean hasBody(JvmExecutable it) {
        return this._jvmTypeExtensions.getCompilationTemplate((JvmIdentifiableElement)it) != null || this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it) != null || this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)it) != null;
    }

    private Iterable<Issue> getDirectErrorsOrLogicallyContainedErrors(JvmFeature feature) {
        XExpression expression;
        Iterable<Issue> errors = this._errorSafeExtensions.getErrors((EObject)feature);
        boolean _isEmpty = IterableExtensions.isEmpty(errors);
        if (_isEmpty && (expression = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)feature)) != null) {
            errors = this._errorSafeExtensions.getErrors(expression);
        }
        return errors;
    }

    public void generateExecutableBody(JvmExecutable op, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _tripleNotEquals;
        Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)op);
        boolean bl = _tripleNotEquals = _compilationStrategy != null;
        if (_tripleNotEquals) {
            Iterable<Issue> errors = this.getDirectErrorsOrLogicallyContainedErrors((JvmFeature)op);
            boolean _isEmpty = IterableExtensions.isEmpty(errors);
            if (_isEmpty) {
                appendable.increaseIndentation().append("{").newLine();
                this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)op).apply((Object)appendable);
                appendable.decreaseIndentation().newLine().append("}");
            } else {
                this.generateBodyWithIssues(op, appendable, errors);
            }
        } else {
            boolean _tripleNotEquals_1;
            StringConcatenationClient _compilationTemplate = this._jvmTypeExtensions.getCompilationTemplate((JvmIdentifiableElement)op);
            boolean bl2 = _tripleNotEquals_1 = _compilationTemplate != null;
            if (_tripleNotEquals_1) {
                Iterable<Issue> errors_1 = this.getDirectErrorsOrLogicallyContainedErrors((JvmFeature)op);
                boolean _isEmpty_1 = IterableExtensions.isEmpty(errors_1);
                if (_isEmpty_1) {
                    appendable.increaseIndentation().append("{").newLine();
                    this.appendCompilationTemplate(appendable, (JvmIdentifiableElement)op);
                    appendable.decreaseIndentation().newLine().append("}");
                } else {
                    this.generateBodyWithIssues(op, appendable, errors_1);
                }
            } else {
                XExpression expression = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)op);
                if (expression != null && config.isGenerateExpressions()) {
                    Iterable<Issue> errors_2 = this._errorSafeExtensions.getErrors(expression);
                    boolean _isEmpty_2 = IterableExtensions.isEmpty(errors_2);
                    if (_isEmpty_2) {
                        JvmTypeReference _switchResult = null;
                        boolean _matched = false;
                        if (op instanceof JvmOperation) {
                            _matched = true;
                            _switchResult = ((JvmOperation)op).getReturnType();
                        }
                        if (!_matched && op instanceof JvmConstructor) {
                            _matched = true;
                            _switchResult = this._typeReferences.getTypeForName(Void.TYPE, (Notifier)op, new JvmTypeReference[0]);
                        }
                        if (!_matched) {
                            _switchResult = null;
                        }
                        JvmTypeReference returnType = _switchResult;
                        appendable.append("{").increaseIndentation();
                        this.compile(op, expression, returnType, appendable, config);
                        appendable.decreaseIndentation().newLine().append("}");
                    } else {
                        this.generateBodyWithIssues(op, appendable, errors_2);
                    }
                } else if (op instanceof JvmOperation) {
                    appendable.increaseIndentation().append("{").newLine();
                    appendable.append("throw new UnsupportedOperationException(\"");
                    appendable.append(((JvmOperation)op).getSimpleName());
                    appendable.append(" is not implemented\");");
                    appendable.decreaseIndentation().newLine().append("}");
                } else if (op instanceof JvmConstructor) {
                    appendable.append("{").newLine().append("}");
                }
            }
        }
    }

    public ITreeAppendable compile(JvmExecutable executable, XExpression expression, JvmTypeReference returnType, ITreeAppendable appendable, GeneratorConfig config) {
        return this.compiler.compile(expression, appendable, returnType, (Set<JvmTypeReference>)IterableExtensions.toSet((Iterable)executable.getExceptions()));
    }

    public void assignThisAndSuper(ITreeAppendable b, JvmDeclaredType declaredType, GeneratorConfig config) {
        this.reassignSuperType(b, declaredType, config);
        this.reassignThisType(b, declaredType);
    }

    private String reassignSuperType(ITreeAppendable b, JvmDeclaredType declaredType, GeneratorConfig config) {
        boolean _isAtLeast;
        Object superElement;
        String superVariable;
        boolean _equals;
        Object element;
        String _xblockexpression = null;
        JvmTypeReference _extendedClass = declaredType.getExtendedClass();
        JvmType _type = null;
        if (_extendedClass != null) {
            _type = _extendedClass.getType();
        }
        JvmType superType = _type;
        boolean _hasObject = b.hasObject("super");
        if (_hasObject && (element = b.getObject("this")) instanceof JvmDeclaredType && (_equals = "super".equals(superVariable = b.getName(superElement = b.getObject("super"))))) {
            String _simpleName = ((JvmDeclaredType)element).getSimpleName();
            String proposedName = String.valueOf(_simpleName) + ".super";
            b.declareVariable(superElement, proposedName);
        }
        if (_isAtLeast = config.getJavaSourceVersion().isAtLeast(JavaVersion.JAVA8)) {
            Iterable _extendedInterfaces = declaredType.getExtendedInterfaces();
            for (JvmTypeReference interfaceRef : _extendedInterfaces) {
                JvmType interfaze = interfaceRef.getType();
                String _simpleName_1 = interfaze.getSimpleName();
                String simpleVarName = String.valueOf(_simpleName_1) + ".super";
                boolean _hasObject_1 = b.hasObject(simpleVarName);
                if (_hasObject_1) {
                    boolean _notEquals;
                    Object element_1 = b.getObject(simpleVarName);
                    boolean bl = _notEquals = !Objects.equal((Object)element_1, (Object)interfaceRef);
                    if (!_notEquals) continue;
                    String _qualifiedName = interfaze.getQualifiedName();
                    String qualifiedVarName = String.valueOf(_qualifiedName) + ".super";
                    b.declareVariable(interfaze, qualifiedVarName);
                    continue;
                }
                b.declareVariable(interfaze, simpleVarName);
            }
        }
        String _xifexpression = null;
        if (superType != null) {
            _xifexpression = b.declareVariable(superType, "super");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected String reassignThisType(ITreeAppendable b, JvmDeclaredType declaredType) {
        Object element;
        String _xblockexpression = null;
        boolean _hasObject = b.hasObject("this");
        if (_hasObject && (element = b.getObject("this")) instanceof JvmDeclaredType) {
            boolean _isLocal = ((JvmDeclaredType)element).isLocal();
            if (_isLocal) {
                b.declareVariable(element, "");
            } else {
                String _simpleName = ((JvmDeclaredType)element).getSimpleName();
                String proposedName = String.valueOf(_simpleName) + ".this";
                b.declareVariable(element, proposedName);
            }
        }
        String _xifexpression = null;
        if (declaredType != null) {
            _xifexpression = b.declareVariable(declaredType, "this");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public ITreeAppendable generateBodyWithIssues(JvmExecutable op, ITreeAppendable appendable, Iterable<Issue> errors) {
        return this.generateBodyWithIssues(appendable, errors);
    }

    public ITreeAppendable generateBodyWithIssues(ITreeAppendable appendable, Iterable<Issue> errors) {
        ITreeAppendable _xblockexpression = null;
        appendable.append("{").increaseIndentation().newLine().append("throw new Error(\"Unresolved compilation problems:\"");
        appendable.increaseIndentation();
        Consumer<Issue> _function = it -> appendable.newLine().append("+ \"\\n").append(this.doConvertToJavaString(it.getMessage())).append("\"");
        errors.forEach(_function);
        _xblockexpression = appendable.append(");").decreaseIndentation().decreaseIndentation().newLine().append("}");
        return _xblockexpression;
    }

    protected String doConvertToJavaString(String input) {
        return Strings.convertToJavaString((String)input, (boolean)true);
    }

    public void generateFileHeader(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        FileHeaderAdapter fileHeaderAdapter = (FileHeaderAdapter)((Object)IterableExtensions.head((Iterable)Iterables.filter((Iterable)it.eAdapters(), FileHeaderAdapter.class)));
        if (fileHeaderAdapter != null && !StringExtensions.isNullOrEmpty((String)fileHeaderAdapter.getHeaderText())) {
            this.generateDocumentation(fileHeaderAdapter.getHeaderText(), this.fileHeaderProvider.getFileHeaderNodes(it.eResource()), appendable, config);
        }
    }

    public void generateJavaDoc(EObject it, ITreeAppendable appendable, GeneratorConfig config) {
        DocumentationAdapter adapter = (DocumentationAdapter)((Object)IterableExtensions.head((Iterable)Iterables.filter((Iterable)it.eAdapters(), DocumentationAdapter.class)));
        if (adapter != null && !StringExtensions.isNullOrEmpty((String)adapter.getDocumentation())) {
            Set<EObject> sourceElements = this.getSourceElements(it);
            if (sourceElements.size() == 1 && this.documentationProvider instanceof IEObjectDocumentationProviderExtension) {
                List documentationNodes = ((IEObjectDocumentationProviderExtension)this.documentationProvider).getDocumentationNodes((EObject)IterableExtensions.head(sourceElements));
                this.addJavaDocImports(it, appendable, documentationNodes);
                this.generateDocumentation(adapter.getDocumentation(), documentationNodes, appendable, config);
            } else {
                this.generateDocumentation(adapter.getDocumentation(), CollectionLiterals.emptyList(), appendable, config);
            }
        }
    }

    public void addJavaDocImports(EObject it, ITreeAppendable appendable, List<INode> documentationNodes) {
        for (INode node : documentationNodes) {
            List _computeTypeRefRegions = this.javaDocTypeReferenceProvider.computeTypeRefRegions(node);
            for (ReplaceRegion region : _computeTypeRefRegions) {
                String _packageName_1;
                boolean _notEquals;
                IScope scope;
                IEObjectDescription candidate;
                String text = region.getText();
                if (text == null || text.length() <= 0) continue;
                QualifiedName fqn = this.qualifiedNameConverter.toQualifiedName(text);
                EObject context = NodeModelUtils.findActualSemanticObjectFor((INode)node);
                if (fqn.getSegmentCount() != 1 || context == null || (candidate = (scope = this.scopeProvider.getScope(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE)).getSingleElement(fqn)) == null) continue;
                EObject _xifexpression = null;
                boolean _eIsProxy = candidate.getEObjectOrProxy().eIsProxy();
                _xifexpression = _eIsProxy ? EcoreUtil.resolve((EObject)candidate.getEObjectOrProxy(), (EObject)context) : candidate.getEObjectOrProxy();
                JvmType jvmType = (JvmType)_xifexpression;
                if (!(jvmType instanceof JvmDeclaredType) || jvmType.eIsProxy()) continue;
                JvmDeclaredType referencedType = (JvmDeclaredType)jvmType;
                JvmDeclaredType contextDeclarator = (JvmDeclaredType)EcoreUtil2.getContainerOfType((EObject)it, JvmDeclaredType.class);
                String _packageName = referencedType.getPackageName();
                boolean bl = _notEquals = !Objects.equal((Object)_packageName, (Object)(_packageName_1 = contextDeclarator.getPackageName()));
                if (!_notEquals) continue;
                ImportManager importManager = this.getImportManager(appendable);
                importManager.addImportFor(jvmType);
            }
        }
    }

    public ImportManager getImportManager(ITreeAppendable appendable) {
        return ((TreeAppendable)appendable).getImportManager();
    }

    protected ITreeAppendable generateDocumentation(String text, List<INode> documentationNodes, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _not;
        ITreeAppendable _xblockexpression = null;
        StringConcatenation doc = new StringConcatenation();
        doc.append("/**");
        doc.newLine();
        doc.append(" * ");
        doc.append(text, " * ");
        doc.newLine();
        doc.append(" */");
        ITreeAppendable _xifexpression = null;
        boolean _isEmpty = documentationNodes.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            ITreeAppendable _xblockexpression_1 = null;
            ITextRegionWithLineInformation documentationTrace = ITextRegionWithLineInformation.EMPTY_REGION;
            for (INode node : documentationNodes) {
                documentationTrace = documentationTrace.merge(node.getTextRegionWithLineInformation());
            }
            LocationData _locationData = new LocationData(documentationTrace, null);
            appendable.trace((ILocationData)_locationData).append(doc.toString());
            _xifexpression = _xblockexpression_1 = appendable.newLine();
        } else {
            _xifexpression = appendable.append(doc.toString()).newLine();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void generateAnnotations(Iterable<JvmAnnotationReference> annotations, ITreeAppendable appendable, boolean withLineBreak, GeneratorConfig config) {
        Functions.Function1 _function;
        Functions.Function1 sep = _function = it -> {
            ITreeAppendable _xifexpression = null;
            _xifexpression = withLineBreak ? it.newLine() : it.append(" ");
            return _xifexpression;
        };
        Procedures.Procedure1 _function_1 = it -> {
            it.setSeparator((Functions.Function1<? super ITreeAppendable, ? extends ITreeAppendable>)sep);
            it.setSuffix((Functions.Function1<? super ITreeAppendable, ? extends ITreeAppendable>)sep);
        };
        Procedures.Procedure2 _function_2 = (it, app) -> this.generateAnnotation((JvmAnnotationReference)it, (ITreeAppendable)app, config);
        this._errorSafeExtensions.forEachSafely(appendable, annotations, (Procedures.Procedure1<? super LoopParams>)_function_1, _function_2);
    }

    public void generateAnnotation(JvmAnnotationReference it, ITreeAppendable appendable, GeneratorConfig config) {
        appendable.append("@");
        appendable.append((JvmType)it.getAnnotation());
        Procedures.Procedure1 _function = it_1 -> {
            it_1.setPrefix("(");
            it_1.setSeparator(", ");
            it_1.setSuffix(")");
        };
        Procedures.Procedure1 _function_1 = it_1 -> this.toJava((JvmAnnotationValue)it_1, appendable, config);
        this._loopExtensions.forEach(appendable, it.getExplicitValues(), (Procedures.Procedure1<? super LoopParams>)_function, _function_1);
    }

    public void toJava(JvmAnnotationValue it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _tripleNotEquals;
        JvmOperation _operation = it.getOperation();
        boolean bl = _tripleNotEquals = _operation != null;
        if (_tripleNotEquals) {
            boolean _tripleEquals;
            String _simpleName = it.getOperation().getSimpleName();
            boolean bl2 = _tripleEquals = _simpleName == null;
            if (_tripleEquals) {
                return;
            }
            appendable.append(it.getOperation().getSimpleName());
            appendable.append(" = ");
        } else {
            boolean _greaterThan;
            EObject _eContainer = it.eContainer();
            int _size = ((JvmAnnotationReference)_eContainer).getExplicitValues().size();
            boolean bl3 = _greaterThan = _size > 1;
            if (_greaterThan) {
                appendable.append("value = ");
            }
        }
        this.toJavaLiteral(it, appendable, config);
    }

    protected void _toJavaLiteral(JvmAnnotationAnnotationValue value, ITreeAppendable appendable, GeneratorConfig config) {
        Procedures.Procedure1 _function = it -> this.generateAnnotation((JvmAnnotationReference)it, appendable, config);
        this._loopExtensions.forEachWithShortcut(appendable, value.getValues(), _function);
    }

    protected void _toJavaLiteral(JvmShortAnnotationValue it, ITreeAppendable appendable, GeneratorConfig config) {
        Procedures.Procedure1 _function = it_1 -> appendable.append(it_1.toString());
        this._loopExtensions.forEachWithShortcut(appendable, it.getValues(), _function);
    }

    protected void _toJavaLiteral(JvmIntAnnotationValue it, ITreeAppendable appendable, GeneratorConfig config) {
        Procedures.Procedure1 _function = it_1 -> appendable.append(it_1.toString());
        this._loopExtensions.forEachWithShortcut(appendable, it.getValues(), _function);
    }

    protected void _toJavaLiteral(JvmLongAnnotationValue it, ITreeAppendable appendable, GeneratorConfig config) {
        Procedures.Procedure1 _function = it_1 -> appendable.append(it_1.toString());
        this._loopExtensions.forEachWithShortcut(appendable, it.getValues(), _function);
    }

    protected void _toJavaLiteral(JvmByteAnnotationValue it, ITreeAppendable appendable, GeneratorConfig config) {
        Procedures.Procedure1 _function = it_1 -> appendable.append(it_1.toString());
        this._loopExtensions.forEachWithShortcut(appendable, it.getValues(), _function);
    }

    protected void _toJavaLiteral(JvmDoubleAnnotationValue it, ITreeAppendable appendable, GeneratorConfig config) {
        Procedures.Procedure1 _function = it_1 -> {
            String _switchResult = null;
            boolean _matched = false;
            boolean _isNaN = Double.isNaN(it_1);
            if (_isNaN) {
                _matched = true;
                _switchResult = "Double.NaN";
            }
            if (!_matched && Objects.equal((Object)it_1, (Object)Double.POSITIVE_INFINITY)) {
                _matched = true;
                _switchResult = "Double.POSITIVE_INFINITY";
            }
            if (!_matched && Objects.equal((Object)it_1, (Object)Double.NEGATIVE_INFINITY)) {
                _matched = true;
                _switchResult = "Double.NEGATIVE_INFINITY";
            }
            if (!_matched) {
                String _string = it_1.toString();
                _switchResult = String.valueOf(_string) + "d";
            }
            appendable.append(_switchResult);
        };
        this._loopExtensions.forEachWithShortcut(appendable, it.getValues(), _function);
    }

    protected void _toJavaLiteral(JvmFloatAnnotationValue it, ITreeAppendable appendable, GeneratorConfig config) {
        Procedures.Procedure1 _function = it_1 -> {
            String _switchResult = null;
            boolean _matched = false;
            boolean _isNaN = Float.isNaN(it_1.floatValue());
            if (_isNaN) {
                _matched = true;
                _switchResult = "Float.NaN";
            }
            if (!_matched && Objects.equal((Object)it_1, (Object)Float.valueOf(Float.POSITIVE_INFINITY))) {
                _matched = true;
                _switchResult = "Float.POSITIVE_INFINITY";
            }
            if (!_matched && Objects.equal((Object)it_1, (Object)Float.valueOf(Float.NEGATIVE_INFINITY))) {
                _matched = true;
                _switchResult = "Float.NEGATIVE_INFINITY";
            }
            if (!_matched) {
                String _string = it_1.toString();
                _switchResult = String.valueOf(_string) + "f";
            }
            appendable.append(_switchResult);
        };
        this._loopExtensions.forEachWithShortcut(appendable, it.getValues(), _function);
    }

    protected void _toJavaLiteral(JvmCharAnnotationValue it, ITreeAppendable appendable, GeneratorConfig config) {
        Procedures.Procedure1 _function = it_1 -> {
            String _doConvertToJavaString = this.doConvertToJavaString(it_1.toString());
            String _plus = "'" + _doConvertToJavaString;
            String _plus_1 = String.valueOf(_plus) + "'";
            appendable.append(_plus_1);
        };
        this._loopExtensions.forEachWithShortcut(appendable, it.getValues(), _function);
    }

    protected void _toJavaLiteral(JvmStringAnnotationValue it, ITreeAppendable appendable, GeneratorConfig config) {
        Procedures.Procedure1 _function = it_1 -> {
            String _doConvertToJavaString = this.doConvertToJavaString(it_1.toString());
            String _plus = "\"" + _doConvertToJavaString;
            String _plus_1 = String.valueOf(_plus) + "\"";
            appendable.append(_plus_1);
        };
        this._loopExtensions.forEachWithShortcut(appendable, it.getValues(), _function);
    }

    protected void _toJavaLiteral(JvmTypeAnnotationValue it, ITreeAppendable appendable, GeneratorConfig config) {
        Procedures.Procedure1 _function = it_1 -> appendable.append(it_1.getType()).append(".class");
        this._loopExtensions.forEachWithShortcut(appendable, it.getValues(), _function);
    }

    protected void _toJavaLiteral(JvmEnumAnnotationValue it, ITreeAppendable appendable, GeneratorConfig config) {
        Procedures.Procedure1 _function = it_1 -> {
            appendable.append((JvmType)it_1.getDeclaringType());
            appendable.append(".");
            appendable.append(this.makeJavaIdentifier(it_1.getSimpleName()));
        };
        this._loopExtensions.forEachWithShortcut(appendable, it.getValues(), _function);
    }

    protected void _toJavaLiteral(JvmBooleanAnnotationValue it, ITreeAppendable appendable, GeneratorConfig config) {
        Procedures.Procedure1 _function = it_1 -> appendable.append(it_1.toString());
        this._loopExtensions.forEachWithShortcut(appendable, it.getValues(), _function);
    }

    protected void _toJavaLiteral(JvmCustomAnnotationValue it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _isEmpty = it.getValues().isEmpty();
        if (_isEmpty) {
            appendable.append("{}");
        } else {
            Procedures.Procedure1 _function = it_1 -> this.compiler.toJavaExpression((XExpression)it_1, appendable);
            this._loopExtensions.forEachWithShortcut(appendable, Iterables.filter((Iterable)it.getValues(), XExpression.class), _function);
        }
    }

    public TreeAppendable createAppendable(EObject context, ImportManager importManager, GeneratorConfig config) {
        abstract class __JvmModelGenerator_1
        implements ITraceURIConverter {
            Map<URI, SourceRelativeURI> uriForTraceCache;

            __JvmModelGenerator_1() {
            }
        }
        __JvmModelGenerator_1 cachingConverter = new __JvmModelGenerator_1(this){
            {
                this.uriForTraceCache = Maps.newHashMap();
            }

            public SourceRelativeURI getURIForTrace(IProjectConfig config, AbsoluteURI uri) {
                boolean _not;
                boolean _containsKey = this.uriForTraceCache.containsKey(uri.getURI());
                boolean bl = _not = !_containsKey;
                if (_not) {
                    SourceRelativeURI result = converter.getURIForTrace(config, uri);
                    this.uriForTraceCache.put(uri.getURI(), result);
                }
                return (SourceRelativeURI)this.uriForTraceCache.get(uri.getURI());
            }

            public SourceRelativeURI getURIForTrace(Resource resource) {
                boolean _not;
                boolean _containsKey = this.uriForTraceCache.containsKey(resource.getURI());
                boolean bl = _not = !_containsKey;
                if (_not) {
                    SourceRelativeURI result = converter.getURIForTrace(resource);
                    this.uriForTraceCache.put(resource.getURI(), result);
                }
                return (SourceRelativeURI)this.uriForTraceCache.get(resource.getURI());
            }
        };
        TreeAppendable appendable = this.createAppendable(importManager, cachingConverter, this.locationProvider, this.jvmModelAssociations, context, "  ", "\n");
        SharedAppendableState _state = appendable.getState();
        _state.setGeneratorConfig(config);
        return appendable;
    }

    protected TreeAppendable createAppendable(ImportManager importManager, ITraceURIConverter converter, ILocationInFileProvider locationProvider, IJvmModelAssociations jvmModelAssociations, EObject source, String indentation, String lineSeparator) {
        return new TreeAppendable(importManager, converter, locationProvider, jvmModelAssociations, source, indentation, lineSeparator);
    }

    public JvmGenericType containerType(EObject context) {
        JvmGenericType _xifexpression = null;
        if (context == null) {
            _xifexpression = null;
        } else {
            JvmGenericType _xifexpression_1 = null;
            _xifexpression_1 = context instanceof JvmGenericType ? (JvmGenericType)context : this.containerType(context.eContainer());
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected String makeJavaIdentifier(String name) {
        String _xifexpression = null;
        if (name == null) {
            return "__unknown__";
        }
        String _xifexpression_1 = null;
        boolean _isJavaKeyword = this.keywords.isJavaKeyword(name);
        _xifexpression_1 = _isJavaKeyword ? String.valueOf(name) + "_" : name;
        _xifexpression = _xifexpression_1;
        return _xifexpression;
    }

    protected Iterable<JvmMember> _getMembersToBeCompiled(JvmEnumerationType type) {
        Iterable _xblockexpression = null;
        String _identifier = type.getIdentifier();
        String _plus = String.valueOf(_identifier) + ".";
        String _plus_1 = String.valueOf(_plus) + "valueOf(java.lang.String)";
        String _identifier_1 = type.getIdentifier();
        String _plus_2 = String.valueOf(_identifier_1) + ".";
        String _plus_3 = String.valueOf(_plus_2) + "values()";
        Set syntheticEnumMethods = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{_plus_1, _plus_3}));
        Functions.Function1 _function = it -> !(it instanceof JvmOperation) || !syntheticEnumMethods.contains(it.getIdentifier());
        _xblockexpression = IterableExtensions.filter((Iterable)type.getMembers(), (Functions.Function1)_function);
        return _xblockexpression;
    }

    protected Iterable<JvmMember> _getMembersToBeCompiled(JvmDeclaredType it) {
        Functions.Function1 _function = it_1 -> !(it_1 instanceof JvmConstructor) || !this._jvmTypeExtensions.isSingleSyntheticDefaultConstructor((JvmConstructor)it_1);
        return IterableExtensions.filter((Iterable)it.getMembers(), (Functions.Function1)_function);
    }

    protected Iterable<JvmMember> _getMembersToBeCompiled(JvmGenericType it) {
        Iterable _xifexpression = null;
        boolean _isAnonymous = it.isAnonymous();
        if (_isAnonymous) {
            Functions.Function1 _function = it_1 -> !(it_1 instanceof JvmConstructor);
            _xifexpression = IterableExtensions.filter((Iterable)it.getMembers(), (Functions.Function1)_function);
        } else {
            _xifexpression = this._getMembersToBeCompiled((JvmDeclaredType)it);
        }
        return _xifexpression;
    }

    protected Set<EObject> getSourceElements(EObject jvmElement) {
        return this.jvmModelAssociations.getSourceElements(jvmElement);
    }

    public void internalDoGenerate(EObject type, IFileSystemAccess fsa) {
        if (type instanceof JvmDeclaredType) {
            this._internalDoGenerate((JvmDeclaredType)type, fsa);
            return;
        }
        if (type != null) {
            this._internalDoGenerate(type, fsa);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type, fsa).toString());
    }

    public ITreeAppendable generateBody(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        if (it instanceof JvmAnnotationType) {
            return this._generateBody((JvmAnnotationType)it, appendable, config);
        }
        if (it instanceof JvmEnumerationType) {
            return this._generateBody((JvmEnumerationType)it, appendable, config);
        }
        if (it instanceof JvmGenericType) {
            return this._generateBody((JvmGenericType)it, appendable, config);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, appendable, config).toString());
    }

    public ITreeAppendable generateModifier(JvmMember it, ITreeAppendable appendable, GeneratorConfig config) {
        if (it instanceof JvmConstructor) {
            return this._generateModifier((JvmConstructor)it, appendable, config);
        }
        if (it instanceof JvmOperation) {
            return this._generateModifier((JvmOperation)it, appendable, config);
        }
        if (it instanceof JvmField) {
            return this._generateModifier((JvmField)it, appendable, config);
        }
        if (it instanceof JvmGenericType) {
            return this._generateModifier((JvmGenericType)it, appendable, config);
        }
        if (it instanceof JvmDeclaredType) {
            return this._generateModifier((JvmDeclaredType)it, appendable, config);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, appendable, config).toString());
    }

    public ITreeAppendable generateMember(JvmMember it, ITreeAppendable appendable, GeneratorConfig config) {
        if (it instanceof JvmConstructor) {
            return this._generateMember((JvmConstructor)it, appendable, config);
        }
        if (it instanceof JvmOperation) {
            return this._generateMember((JvmOperation)it, appendable, config);
        }
        if (it instanceof JvmField) {
            return this._generateMember((JvmField)it, appendable, config);
        }
        if (it instanceof JvmDeclaredType) {
            return this._generateMember((JvmDeclaredType)it, appendable, config);
        }
        if (it != null) {
            return this._generateMember(it, appendable, config);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, appendable, config).toString());
    }

    public void toJavaLiteral(JvmAnnotationValue value, ITreeAppendable appendable, GeneratorConfig config) {
        if (value instanceof JvmAnnotationAnnotationValue) {
            this._toJavaLiteral((JvmAnnotationAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmBooleanAnnotationValue) {
            this._toJavaLiteral((JvmBooleanAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmByteAnnotationValue) {
            this._toJavaLiteral((JvmByteAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmCharAnnotationValue) {
            this._toJavaLiteral((JvmCharAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmCustomAnnotationValue) {
            this._toJavaLiteral((JvmCustomAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmDoubleAnnotationValue) {
            this._toJavaLiteral((JvmDoubleAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmEnumAnnotationValue) {
            this._toJavaLiteral((JvmEnumAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmFloatAnnotationValue) {
            this._toJavaLiteral((JvmFloatAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmIntAnnotationValue) {
            this._toJavaLiteral((JvmIntAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmLongAnnotationValue) {
            this._toJavaLiteral((JvmLongAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmShortAnnotationValue) {
            this._toJavaLiteral((JvmShortAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmStringAnnotationValue) {
            this._toJavaLiteral((JvmStringAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmTypeAnnotationValue) {
            this._toJavaLiteral((JvmTypeAnnotationValue)value, appendable, config);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(value, appendable, config).toString());
    }

    public Iterable<JvmMember> getMembersToBeCompiled(JvmDeclaredType type) {
        if (type instanceof JvmEnumerationType) {
            return this._getMembersToBeCompiled((JvmEnumerationType)type);
        }
        if (type instanceof JvmGenericType) {
            return this._getMembersToBeCompiled((JvmGenericType)type);
        }
        if (type != null) {
            return this._getMembersToBeCompiled(type);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type).toString());
    }
}

