/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.common.client.http;

import ee.jakarta.tck.pages.common.client.http.HttpResponse;
import ee.jakarta.tck.pages.common.client.http.MethodFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;

public class HttpRequest {
    private static final Logger LOGGER = Logger.getLogger(HttpRequest.class.getName());
    public static int DEFAULT_HTTP_PORT;
    public static final int DEFAULT_SSL_PORT = 443;
    public static final int NO_AUTHENTICATION = 0;
    public static final int BASIC_AUTHENTICATION = 1;
    public static final int DIGEST_AUTHENTICATION = 2;
    private HttpUriRequest _method = null;
    private org.apache.http.HttpResponse _response = null;
    private String _host = null;
    private int _port = DEFAULT_HTTP_PORT;
    private boolean _isSecure = false;
    private CookieStore _cookieStore = null;
    private BasicCredentialsProvider _credentialsProvider = null;
    private String _requestLine = null;
    private int _authType = 0;
    private boolean _useCookies = false;
    private int _contentLength = 0;
    private boolean _followRedirects = false;
    Header[] _headers = null;
    protected HttpClient client = HttpClientBuilder.create().build();

    public HttpRequest(String requestLine, String host, int port) {
        this._method = MethodFactory.getInstance(requestLine);
        this._host = host;
        this._port = port;
        if (port == 443) {
            this._isSecure = true;
        }
        this._requestLine = requestLine;
    }

    public String getRequestPath() {
        try {
            return this._method.getURI().getPath();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getRequestMethod() {
        return this._method.getMethod();
    }

    public boolean isSecureRequest() {
        return this._isSecure;
    }

    public void setSecureRequest(boolean secure) {
        this._isSecure = secure;
    }

    public void setContent(String content) {
        if (this._method instanceof HttpEntityEnclosingRequest) {
            try {
                ((HttpEntityEnclosingRequest)this._method).setEntity((HttpEntity)new StringEntity(content));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to set entity", e);
            }
        }
        this._contentLength = content.length();
    }

    public void setAuthenticationCredentials(String username, String password, int authType, String realm) {
        if (username == null) {
            throw new IllegalArgumentException("Username cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials(username, password);
        AuthScope scope = new AuthScope(this._host, this._port, realm);
        this.getCredentialsProvider().setCredentials(scope, (Credentials)cred);
        LOGGER.finer("Added credentials for '" + username + "' with password '" + password + "' in realm '" + realm + "'");
        this._authType = authType;
    }

    public void addRequestHeader(String headerName, String headerValue) {
        this._method.addHeader(headerName, headerValue);
        LOGGER.finer("Added request header: " + headerName + ": " + headerValue);
    }

    public void addRequestHeader(String header) {
        StringTokenizer st = new StringTokenizer(header, "|");
        while (st.hasMoreTokens()) {
            String h = st.nextToken();
            if (h.toLowerCase().startsWith("cookie")) {
                this.createCookie(h);
                continue;
            }
            int col = h.indexOf(58);
            this.addRequestHeader(h.substring(0, col).trim(), h.substring(col + 1).trim());
        }
    }

    public void setRequestHeader(String headerName, String headerValue) {
        this._method.setHeader(headerName, headerValue);
        LOGGER.finer("Set request header: " + headerName + ": " + headerValue);
    }

    public void setFollowRedirects(boolean followRedirects) {
        this._followRedirects = followRedirects;
    }

    public boolean getFollowRedirects() {
        return this._followRedirects;
    }

    public HttpResponse execute() throws IOException {
        String scheme = this._isSecure ? "https" : "http";
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        RequestConfig requestConfig = RequestConfig.custom().setRedirectsEnabled(this._followRedirects).setCookieSpec("default").build();
        HttpClientBuilder clientBuilder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig);
        if (this._credentialsProvider != null) {
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)this._credentialsProvider);
        }
        this.client = clientBuilder.build();
        LOGGER.info("Dispatching request: '" + this._requestLine + "' to target server at '" + this._host + ":" + this._port + "'");
        this.addSupportHeaders();
        this._headers = this._method.getAllHeaders();
        LOGGER.finer("########## The real value set: " + this._followRedirects);
        try {
            URI currentUri = this._method.getURI();
            URI fullUri = new URI(scheme, null, this._host, this._port, currentUri.getPath(), currentUri.getQuery(), currentUri.getFragment());
            if (this._method instanceof HttpRequestBase) {
                ((HttpRequestBase)this._method).setURI(fullUri);
            }
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to build request URI", e);
        }
        this._response = this.client.execute(this._method);
        return new HttpResponse(this._host, this._port, this._isSecure, this._method, this._response);
    }

    public BasicCredentialsProvider getCredentialsProvider() {
        if (this._credentialsProvider == null) {
            this._credentialsProvider = new BasicCredentialsProvider();
        }
        return this._credentialsProvider;
    }

    public CookieStore getCookieStore() {
        if (this._cookieStore == null) {
            this._cookieStore = new BasicCookieStore();
        }
        return this._cookieStore;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(255);
        sb.append("[REQUEST LINE] -> ").append(this._requestLine).append('\n');
        if (this._headers != null && this._headers.length != 0) {
            for (Header _header : this._headers) {
                sb.append("       [REQUEST HEADER] -> ");
                sb.append(_header.toString()).append('\n');
            }
        }
        if (this._contentLength != 0) {
            sb.append("       [REQUEST BODY LENGTH] -> ").append(this._contentLength);
            sb.append('\n');
        }
        return sb.toString();
    }

    private void createCookie(String cookieHeader) {
        String cookieLine = cookieHeader.substring(cookieHeader.indexOf(58) + 1).trim();
        StringTokenizer st = new StringTokenizer(cookieLine, " ;");
        String name = null;
        String value = null;
        String domain = null;
        String path = null;
        int version = 1;
        CookieStore store = this.getCookieStore();
        if (cookieLine.indexOf("$Version") == -1) {
            version = 0;
        }
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int eqIndex = token.indexOf(61);
            if (token.charAt(0) != '$' && !token.startsWith("Domain") && !token.startsWith("Path") && eqIndex > 0) {
                name = token.substring(0, eqIndex);
                value = token.substring(eqIndex + 1);
                continue;
            }
            if (token.indexOf("Domain") > -1 && eqIndex > 0) {
                domain = token.substring(eqIndex + 1);
                continue;
            }
            if (token.indexOf("Path") <= -1 || eqIndex <= 0) continue;
            path = token.substring(eqIndex + 1);
        }
        if (name != null) {
            BasicClientCookie cookie = new BasicClientCookie(name, value != null ? value : "");
            cookie.setVersion(version);
            if (domain != null) {
                cookie.setDomain(domain);
            }
            if (path != null) {
                cookie.setPath(path);
            }
            store.addCookie((Cookie)cookie);
        }
    }

    private void addSupportHeaders() {
        switch (this._authType) {
            case 0: {
                break;
            }
            case 1: {
                this.setBasicAuthorizationHeader();
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Digest Authentication is not currently supported");
            }
        }
        this.setHostHeader();
        this.setContentLengthHeader();
        this.setCookieHeader();
    }

    private void setBasicAuthorizationHeader() {
        Credentials cred = this.getCredentialsProvider().getCredentials(new AuthScope(this._host, this._port, null));
        String authString = null;
        if (cred instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upCred = (UsernamePasswordCredentials)cred;
            authString = "Basic " + Base64.getEncoder().encodeToString((upCred.getUserName() + ":" + upCred.getPassword()).getBytes(StandardCharsets.UTF_8));
        } else {
            LOGGER.finer("NULL CREDENTIALS");
        }
        if (authString != null) {
            this._method.setHeader("Authorization", authString);
        }
    }

    private void setContentLengthHeader() {
        if (this._contentLength > 0) {
            this._method.setHeader("Content-Length", Integer.toString(this._contentLength));
        }
    }

    private void setHostHeader() {
        if (this._port == DEFAULT_HTTP_PORT || this._port == 443) {
            this._method.setHeader("Host", this._host);
        } else {
            this._method.setHeader("Host", this._host + ":" + this._port);
        }
    }

    private void setCookieHeader() {
        List cookies;
        if (this._useCookies && this._cookieStore != null && (cookies = this._cookieStore.getCookies()) != null && !cookies.isEmpty()) {
            StringBuilder cookieHeader = new StringBuilder();
            for (int i = 0; i < cookies.size(); ++i) {
                Cookie cookie = (Cookie)cookies.get(i);
                if (i > 0) {
                    cookieHeader.append("; ");
                }
                cookieHeader.append(cookie.getName()).append("=").append(cookie.getValue());
            }
            if (cookieHeader.length() > 0) {
                this._method.setHeader("Cookie", cookieHeader.toString());
            }
        }
    }

    static {
        if (LOGGER.isLoggable(Level.FINER)) {
            System.setProperty("org.apache.commons.logging.Log", "com.sun.ts.tests.common.webclient.log.WebLog");
            System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire", "debug");
        }
        DEFAULT_HTTP_PORT = 80;
    }
}

