/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._float.enumeration.enumeration_2;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import jakarta.xml.bind.JAXBException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class enumeration2_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        enumeration2_ValidateCTTests test = new enumeration2_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final float[] validValues = {5964894.839E-9F, 65556.05328541E-18F, 0.0F};
    
    final float[] invalidValues = {1.0F, Float.MAX_VALUE 
                                  , Float.NEGATIVE_INFINITY, Float.NaN};
    
    JAXBElement<Float> elemObj;

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(invalidValues[i]);
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Unmarshalled001( ) {
        elemObj = (JAXBElement<Float>)unmarshal("enumeration-2-4.xml");
        return testValid();
    }

    public Status Unmarshalled002( ) {
        elemObj = (JAXBElement<Float>)unmarshal("enumeration-2-4.xml");
        return testInvalid();
    }

    public Status Created001( ) {
        elemObj = (JAXBElement<Float>)(new ObjectFactory()).createNISTSchemaFloatEnumeration2(validValues[0]);
        
        return testValid();
    }

    public Status Created002( ) {
        elemObj = (JAXBElement<Float>)(new ObjectFactory()).createNISTSchemaFloatEnumeration2(validValues[0]);
        
        return testInvalid();
    }


}

