/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.Command;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.Status;
import com.sun.javatest.agent.AgentManager;
import com.sun.javatest.agent.SerialPortConnection;
import java.io.IOException;
import java.io.PrintWriter;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;

public class SerialPortAgentCommand
extends Command {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status run(String[] args, PrintWriter err, PrintWriter out) {
        Status status;
        int i;
        String classPath = null;
        String tag = null;
        boolean localizeArgs = false;
        for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            if ((args[i].equals("-cp") || args[i].equals("-classpath")) && i + 1 < args.length) {
                classPath = args[++i];
                continue;
            }
            if (args[i].equals("-m") || args[i].equals("-mapArgs")) {
                localizeArgs = true;
                continue;
            }
            if ((args[i].equals("-t") || args[i].equals("-tag")) && i + 1 < args.length) {
                tag = args[++i];
                continue;
            }
            return Status.error("Unrecognized option: " + args[i]);
        }
        if (i == args.length) {
            return Status.error("No serial port specified");
        }
        String serialPortName = args[i++];
        if (i == args.length) {
            return Status.error("No command specified");
        }
        String cmdClass = args[i++];
        String[] cmdArgs = new String[args.length - i];
        System.arraycopy(args, i, cmdArgs, 0, cmdArgs.length);
        if (tag == null) {
            tag = cmdClass;
        }
        AgentManager mgr = AgentManager.access();
        AgentManager.Task t = mgr.connect(new SerialPortConnection(serialPortName, ProductInfo.getName(), 1000));
        try {
            if (classPath != null) {
                t.setClassPath(classPath);
            }
            out.println("Executing command via " + t.getConnection().getName());
            status = t.executeCommand(tag, cmdClass, cmdArgs, localizeArgs, err, out);
        }
        catch (Throwable throwable) {
            try {
                t.getConnection().close();
                throw throwable;
            }
            catch (InterruptedException e) {
                return Status.error("Interrupted while waiting for port: " + serialPortName);
            }
            catch (NoSuchPortException e) {
                return Status.error("No such port: " + serialPortName);
            }
            catch (PortInUseException e) {
                return Status.error("port in use: " + serialPortName);
            }
            catch (IOException e) {
                return Status.error("Error accessing agent: " + e);
            }
        }
        t.getConnection().close();
        return status;
    }
}

