/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RDN
implements Comparable<RDN>,
Comparator<RDN>,
Serializable {
    private static final long serialVersionUID = 2923419812807188487L;
    private final ASN1OctetString[] attributeValues;
    private final Schema schema;
    private volatile String normalizedString;
    private volatile String rdnString;
    private final String[] attributeNames;

    public RDN(String attributeName, String attributeValue) {
        this(attributeName, attributeValue, null);
    }

    public RDN(String attributeName, String attributeValue, Schema schema) {
        Validator.ensureNotNull(attributeName, attributeValue);
        this.schema = schema;
        this.attributeNames = new String[]{attributeName};
        this.attributeValues = new ASN1OctetString[]{new ASN1OctetString(attributeValue)};
    }

    public RDN(String attributeName, byte[] attributeValue) {
        this(attributeName, attributeValue, null);
    }

    public RDN(String attributeName, byte[] attributeValue, Schema schema) {
        Validator.ensureNotNull(attributeName, attributeValue);
        this.schema = schema;
        this.attributeNames = new String[]{attributeName};
        this.attributeValues = new ASN1OctetString[]{new ASN1OctetString(attributeValue)};
    }

    public RDN(String[] attributeNames, String[] attributeValues) {
        this(attributeNames, attributeValues, null);
    }

    public RDN(String[] attributeNames, String[] attributeValues, Schema schema) {
        Validator.ensureNotNull(attributeNames, attributeValues);
        Validator.ensureTrue(attributeNames.length == attributeValues.length, "RDN.attributeNames and attributeValues must be the same size.");
        Validator.ensureTrue(attributeNames.length > 0, "RDN.attributeNames must not be empty.");
        this.attributeNames = attributeNames;
        this.schema = schema;
        this.attributeValues = new ASN1OctetString[attributeValues.length];
        for (int i = 0; i < attributeValues.length; ++i) {
            this.attributeValues[i] = new ASN1OctetString(attributeValues[i]);
        }
    }

    public RDN(String[] attributeNames, byte[][] attributeValues) {
        this(attributeNames, attributeValues, null);
    }

    public RDN(String[] attributeNames, byte[][] attributeValues, Schema schema) {
        Validator.ensureNotNull(attributeNames, attributeValues);
        Validator.ensureTrue(attributeNames.length == attributeValues.length, "RDN.attributeNames and attributeValues must be the same size.");
        Validator.ensureTrue(attributeNames.length > 0, "RDN.attributeNames must not be empty.");
        this.attributeNames = attributeNames;
        this.schema = schema;
        this.attributeValues = new ASN1OctetString[attributeValues.length];
        for (int i = 0; i < attributeValues.length; ++i) {
            this.attributeValues[i] = new ASN1OctetString(attributeValues[i]);
        }
    }

    RDN(String attributeName, ASN1OctetString attributeValue, Schema schema, String rdnString) {
        this.rdnString = rdnString;
        this.schema = schema;
        this.attributeNames = new String[]{attributeName};
        this.attributeValues = new ASN1OctetString[]{attributeValue};
    }

    RDN(String[] attributeNames, ASN1OctetString[] attributeValues, Schema schema, String rdnString) {
        this.rdnString = rdnString;
        this.schema = schema;
        this.attributeNames = attributeNames;
        this.attributeValues = attributeValues;
    }

    public RDN(String rdnString) throws LDAPException {
        this(rdnString, (Schema)null);
    }

    public RDN(String rdnString, Schema schema) throws LDAPException {
        ASN1OctetString value;
        char c;
        int pos;
        Validator.ensureNotNull(rdnString);
        this.rdnString = rdnString;
        this.schema = schema;
        int length = rdnString.length();
        for (pos = 0; pos < length && rdnString.charAt(pos) == ' '; ++pos) {
        }
        int attrStartPos = pos;
        while (pos < length && (c = rdnString.charAt(pos)) != ' ' && c != '=') {
            ++pos;
        }
        String attrName = rdnString.substring(attrStartPos, pos);
        if (attrName.length() == 0) {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_NO_ATTR_NAME.get(rdnString));
        }
        while (pos < length && rdnString.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos >= length || rdnString.charAt(pos) != '=') {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_NO_EQUAL_SIGN.get(rdnString, attrName));
        }
        ++pos;
        while (pos < length && rdnString.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            value = new ASN1OctetString();
        } else if (rdnString.charAt(pos) == '#') {
            byte[] valueArray = RDN.readHexString(rdnString, ++pos);
            try {
                value = ASN1OctetString.decodeAsOctetString(valueArray);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_HEX_STRING_NOT_BER_ENCODED.get(rdnString, attrName), e);
            }
            pos += valueArray.length * 2;
        } else {
            StringBuilder buffer = new StringBuilder();
            pos = RDN.readValueString(rdnString, pos, buffer);
            value = new ASN1OctetString(buffer.toString());
        }
        while (pos < length && rdnString.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            this.attributeNames = new String[]{attrName};
            this.attributeValues = new ASN1OctetString[]{value};
            return;
        }
        ArrayList<String> nameList = new ArrayList<String>(5);
        ArrayList<ASN1OctetString> valueList = new ArrayList<ASN1OctetString>(5);
        nameList.add(attrName);
        valueList.add(value);
        if (rdnString.charAt(pos) != '+') {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_VALUE_NOT_FOLLOWED_BY_PLUS.get(rdnString));
        }
        if (++pos >= length) {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_PLUS_NOT_FOLLOWED_BY_AVP.get(rdnString));
        }
        int numValues = 1;
        while (pos < length) {
            char c2;
            while (pos < length && rdnString.charAt(pos) == ' ') {
                ++pos;
            }
            attrStartPos = pos;
            while (pos < length && (c2 = rdnString.charAt(pos)) != ' ' && c2 != '=') {
                ++pos;
            }
            attrName = rdnString.substring(attrStartPos, pos);
            if (attrName.length() == 0) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_NO_ATTR_NAME.get(rdnString));
            }
            while (pos < length && rdnString.charAt(pos) == ' ') {
                ++pos;
            }
            if (pos >= length || rdnString.charAt(pos) != '=') {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_NO_EQUAL_SIGN.get(rdnString, attrName));
            }
            ++pos;
            while (pos < length && rdnString.charAt(pos) == ' ') {
                ++pos;
            }
            if (pos >= length) {
                value = new ASN1OctetString();
            } else if (rdnString.charAt(pos) == '#') {
                byte[] valueArray = RDN.readHexString(rdnString, ++pos);
                try {
                    value = ASN1OctetString.decodeAsOctetString(valueArray);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_HEX_STRING_NOT_BER_ENCODED.get(rdnString, attrName), e);
                }
                pos += valueArray.length * 2;
            } else {
                StringBuilder buffer = new StringBuilder();
                pos = RDN.readValueString(rdnString, pos, buffer);
                value = new ASN1OctetString(buffer.toString());
            }
            while (pos < length && rdnString.charAt(pos) == ' ') {
                ++pos;
            }
            nameList.add(attrName);
            valueList.add(value);
            ++numValues;
            if (pos >= length) break;
            if (rdnString.charAt(pos) != '+') {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_VALUE_NOT_FOLLOWED_BY_PLUS.get(rdnString));
            }
            if (++pos < length) continue;
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_PLUS_NOT_FOLLOWED_BY_AVP.get(rdnString));
        }
        this.attributeNames = new String[numValues];
        this.attributeValues = new ASN1OctetString[numValues];
        for (int i = 0; i < numValues; ++i) {
            this.attributeNames[i] = (String)nameList.get(i);
            this.attributeValues[i] = (ASN1OctetString)valueList.get(i);
        }
    }

    static byte[] readHexString(String rdnString, int startPos) throws LDAPException {
        int length = rdnString.length();
        int pos = startPos;
        ByteBuffer buffer = ByteBuffer.allocate(length - pos);
        block37: while (pos < length) {
            byte hexByte;
            switch (rdnString.charAt(pos++)) {
                case '0': {
                    hexByte = 0;
                    break;
                }
                case '1': {
                    hexByte = 16;
                    break;
                }
                case '2': {
                    hexByte = 32;
                    break;
                }
                case '3': {
                    hexByte = 48;
                    break;
                }
                case '4': {
                    hexByte = 64;
                    break;
                }
                case '5': {
                    hexByte = 80;
                    break;
                }
                case '6': {
                    hexByte = 96;
                    break;
                }
                case '7': {
                    hexByte = 112;
                    break;
                }
                case '8': {
                    hexByte = -128;
                    break;
                }
                case '9': {
                    hexByte = -112;
                    break;
                }
                case 'A': 
                case 'a': {
                    hexByte = -96;
                    break;
                }
                case 'B': 
                case 'b': {
                    hexByte = -80;
                    break;
                }
                case 'C': 
                case 'c': {
                    hexByte = -64;
                    break;
                }
                case 'D': 
                case 'd': {
                    hexByte = -48;
                    break;
                }
                case 'E': 
                case 'e': {
                    hexByte = -32;
                    break;
                }
                case 'F': 
                case 'f': {
                    hexByte = -16;
                    break;
                }
                case ' ': 
                case '+': 
                case ',': 
                case ';': {
                    break block37;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_INVALID_HEX_CHAR.get(rdnString, Character.valueOf(rdnString.charAt(pos - 1)), pos - 1));
                }
            }
            if (pos >= length) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_MISSING_HEX_CHAR.get(rdnString));
            }
            switch (rdnString.charAt(pos++)) {
                case '0': {
                    buffer.put(hexByte);
                    continue block37;
                }
                case '1': {
                    buffer.put((byte)(hexByte | 1));
                    continue block37;
                }
                case '2': {
                    buffer.put((byte)(hexByte | 2));
                    continue block37;
                }
                case '3': {
                    buffer.put((byte)(hexByte | 3));
                    continue block37;
                }
                case '4': {
                    buffer.put((byte)(hexByte | 4));
                    continue block37;
                }
                case '5': {
                    buffer.put((byte)(hexByte | 5));
                    continue block37;
                }
                case '6': {
                    buffer.put((byte)(hexByte | 6));
                    continue block37;
                }
                case '7': {
                    buffer.put((byte)(hexByte | 7));
                    continue block37;
                }
                case '8': {
                    buffer.put((byte)(hexByte | 8));
                    continue block37;
                }
                case '9': {
                    buffer.put((byte)(hexByte | 9));
                    continue block37;
                }
                case 'A': 
                case 'a': {
                    buffer.put((byte)(hexByte | 0xA));
                    continue block37;
                }
                case 'B': 
                case 'b': {
                    buffer.put((byte)(hexByte | 0xB));
                    continue block37;
                }
                case 'C': 
                case 'c': {
                    buffer.put((byte)(hexByte | 0xC));
                    continue block37;
                }
                case 'D': 
                case 'd': {
                    buffer.put((byte)(hexByte | 0xD));
                    continue block37;
                }
                case 'E': 
                case 'e': {
                    buffer.put((byte)(hexByte | 0xE));
                    continue block37;
                }
                case 'F': 
                case 'f': {
                    buffer.put((byte)(hexByte | 0xF));
                    continue block37;
                }
            }
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_INVALID_HEX_CHAR.get(rdnString, Character.valueOf(rdnString.charAt(pos - 1)), pos - 1));
        }
        buffer.flip();
        byte[] valueArray = new byte[buffer.limit()];
        buffer.get(valueArray);
        return valueArray;
    }

    static int readValueString(String rdnString, int startPos, StringBuilder buffer) throws LDAPException {
        int pos;
        int length = rdnString.length();
        boolean inQuotes = false;
        block5: for (pos = startPos; pos < length; ++pos) {
            char c = rdnString.charAt(pos);
            switch (c) {
                case '\\': {
                    if (pos + 1 >= length) {
                        throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_ENDS_WITH_BACKSLASH.get(rdnString));
                    }
                    if (StaticUtils.isHex(c = rdnString.charAt(++pos))) {
                        pos = RDN.readEscapedHexString(rdnString, pos, buffer) - 1;
                        continue block5;
                    }
                    buffer.append(c);
                    continue block5;
                }
                case '\"': {
                    if (inQuotes) {
                        ++pos;
                        while (pos < length && (c = rdnString.charAt(pos)) != '+' && c != ',' && c != ';') {
                            if (c != ' ') {
                                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_CHAR_OUTSIDE_QUOTES.get(rdnString, Character.valueOf(c), pos - 1));
                            }
                            ++pos;
                        }
                        inQuotes = false;
                        break block5;
                    }
                    if (pos == startPos) {
                        inQuotes = true;
                        continue block5;
                    }
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_UNEXPECTED_DOUBLE_QUOTE.get(rdnString, pos));
                }
                case '+': 
                case ',': 
                case ';': {
                    if (!inQuotes) break block5;
                    buffer.append(c);
                    continue block5;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        if (inQuotes) {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_UNCLOSED_DOUBLE_QUOTE.get(rdnString));
        }
        int bufferPos = buffer.length() - 1;
        int rdnStrPos = pos - 2;
        while (bufferPos > 0 && buffer.charAt(bufferPos) == ' ' && rdnString.charAt(rdnStrPos) != '\\') {
            buffer.deleteCharAt(bufferPos--);
            --rdnStrPos;
        }
        return pos;
    }

    private static int readEscapedHexString(String rdnString, int startPos, StringBuilder buffer) throws LDAPException {
        int pos;
        int length = rdnString.length();
        ByteBuffer byteBuffer = ByteBuffer.allocate(length - pos);
        for (pos = startPos; pos < length; ++pos) {
            byte b;
            switch (rdnString.charAt(pos++)) {
                case '0': {
                    b = 0;
                    break;
                }
                case '1': {
                    b = 16;
                    break;
                }
                case '2': {
                    b = 32;
                    break;
                }
                case '3': {
                    b = 48;
                    break;
                }
                case '4': {
                    b = 64;
                    break;
                }
                case '5': {
                    b = 80;
                    break;
                }
                case '6': {
                    b = 96;
                    break;
                }
                case '7': {
                    b = 112;
                    break;
                }
                case '8': {
                    b = -128;
                    break;
                }
                case '9': {
                    b = -112;
                    break;
                }
                case 'A': 
                case 'a': {
                    b = -96;
                    break;
                }
                case 'B': 
                case 'b': {
                    b = -80;
                    break;
                }
                case 'C': 
                case 'c': {
                    b = -64;
                    break;
                }
                case 'D': 
                case 'd': {
                    b = -48;
                    break;
                }
                case 'E': 
                case 'e': {
                    b = -32;
                    break;
                }
                case 'F': 
                case 'f': {
                    b = -16;
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_INVALID_HEX_CHAR.get(rdnString, Character.valueOf(rdnString.charAt(pos - 1)), pos - 1));
                }
            }
            if (pos >= length) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_MISSING_HEX_CHAR.get(rdnString));
            }
            switch (rdnString.charAt(pos++)) {
                case '0': {
                    byteBuffer.put(b);
                    break;
                }
                case '1': {
                    byteBuffer.put((byte)(b | 1));
                    break;
                }
                case '2': {
                    byteBuffer.put((byte)(b | 2));
                    break;
                }
                case '3': {
                    byteBuffer.put((byte)(b | 3));
                    break;
                }
                case '4': {
                    byteBuffer.put((byte)(b | 4));
                    break;
                }
                case '5': {
                    byteBuffer.put((byte)(b | 5));
                    break;
                }
                case '6': {
                    byteBuffer.put((byte)(b | 6));
                    break;
                }
                case '7': {
                    byteBuffer.put((byte)(b | 7));
                    break;
                }
                case '8': {
                    byteBuffer.put((byte)(b | 8));
                    break;
                }
                case '9': {
                    byteBuffer.put((byte)(b | 9));
                    break;
                }
                case 'A': 
                case 'a': {
                    byteBuffer.put((byte)(b | 0xA));
                    break;
                }
                case 'B': 
                case 'b': {
                    byteBuffer.put((byte)(b | 0xB));
                    break;
                }
                case 'C': 
                case 'c': {
                    byteBuffer.put((byte)(b | 0xC));
                    break;
                }
                case 'D': 
                case 'd': {
                    byteBuffer.put((byte)(b | 0xD));
                    break;
                }
                case 'E': 
                case 'e': {
                    byteBuffer.put((byte)(b | 0xE));
                    break;
                }
                case 'F': 
                case 'f': {
                    byteBuffer.put((byte)(b | 0xF));
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_INVALID_HEX_CHAR.get(rdnString, Character.valueOf(rdnString.charAt(pos - 1)), pos - 1));
                }
            }
            if (pos + 1 >= length || rdnString.charAt(pos) != '\\' || !StaticUtils.isHex(rdnString.charAt(pos + 1))) break;
        }
        byteBuffer.flip();
        byte[] byteArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byteArray);
        try {
            buffer.append(StaticUtils.toUTF8String(byteArray));
        }
        catch (Exception e) {
            Debug.debugException(e);
            buffer.append(new String(byteArray));
        }
        return pos;
    }

    public static boolean isValidRDN(String s) {
        try {
            new RDN(s);
            return true;
        }
        catch (LDAPException le) {
            return false;
        }
    }

    public boolean isMultiValued() {
        return this.attributeNames.length != 1;
    }

    public Attribute[] getAttributes() {
        Attribute[] attrs = new Attribute[this.attributeNames.length];
        for (int i = 0; i < attrs.length; ++i) {
            attrs[i] = new Attribute(this.attributeNames[i], this.schema, new ASN1OctetString[]{this.attributeValues[i]});
        }
        return attrs;
    }

    public String[] getAttributeNames() {
        return this.attributeNames;
    }

    public String[] getAttributeValues() {
        String[] stringValues = new String[this.attributeValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            stringValues[i] = this.attributeValues[i].stringValue();
        }
        return stringValues;
    }

    public byte[][] getByteArrayAttributeValues() {
        byte[][] byteValues = new byte[this.attributeValues.length][];
        for (int i = 0; i < byteValues.length; ++i) {
            byteValues[i] = this.attributeValues[i].getValue();
        }
        return byteValues;
    }

    Schema getSchema() {
        return this.schema;
    }

    public boolean hasAttribute(String attributeName) {
        for (String name : this.attributeNames) {
            if (!name.equalsIgnoreCase(attributeName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeValue(String attributeName, String attributeValue) {
        for (int i = 0; i < this.attributeNames.length; ++i) {
            if (!this.attributeNames[i].equalsIgnoreCase(attributeName)) continue;
            Attribute a = new Attribute(attributeName, this.schema, attributeValue);
            Attribute b = new Attribute(attributeName, this.schema, this.attributeValues[i].stringValue());
            if (!a.equals(b)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeValue(String attributeName, byte[] attributeValue) {
        for (int i = 0; i < this.attributeNames.length; ++i) {
            if (!this.attributeNames[i].equalsIgnoreCase(attributeName)) continue;
            Attribute a = new Attribute(attributeName, this.schema, (byte[][])new byte[][]{attributeValue});
            Attribute b = new Attribute(attributeName, this.schema, (byte[][])new byte[][]{this.attributeValues[i].getValue()});
            if (!a.equals(b)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.rdnString == null) {
            StringBuilder buffer = new StringBuilder();
            this.toString(buffer, false);
            this.rdnString = buffer.toString();
        }
        return this.rdnString;
    }

    public String toMinimallyEncodedString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer, true);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        this.toString(buffer, false);
    }

    public void toString(StringBuilder buffer, boolean minimizeEncoding) {
        if (this.rdnString != null && !minimizeEncoding) {
            buffer.append(this.rdnString);
            return;
        }
        for (int i = 0; i < this.attributeNames.length; ++i) {
            if (i > 0) {
                buffer.append('+');
            }
            buffer.append(this.attributeNames[i]);
            buffer.append('=');
            String valueString = this.attributeValues[i].stringValue();
            int length = valueString.length();
            block7: for (int j = 0; j < length; ++j) {
                char c = valueString.charAt(j);
                switch (c) {
                    case '\"': 
                    case '+': 
                    case ',': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '\\': {
                        buffer.append('\\');
                        buffer.append(c);
                        continue block7;
                    }
                    case '#': {
                        if (j == 0) {
                            buffer.append("\\#");
                            continue block7;
                        }
                        buffer.append('#');
                        continue block7;
                    }
                    case ' ': {
                        if (j == 0 || j + 1 == length) {
                            buffer.append("\\ ");
                            continue block7;
                        }
                        buffer.append(' ');
                        continue block7;
                    }
                    case '\u0000': {
                        buffer.append("\\00");
                        continue block7;
                    }
                    default: {
                        if (!(minimizeEncoding || c >= ' ' && c <= '~')) {
                            StaticUtils.hexEncode(c, buffer);
                            continue block7;
                        }
                        buffer.append(c);
                    }
                }
            }
        }
    }

    public String toNormalizedString() {
        if (this.normalizedString == null) {
            StringBuilder buffer = new StringBuilder();
            this.toNormalizedString(buffer);
            this.normalizedString = buffer.toString();
        }
        return this.normalizedString;
    }

    public void toNormalizedString(StringBuilder buffer) {
        if (this.attributeNames.length == 1) {
            String name = this.normalizeAttrName(this.attributeNames[0]);
            buffer.append(name);
            buffer.append('=');
            buffer.append((CharSequence)this.normalizeValue(name, this.attributeValues[0]));
        } else {
            int i;
            TreeMap<String, ASN1OctetString> valueMap = new TreeMap<String, ASN1OctetString>();
            for (i = 0; i < this.attributeNames.length; ++i) {
                String name = this.normalizeAttrName(this.attributeNames[i]);
                valueMap.put(name, this.attributeValues[i]);
            }
            i = 0;
            for (Map.Entry entry : valueMap.entrySet()) {
                if (i++ > 0) {
                    buffer.append('+');
                }
                buffer.append((String)entry.getKey());
                buffer.append('=');
                buffer.append((CharSequence)this.normalizeValue((String)entry.getKey(), (ASN1OctetString)entry.getValue()));
            }
        }
    }

    private String normalizeAttrName(String name) {
        AttributeTypeDefinition at;
        String n = name;
        if (this.schema != null && (at = this.schema.getAttributeType(name)) != null) {
            n = at.getNameOrOID();
        }
        return StaticUtils.toLowerCase(n);
    }

    public static String normalize(String s) throws LDAPException {
        return RDN.normalize(s, null);
    }

    public static String normalize(String s, Schema schema) throws LDAPException {
        return new RDN(s, schema).toNormalizedString();
    }

    private StringBuilder normalizeValue(String attributeName, ASN1OctetString value) {
        ASN1OctetString rawNormValue;
        MatchingRule matchingRule = MatchingRule.selectEqualityMatchingRule(attributeName, this.schema);
        try {
            rawNormValue = matchingRule.normalize(value);
        }
        catch (Exception e) {
            Debug.debugException(e);
            rawNormValue = new ASN1OctetString(StaticUtils.toLowerCase(value.stringValue()));
        }
        String valueString = rawNormValue.stringValue();
        int length = valueString.length();
        StringBuilder buffer = new StringBuilder(length);
        block7: for (int i = 0; i < length; ++i) {
            char c = valueString.charAt(i);
            switch (c) {
                case '\"': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': {
                    buffer.append('\\');
                    buffer.append(c);
                    continue block7;
                }
                case '#': {
                    if (i == 0) {
                        buffer.append("\\#");
                        continue block7;
                    }
                    buffer.append('#');
                    continue block7;
                }
                case ' ': {
                    if (i == 0 || i + 1 == length) {
                        buffer.append("\\ ");
                        continue block7;
                    }
                    buffer.append(' ');
                    continue block7;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        StaticUtils.hexEncode(c, buffer);
                        continue block7;
                    }
                    buffer.append(c);
                }
            }
        }
        return buffer;
    }

    public int hashCode() {
        return this.toNormalizedString().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof RDN)) {
            return false;
        }
        RDN rdn = (RDN)o;
        return this.toNormalizedString().equals(rdn.toNormalizedString());
    }

    public boolean equals(String s) throws LDAPException {
        if (s == null) {
            return false;
        }
        return this.equals(new RDN(s, this.schema));
    }

    public static boolean equals(String s1, String s2) throws LDAPException {
        return new RDN(s1).equals(new RDN(s2));
    }

    @Override
    public int compareTo(RDN rdn) {
        return this.compare(this, rdn);
    }

    @Override
    public int compare(RDN rdn1, RDN rdn2) {
        Validator.ensureNotNull(rdn1, rdn2);
        return rdn1.toNormalizedString().compareTo(rdn2.toNormalizedString());
    }

    public static int compare(String s1, String s2) throws LDAPException {
        return RDN.compare(s1, s2, null);
    }

    public static int compare(String s1, String s2, Schema schema) throws LDAPException {
        return new RDN(s1, schema).compareTo(new RDN(s2, schema));
    }
}

