/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile.f43;

import com.sun.tdk.signaturetest.core.PrimitiveTypes;
import com.sun.tdk.signaturetest.core.context.ModFeatures;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.ModuleDescription;
import com.sun.tdk.signaturetest.sigfile.ModWriter;
import com.sun.tdk.signaturetest.sigfile.f42.F42Writer;
import com.sun.tdk.signaturetest.sigfile.f43.F43Format;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class F43Writer
extends F42Writer
implements ModWriter {
    private PrintWriter out;

    public F43Writer() {
        this.setFormat(new F43Format());
    }

    @Override
    public void init(PrintWriter out) {
        this.out = out;
        super.init(out);
    }

    @Override
    public void write(ClassDescription classDescription) {
        super.write(classDescription);
    }

    @Override
    protected void write(StringBuffer buf, MethodDescr m) {
        Object ad;
        this.writeMeth(buf, m);
        if (m.hasModifier(Modifier.HASDEFAULT) && (ad = m.getAnnoDef()) != null) {
            buf.append(" value= ");
            buf.append(PrimitiveTypes.simpleObjectToString(ad));
        }
        this.addAnnotations(buf, m);
    }

    @Override
    public void write(ModuleDescription md) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element eModule = doc.createElement("module");
            eModule.setAttribute("name", md.getName());
            Set<ModFeatures> features = md.getFeatures();
            eModule.setAttribute("features", ModFeatures.commaListFromFeatureSet(features));
            if ((features.contains((Object)ModFeatures.ALL) || features.contains((Object)ModFeatures.VERSION)) && !md.getVersion().isEmpty()) {
                eModule.setAttribute("version", md.getVersion());
            }
            if ((features.contains((Object)ModFeatures.ALL) || features.contains((Object)ModFeatures.MAIN_CLASS)) && !md.getMainClass().isEmpty()) {
                eModule.setAttribute("main-class", md.getMainClass());
            }
            doc.appendChild(eModule);
            if (features.contains((Object)ModFeatures.ALL) || features.contains((Object)ModFeatures.PACKAGES)) {
                for (String packName : md.getPackages()) {
                    Element ePack = doc.createElement("package");
                    ePack.setAttribute("name", packName);
                    eModule.appendChild(ePack);
                }
            }
            if (features.contains((Object)ModFeatures.ALL) || features.contains((Object)ModFeatures.EXPORTS_PUBLIC) || features.contains((Object)ModFeatures.EXPORTS_ALL)) {
                for (ModuleDescription.Exports ex : md.getExports()) {
                    if (!ex.targets.isEmpty() && !features.contains((Object)ModFeatures.ALL) && !features.contains((Object)ModFeatures.EXPORTS_ALL)) continue;
                    Element eExp = doc.createElement("exports");
                    eExp.setAttribute("source", ex.source);
                    for (String target : ex.targets) {
                        Element eTarget = doc.createElement("target");
                        eTarget.setAttribute("name", target);
                        eExp.appendChild(eTarget);
                    }
                    eModule.appendChild(eExp);
                }
            }
            for (ModuleDescription.Requires re : md.getRequires()) {
                if (!features.contains((Object)ModFeatures.ALL) && !features.contains((Object)ModFeatures.REQUIRES_ALL) && (!features.contains((Object)ModFeatures.REQUIRES_TRANSITIVE) || !re.modifiers.contains((Object)ModuleDescription.Requires.Modifier.TRANSITIVE))) continue;
                Element eReq = doc.createElement("requires");
                eReq.setAttribute("name", re.name);
                for (ModuleDescription.Requires.Modifier m : re.modifiers) {
                    eReq.setAttribute(m.name().toLowerCase(), "true");
                }
                eModule.appendChild(eReq);
            }
            if (features.contains((Object)ModFeatures.ALL) || features.contains((Object)ModFeatures.SERVICES)) {
                for (ModuleDescription.Provides pr : md.getProvides().values()) {
                    Element ePr = doc.createElement("provides");
                    ePr.setAttribute("service", pr.service);
                    eModule.appendChild(ePr);
                }
            }
            if (features.contains((Object)ModFeatures.ALL) || features.contains((Object)ModFeatures.USES)) {
                for (String uses : md.getUses()) {
                    Element eUses = doc.createElement("uses");
                    eUses.setAttribute("name", uses);
                    eModule.appendChild(eUses);
                }
            }
            this.out.println(this.getStringFromDocument(doc));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public String getStringFromDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

