/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.ActiveConnectionFactory;
import com.sun.javatest.agent.BadValue;
import com.sun.javatest.agent.ConnectionFactory;
import com.sun.javatest.agent.ModeOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Label;
import java.awt.TextField;

class ActiveModeOptions
extends ModeOptions {
    private TextField hostField;
    private Label portLabel;
    private TextField portField;

    ActiveModeOptions() {
        super("active");
        GridBagConstraints c = new GridBagConstraints();
        Label hostLabel = new Label("host:");
        this.add((Component)hostLabel, c);
        this.hostField = new TextField(20);
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)this.hostField, c);
        this.portLabel = new Label("port:");
        c.weightx = 0.0;
        this.add((Component)this.portLabel, c);
        String defActPort = Integer.toString(1907);
        this.portField = new TextField(defActPort, 5);
        this.add((Component)this.portField, c);
    }

    @Override
    ConnectionFactory createConnectionFactory(int concurrency) throws BadValue {
        String host = this.hostField.getText();
        if (host == null || host.length() == 0) {
            throw new BadValue("no host name set");
        }
        int port = ActiveModeOptions.getInt("port", this.portField);
        if (port < 0) {
            throw new BadValue("port may not be negative");
        }
        return new ActiveConnectionFactory(host, port);
    }

    void setHost(String host) {
        this.hostField.setText(host);
    }

    void setPort(int port) {
        this.portField.setText(Integer.toString(port));
    }
}

