/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.assembly.standalone.war;

import com.sun.ts.lib.harness.Fault;
import com.sun.ts.lib.harness.SetupException;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.EETest;
import com.sun.ts.tests.common.web.JSPBeanWrapper;
import com.sun.ts.tests.common.web.WebUtil;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.porting.lib.spi.TestArchiveProcessor;

@Tags(value={@Tag(value="assembly"), @Tag(value="platform"), @Tag(value="tck-appclient")})
@ExtendWith(value={ArquillianExtension.class})
@TestMethodOrder(value=MethodOrderer.MethodName.class)
public class Client
extends EETest {
    public static final String urlLookup = "java:comp/env/url/myURL";
    public static final String jspPropName = "standalone_war";
    private Properties props = null;
    private TSNamingContext nctx = null;
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    static final String VEHICLE_ARCHIVE = "assembly_standalone_war";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Fault {
        this.props = p;
        try {
            TestUtil.logTrace((String)"[Client] Getting Naming Context...");
            this.nctx = new TSNamingContext();
        }
        catch (Exception e) {
            throw new Fault("Setup failed:" + String.valueOf(e), (Throwable)e);
        }
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @TargetsContainer(value="tck-appclient")
    @OverProtocol(value="appclient")
    @Deployment(name="assembly_standalone_war", order=2)
    public static EnterpriseArchive createEarDeploymentVehicle(@ArquillianResource TestArchiveProcessor archiveProcessor) {
        JavaArchive assembly_standalone_war_client = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"assembly_standalone_war_client.jar");
        assembly_standalone_war_client.addClasses(new Class[]{Fault.class, EETest.class, SetupException.class, Client.class});
        URL resURL = Client.class.getResource("assembly_standalone_war_client.xml");
        if (resURL != null) {
            assembly_standalone_war_client.addAsManifestResource(resURL, "application-client.xml");
        }
        if ((resURL = Client.class.getResource("assembly_standalone_war_client.jar.sun-application-client.xml")) != null) {
            assembly_standalone_war_client.addAsManifestResource(resURL, "sun-application-client.xml");
        }
        assembly_standalone_war_client.addAsManifestResource((Asset)new StringAsset("Main-Class: " + Client.class.getName() + "\n"), "MANIFEST.MF");
        archiveProcessor.processClientArchive(assembly_standalone_war_client, Client.class, resURL);
        EnterpriseArchive assembly_standalone_war_ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"assembly_standalone_war.ear");
        assembly_standalone_war_ear.addAsModule((Archive)assembly_standalone_war_client);
        return assembly_standalone_war_ear;
    }

    @Deployment(name="assembly_standalone_war_component_web", order=1, testable=false)
    public static WebArchive createWarDeploymentVehicle(@ArquillianResource TestArchiveProcessor archiveProcessor) {
        URL jspURL;
        WebArchive assembly_standalone_war_component_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"assembly_standalone_war_component_web.war");
        assembly_standalone_war_component_web.addClasses(new Class[]{WebUtil.class, JSPBeanWrapper.class});
        URL resURL = Client.class.getResource("assembly_standalone_war_component_web.xml");
        if (resURL != null) {
            assembly_standalone_war_component_web.addAsWebInfResource(resURL, "web.xml");
        }
        if ((jspURL = Client.class.getResource("test.jsp")) != null) {
            assembly_standalone_war_component_web.addAsWebResource(jspURL, "test.jsp");
        }
        if ((resURL = Client.class.getResource("assembly_standalone_war_component_web.war.sun-web.xml")) != null) {
            assembly_standalone_war_component_web.addAsWebInfResource(resURL, "sun-web.xml");
        }
        assembly_standalone_war_component_web.addAsManifestResource((Asset)new StringAsset("Main-Class: " + Client.class.getName() + "\n"), "MANIFEST.MF");
        archiveProcessor.processWebArchive(assembly_standalone_war_component_web, Client.class, resURL);
        return assembly_standalone_war_component_web;
    }

    @Test
    @OperateOnDeployment(value="assembly_standalone_war")
    public void testStandaloneWar() throws Fault {
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"[Client] looking up java:comp/env/url/myURL");
            URL myUrl = (URL)this.nctx.lookup(urlLookup);
            TestUtil.logTrace((String)"[Client] get a new URL connection...");
            URLConnection urlConnection = myUrl.openConnection();
            Properties jspProps = TestUtil.getResponseProperties((URLConnection)urlConnection);
            String value = jspProps.getProperty(jspPropName);
            boolean bl = pass = null != value && value.equals("true");
            if (!pass) {
                throw new Fault("Standalone war test failed: standalone_war = " + (null == value ? "null" : value) + ", expected 'true'!");
            }
        }
        catch (Exception e) {
            this.logErr("[Client] Stand-alone test failed: " + String.valueOf(e));
            throw new Fault("Stand-alone test failed: ", (Throwable)e);
        }
    }

    public void cleanup() throws Fault {
        this.logMsg("[Client] cleanup()");
    }
}

