/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.embedded.adapter1;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.WorkImpl;
import com.sun.ts.tests.common.connector.whitebox.WorkListenerImpl;
import com.sun.ts.tests.common.connector.whitebox.XidImpl;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.XATerminator;
import jakarta.resource.spi.work.ExecutionContext;
import jakarta.resource.spi.work.TransactionContext;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkException;
import jakarta.resource.spi.work.WorkListener;
import jakarta.resource.spi.work.WorkManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class CRDWorkManager {
    private BootstrapContext bsc = null;
    private WorkManager wmgr;
    private Xid myxid;
    private Xid mynestxid;
    private XATerminator xa;

    public CRDWorkManager(BootstrapContext val) {
        this.debug("enterred constructor");
        this.bsc = val;
        this.wmgr = this.bsc.getWorkManager();
        this.xa = this.bsc.getXATerminator();
        this.debug("leaving constructor");
    }

    public void runTests() {
        this.debug("enterred runTests");
        this.doWork();
        this.doTCWork();
        this.debug("leaving runTests");
    }

    public void doWork() {
        this.debug("enterred doWork");
        try {
            WorkImpl workimpl = new WorkImpl(this.wmgr);
            ExecutionContext ec = new ExecutionContext();
            WorkListenerImpl wl = new WorkListenerImpl();
            this.wmgr.doWork((Work)workimpl, 5000L, ec, (WorkListener)wl);
            ConnectorStatus.getConnectorStatus().logState("CRDWorkManager Work Object Submitted");
            this.debug("CRDWorkManager Work Object Submitted");
        }
        catch (WorkException we) {
            System.out.println("CRDWorkManager WorkException thrown is " + we.getMessage());
        }
        catch (Exception ex) {
            System.out.println("CRDWorkManager Exception thrown is " + ex.getMessage());
        }
        this.debug("leaving doWork");
    }

    private TransactionContext startTx() {
        TransactionContext tc = new TransactionContext();
        try {
            XidImpl xid = new XidImpl();
            tc.setXid((Xid)xid);
            tc.setTransactionTimeout(5000L);
        }
        catch (Exception ex) {
            Debug.printDebugStack((Exception)ex);
        }
        return tc;
    }

    public void doTCWork() {
        try {
            XidImpl myid = new XidImpl();
            WorkImpl workimpl = new WorkImpl(this.wmgr);
            TransactionContext tc = this.startTx();
            tc.setXid((Xid)myid);
            Debug.trace((String)"Creating WorkListener");
            WorkListenerImpl wl = new WorkListenerImpl();
            this.wmgr.doWork((Work)workimpl, 5000L, (ExecutionContext)tc, (WorkListener)wl);
            this.xa.commit(tc.getXid(), true);
        }
        catch (XAException xe) {
            Debug.trace((String)("CRDWorkManager.doTCWork():  XAException" + xe.getMessage()));
            Debug.printDebugStack((Exception)xe);
        }
        catch (WorkException we) {
            Debug.trace((String)("TestWorkManager Exception thrown is " + we.getMessage()));
        }
    }

    public void setXid(Xid xid) {
        this.myxid = xid;
    }

    public Xid getXid() {
        return this.myxid;
    }

    public void setNestXid(Xid xid) {
        this.mynestxid = xid;
    }

    public Xid getNestXid() {
        return this.mynestxid;
    }

    public void debug(String out) {
        Debug.trace((String)("CRDWorkManager:  " + out));
    }
}

