/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.selectorTopic;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.util.Properties;

public class MsgSelectorTopicTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.selectorTopic.MsgSelectorTopicTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private transient Message msg = null;
    private transient TopicSubscriber subscriber = null;
    private transient TemporaryTopic tempT = null;
    private transient TopicPublisher publisher = null;
    private transient TopicConnection tConnect;
    private transient TopicSession session;
    private transient TopicConnectionFactory tFactory;
    private boolean transacted = false;
    private Properties props = null;
    private long jms_timeout;
    private String jmsUser = null;
    private String jmsPassword = null;
    private String mode = null;
    private boolean noLocal = false;

    public static void main(String[] args) {
        MsgSelectorTopicTests theTests = new MsgSelectorTopicTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void startTest(String selector, String headerValue) throws Exception {
        this.logTrace("startTest(): Creating receiver with message selector");
        this.tempT = this.session.createTemporaryTopic();
        this.subscriber = this.session.createSubscriber((Topic)this.tempT, selector, this.noLocal);
        this.logTrace("Creating message");
        this.msg = this.session.createMessage();
        this.msg.setStringProperty("COM_SUN_JMS_TESTNAME", "MsgSelectorTopicTests");
        this.msg.setJMSType(headerValue);
    }

    private void finishTestReceive() throws Exception {
        this.logTrace("finishTestReceive(): Sending test message");
        this.msg.setBooleanProperty("first_message", true);
        this.publisher = this.session.createPublisher((Topic)this.tempT);
        this.publisher.publish(this.msg);
        this.logTrace("Attempt to receive message");
        Message msg1 = this.subscriber.receive(this.jms_timeout);
        this.logTrace("Received message: " + String.valueOf(msg1));
        if (msg1 == null) {
            throw new Exception("Did not receive message!");
        }
        if (!msg1.getBooleanProperty("first_message")) {
            this.logMsg("Received completely unexpected message.");
            throw new Exception("Received unexpected message -- not part of test");
        }
        this.logTrace("test passed");
    }

    private void sendFirstMessage() throws JMSException {
        this.logTrace("sendFirstMessage(): Sending message that does not match selector");
        this.msg.setBooleanProperty("second_message", false);
        this.publisher = this.session.createPublisher((Topic)this.tempT);
        this.publisher.publish(this.msg);
        this.msg = this.session.createMessage();
        this.msg.setStringProperty("COM_SUN_JMS_TESTNAME", "MsgSelectorTopicTests_2");
    }

    private void finishTest() throws Exception {
        this.logTrace("finishTest: Sending message that should match selector");
        this.msg.setBooleanProperty("second_message", true);
        this.publisher = this.session.createPublisher((Topic)this.tempT);
        this.publisher.publish(this.msg);
        this.logTrace("Attempt to receive message. Should receive second message only.");
        Message msg1 = this.subscriber.receive(this.jms_timeout);
        this.logTrace("Received message: " + String.valueOf(msg1));
        if (msg1 == null) {
            throw new Exception("Did not receive message!");
        }
        if (msg1.getBooleanProperty("second_message")) {
            this.logTrace("test passed");
        } else if (!msg1.getBooleanProperty("second_message")) {
            throw new Exception("Incorrectly received non-matching message!");
        }
    }

    private void cleanupSubscription(TopicSubscriber sub, TopicSession session, String subName) {
        if (sub != null) {
            try {
                TestUtil.logTrace((String)("Closing durable subscriber: " + String.valueOf(sub)));
                sub.close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"exception during close: ", (Throwable)e);
            }
        }
        if (session != null) {
            try {
                TestUtil.logTrace((String)("Unsubscribing \"" + subName + "\""));
                session.unsubscribe(subName);
            }
            catch (Exception e) {
                TestUtil.logErr((String)"exception during unsubscribe: ", (Throwable)e);
            }
        }
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.props = p;
            this.jms_timeout = Long.parseLong(this.props.getProperty("jms_timeout"));
            if (this.jms_timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
            this.jmsUser = this.props.getProperty("user");
            this.jmsPassword = this.props.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            this.tool = new JmsTool(8, this.jmsUser, this.jmsPassword, this.mode);
            this.tFactory = this.tool.getTopicConnectionFactory();
            this.tConnect = this.tFactory.createTopicConnection(this.jmsUser, this.jmsPassword);
            this.tConnect.start();
            this.session = this.tConnect.createTopicSession(this.transacted, 1);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            this.logTrace(" closing connection");
            this.tConnect.close();
            this.tempT = null;
            this.session.close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    public void selectorTest01() throws Exception {
        try {
            String selector = "JMSType='literal'";
            String value = "literal";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void identifierTest01() throws Exception {
        try {
            String selector = "$myProp=TRUE AND _myProp=FALSE";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("$myProp", true);
            this.msg.setBooleanProperty("_myProp", false);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void whitespaceTest1() throws Exception {
        try {
            String selector = "JMSType   =   'foo'";
            String value = "foo";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void expressionTest1() throws Exception {
        try {
            String selector = "myProp";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myProp", true);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void bracketingTest1() throws Exception {
        try {
            String selector = "(myTrueProp OR myFalseProp) AND myFalseProp";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myTrueProp", true);
            this.msg.setBooleanProperty("myFalseProp", false);
            this.sendFirstMessage();
            this.msg.setBooleanProperty("myTrueProp", true);
            this.msg.setBooleanProperty("myFalseProp", true);
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void comparisonTest01() throws Exception {
        try {
            String selector = "myProp0 = 'foo' AND myProp1 > 0 AND myProp2 >= 2 AND myProp3 >= 2 AND myProp4 < 5 AND myProp5 <= 6 AND myProp6 <= 6 AND myProp7 <> 7";
            String value = "";
            this.startTest(selector, value);
            this.msg.setStringProperty("myProp0", "foo");
            this.msg.setIntProperty("myProp1", 1);
            this.msg.setFloatProperty("myProp2", 2.0f);
            this.msg.setIntProperty("myProp3", 3);
            this.msg.setDoubleProperty("myProp4", 4.0);
            this.msg.setIntProperty("myProp5", 5);
            this.msg.setIntProperty("myProp6", 6);
            this.msg.setFloatProperty("myProp7", 0.0f);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void operatorTest1() throws Exception {
        try {
            String selector = "-myProp0 < 0 AND +myProp1 < 0";
            String value = "";
            this.startTest(selector, value);
            this.msg.setIntProperty("myProp0", 5);
            this.msg.setIntProperty("myProp1", -5);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void betweenTest1() throws Exception {
        try {
            String selector = "myProp0 BETWEEN 5 and 10 AND myProp1 BETWEEN -1 and 1 AND myProp2 BETWEEN 0 and 2";
            String value = "";
            this.startTest(selector, value);
            this.msg.setIntProperty("myProp0", 7);
            this.msg.setIntProperty("myProp1", -1);
            this.msg.setIntProperty("myProp2", 2);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void inTest1() throws Exception {
        try {
            String selector = "JMSType IN ('foo','jms','test')";
            String value = "jms";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest01() throws Exception {
        try {
            String selector = "JMSType LIKE 'jms'";
            String value = "jms";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void isNullTest1() throws Exception {
        try {
            String selector = "myNullProp IS NULL";
            String value = "";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void caseTest1() throws Exception {
        try {
            String selector = "myProp0 is null and myProp1 like 'fooG_%' escape 'G' and myProp2 in ('a', 'b') and myProp3 not between 0 and 10 and (myProp4 or false)";
            String value = "";
            this.startTest(selector, value);
            this.msg.setStringProperty("myProp1", "foo_test");
            this.msg.setStringProperty("myProp2", "a");
            this.msg.setIntProperty("myProp3", 20);
            this.msg.setBooleanProperty("myProp4", true);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void precedenceTest1() throws Exception {
        try {
            String selector = "NOT myTrueProp AND myFalseProp";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myTrueProp", true);
            this.msg.setBooleanProperty("myFalseProp", false);
            this.sendFirstMessage();
            this.msg.setBooleanProperty("myTrueProp", false);
            this.msg.setBooleanProperty("myFalseProp", true);
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void nullTest01() throws Exception {
        try {
            String selector = "myProp + 2 < 10";
            String value = "";
            this.startTest(selector, value);
            this.sendFirstMessage();
            this.msg.setIntProperty("myProp", 0);
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void nullTest11() throws Exception {
        try {
            String selector = null;
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myNullProp", false);
            this.finishTest();
        }
        catch (Exception e) {
            throw new Exception("test failed", e);
        }
    }

    public void emptyTest() throws Exception {
        try {
            String selector = "";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myEmptyProp", false);
            this.finishTest();
        }
        catch (Exception e) {
            throw new Exception("test failed", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void durableTopicEmptyStringSelTest() throws Exception {
        String lookupDurable = "DURABLE_SUB_CONNECTION_FACTORY";
        String lookupNonDurable = "MyTopicConnectionFactory";
        String msgSelectorEmptyString = "";
        TopicSubscriber durableTS = null;
        boolean noLocal = false;
        boolean pass = true;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TestUtil.logMsg((String)"TEST CASE [message selector=empty string] test case");
            TestUtil.logMsg((String)"BEGIN STEP1");
            TestUtil.logMsg((String)"Setup JmsTool for TOPIC using connection factory with ClientID set");
            this.tool = new JmsTool(4, this.jmsUser, this.jmsPassword, lookupDurable, this.mode);
            TestUtil.logMsg((String)"Create durable subscription subname=mySubTestEmptyString, msgSelector=\"\" and noLocal=false");
            this.tool.getDefaultTopicSubscriber().close();
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "mySubTestEmptyString", msgSelectorEmptyString, noLocal);
            TestUtil.logMsg((String)"Close connection and resources");
            durableTS.close();
            this.tool.closeAllResources();
            this.tool.getDefaultTopicConnection().close();
            TestUtil.logMsg((String)"END STEP1");
            TestUtil.logMsg((String)"BEGIN STEP2");
            TestUtil.logMsg((String)"Setup JmsTool for TOPIC using connection factory with no ClientID set");
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, lookupNonDurable, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logMsg((String)"Create a message and publish the message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage("Hello There!");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableTopicEmptyStringSelTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logMsg((String)"Close connection and resources");
            this.tool.closeAllResources();
            this.tool.getDefaultTopicConnection().close();
            TestUtil.logMsg((String)"END STEP2");
            TestUtil.logMsg((String)"BEGIN STEP3");
            TestUtil.logMsg((String)"Setup JmsTool for TOPIC using connection factory with ClientID set");
            this.tool = new JmsTool(4, this.jmsUser, this.jmsPassword, lookupDurable, this.mode);
            TestUtil.logMsg((String)"Reactivate durable subscription subname=mySubTestEmptyString in STEP1");
            this.tool.getDefaultTopicSubscriber().close();
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "mySubTestEmptyString");
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logMsg((String)"Receive the message that was sent in STEP2");
            messageReceived = (TextMessage)durableTS.receive(this.jms_timeout);
            if (messageReceived == null) {
                TestUtil.logErr((String)"didn't get the message");
                TestUtil.logErr((String)"TEST CASE [message selector=empty string] failed");
                pass = false;
            } else if (messageReceived.getText().equals(messageSent.getText())) {
                TestUtil.logMsg((String)("Received correct message: text=[" + messageReceived.getText() + "]"));
                TestUtil.logMsg((String)"TEST CASE [message selector=empty string] passed");
            } else {
                TestUtil.logErr((String)("Received incorrect message: text=[" + messageReceived.getText() + "] expected=[Hello There!]"));
                TestUtil.logErr((String)"didn't get the right message");
                TestUtil.logErr((String)"TEST CASE [message selector=empty string] failed");
                pass = false;
            }
            TestUtil.logMsg((String)"END STEP3");
        }
        catch (Exception e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception("durableTopicEmptyStringSelTest failed");
            }
            catch (Throwable throwable) {
                try {
                    this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "mySubTestEmptyString");
                    this.tool.closeAllResources();
                    this.tool.getDefaultTopicConnection().close();
                    throw throwable;
                }
                catch (Exception e2) {
                    TestUtil.printStackTrace((Throwable)e2);
                    throw new Exception("durableTopicEmptyStringSelTest during cleanup");
                }
            }
        }
        try {
            this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "mySubTestEmptyString");
            this.tool.closeAllResources();
            this.tool.getDefaultTopicConnection().close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("durableTopicEmptyStringSelTest during cleanup");
        }
        if (pass) return;
        throw new Exception("durableTopicEmptyStringSelTest failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void durableTopicNullSelTest() throws Exception {
        String lookupDurable = "DURABLE_SUB_CONNECTION_FACTORY";
        String lookupNonDurable = "MyTopicConnectionFactory";
        String msgSelectorNull = null;
        TopicSubscriber durableTS = null;
        boolean noLocal = false;
        boolean pass = true;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TestUtil.logMsg((String)"TEST CASE [message selector=null] test case");
            TestUtil.logMsg((String)"BEGIN STEP1");
            TestUtil.logMsg((String)"Setup JmsTool for TOPIC using connection factory with ClientID set");
            this.tool = new JmsTool(4, this.jmsUser, this.jmsPassword, lookupDurable, this.mode);
            TestUtil.logMsg((String)"Create durable subscription subname=mySubTestNull, msgSelector=null and noLocal=false");
            this.tool.getDefaultTopicSubscriber().close();
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "mySubTestNull", msgSelectorNull, noLocal);
            TestUtil.logMsg((String)"Close connection and resources");
            durableTS.close();
            this.tool.closeAllResources();
            this.tool.getDefaultTopicConnection().close();
            TestUtil.logMsg((String)"END STEP1");
            TestUtil.logMsg((String)"BEGIN STEP2");
            TestUtil.logMsg((String)"Setup JmsTool for TOPIC using connection factory with no ClientID set");
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, lookupNonDurable, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logMsg((String)"Create a message and publish the message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage("Hello There!");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableTopicNullSelTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logMsg((String)"Close connection and resources");
            this.tool.closeAllResources();
            this.tool.getDefaultTopicConnection().close();
            TestUtil.logMsg((String)"END STEP2");
            TestUtil.logMsg((String)"BEGIN STEP3");
            TestUtil.logMsg((String)"Setup JmsTool for TOPIC using connection factory with ClientID set");
            this.tool = new JmsTool(4, this.jmsUser, this.jmsPassword, lookupDurable, this.mode);
            TestUtil.logMsg((String)"Reactivate durable subscription subname=mySubTestNull in STEP1");
            this.tool.getDefaultTopicSubscriber().close();
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "mySubTestNull");
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logMsg((String)"Receive the message that was sent in STEP2");
            messageReceived = (TextMessage)durableTS.receive(this.jms_timeout);
            if (messageReceived == null) {
                TestUtil.logErr((String)"didn't get the message");
                TestUtil.logErr((String)"TEST CASE [message selector=null] failed");
                pass = false;
            } else if (messageReceived.getText().equals(messageSent.getText())) {
                TestUtil.logMsg((String)("Received correct message: text=[" + messageReceived.getText() + "]"));
                TestUtil.logMsg((String)"TEST CASE [message selector=null] passed");
            } else {
                TestUtil.logErr((String)("Received incorrect message: text=[" + messageReceived.getText() + "] expected=[Hello There!]"));
                TestUtil.logErr((String)"didn't get the right message");
                TestUtil.logErr((String)"TEST CASE [message selector=null] failed");
                pass = false;
            }
            TestUtil.logMsg((String)"END STEP3");
        }
        catch (Exception e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception("durableTopicNullSelTest failed");
            }
            catch (Throwable throwable) {
                try {
                    this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "mySubTestNull");
                    this.tool.closeAllResources();
                    this.tool.getDefaultTopicConnection().close();
                    throw throwable;
                }
                catch (Exception e2) {
                    TestUtil.printStackTrace((Throwable)e2);
                    throw new Exception("durableTopicNullSelTest during cleanup");
                }
            }
        }
        try {
            this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "mySubTestNull");
            this.tool.closeAllResources();
            this.tool.getDefaultTopicConnection().close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("durableTopicNullSelTest during cleanup");
        }
        if (pass) return;
        throw new Exception("durableTopicNullSelTest failed");
    }
}

