/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.websocketmessagereturntype;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

@ServerEndpoint(value="/directbytebuffer")
public class WSDirectByteBufferServer {
    private File f;

    @OnClose
    public void onClose() {
        this.f.delete();
    }

    private static File createTempFile(String data) throws IOException {
        File f = File.createTempFile("tcktemp", "file");
        FileOutputStream fos = new FileOutputStream(f);
        fos.write(data.getBytes());
        fos.close();
        return f;
    }

    @OnMessage
    public ByteBuffer echo(String data) throws IOException {
        this.f = WSDirectByteBufferServer.createTempFile(data);
        FileInputStream fis = new FileInputStream(this.f);
        MappedByteBuffer mbb = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, data.length());
        fis.close();
        return mbb;
    }

    @OnError
    public void onError(Session session, Throwable t) throws IOException {
        t.printStackTrace();
        String message = "Exception: " + IOUtil.printStackTrace(t);
        session.getBasicRemote().sendText(message);
    }
}

