/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server;

import com.sun.ts.tests.websocket.common.impl.StringPongMessage;
import com.sun.ts.tests.websocket.common.io.StringInputStream;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.common.TypeEnum;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server.InputStreamMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server.PongMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server.StringPartialMessageHandler;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.OnError;
import jakarta.websocket.OnOpen;
import jakarta.websocket.PongMessage;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.io.InputStream;

@ServerEndpoint(value="/exception")
public class WSCAnnotatedMixedServerEndpoint {
    public static final String EXCEPTION = "Exception: ";

    @OnOpen
    public void onOpen(Session session) {
        session.addMessageHandler(String.class, (MessageHandler.Partial)new StringThrowingPartialMessageHandler(session));
        session.addMessageHandler(InputStream.class, (MessageHandler.Whole)new InputStreamThrowingMessageHandler(session));
        session.addMessageHandler(PongMessage.class, (MessageHandler.Whole)new PongMessageThrowingMessageHandler(session));
    }

    @OnError
    public void onError(Session session, Throwable t) throws IOException {
        WSCAnnotatedMixedServerEndpoint.sendException(session, t);
    }

    static void sendException(Session session, Throwable t) {
        String ex = EXCEPTION + t.getMessage();
        try {
            session.getBasicRemote().sendText(ex);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    static class StringThrowingPartialMessageHandler
    extends StringPartialMessageHandler {
        public StringThrowingPartialMessageHandler(Session session) {
            super(session);
        }

        @Override
        public void onMessage(String partialMessage, boolean last) {
            if (TypeEnum.STRING_PARTIAL.name().equals(partialMessage)) {
                if (last) {
                    this.session.addMessageHandler(String.class, (MessageHandler.Partial)this);
                }
            } else {
                super.onMessage(partialMessage, last);
            }
        }
    }

    static class InputStreamThrowingMessageHandler
    extends InputStreamMessageHandler {
        public InputStreamThrowingMessageHandler(Session session) {
            super(session);
        }

        @Override
        public void onMessage(InputStream message) {
            String msg = null;
            try {
                msg = IOUtil.readFromStream(message);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (TypeEnum.INPUTSTREAM.name().equals(msg)) {
                this.session.addMessageHandler(InputStream.class, (MessageHandler.Whole)this);
            } else {
                super.onMessage(new StringInputStream(msg));
            }
        }
    }

    static class PongMessageThrowingMessageHandler
    extends PongMessageHandler {
        public PongMessageThrowingMessageHandler(Session session) {
            super(session);
        }

        @Override
        public void onMessage(PongMessage message) {
            String msg = null;
            msg = IOUtil.byteBufferToString(message.getApplicationData());
            if (TypeEnum.PONG.name().equals(msg)) {
                this.session.addMessageHandler(PongMessage.class, (MessageHandler.Whole)this);
            } else {
                super.onMessage(new StringPongMessage(msg));
            }
        }
    }
}

