/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.se.schemaGeneration.annotations.discriminatorColumn;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.se.schemaGeneration.annotations.discriminatorColumn.Simple;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    String schemaGenerationDir = null;
    String sTestCase = "jpa_se_schemaGeneration_annotations_discriminatorColumn";

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Simple"};
        return this.createDeploymentJar("jpa_se_schemaGeneration_annotations_discriminatorColumn.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.schemaGenerationDir = System.getProperty("user.dir");
            if (!this.schemaGenerationDir.endsWith(File.separator)) {
                this.schemaGenerationDir = this.schemaGenerationDir + File.separator;
            }
            this.schemaGenerationDir = this.schemaGenerationDir + "schemaGeneration";
            logger.log(System.Logger.Level.INFO, "schemaGenerationDir=" + this.schemaGenerationDir);
            File f = new File(this.schemaGenerationDir);
            logger.log(System.Logger.Level.INFO, "Delete existing directory ");
            this.deleteItem(f);
            logger.log(System.Logger.Level.INFO, "Create new directory ");
            if (!f.mkdir()) {
                String msg = "Could not mkdir:" + f.getAbsolutePath();
                throw new Exception(msg);
            }
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void discriminatorColumnTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        logger.log(System.Logger.Level.INFO, "Create the script(s)");
        String CREATEFILENAME = this.schemaGenerationDir + File.separator + "create_" + this.sTestCase + ".sql";
        String DROPFILENAME = this.schemaGenerationDir + File.separator + "drop_" + this.sTestCase + ".sql";
        File f1 = new File(CREATEFILENAME);
        logger.log(System.Logger.Level.TRACE, "Deleting previous create script");
        this.deleteItem(f1);
        File f2 = new File(DROPFILENAME);
        logger.log(System.Logger.Level.TRACE, "Deleting previous drop script");
        this.deleteItem(f2);
        Properties props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "none");
        props.put("jakarta.persistence.schema-generation.scripts.action", "drop-and-create");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "false");
        props.put("jakarta.persistence.schema-generation.scripts.create-target", this.convertToURI(CREATEFILENAME));
        props.put("jakarta.persistence.schema-generation.scripts.drop-target", this.convertToURI(DROPFILENAME));
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.createEntityManagerFactory(...)");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)props);
        emf.close();
        emf = null;
        logger.log(System.Logger.Level.INFO, "Check script(s) content");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("CREATE TABLE SCHEMAGENSIMPLE");
        expected.add("ID");
        expected.add("PRODUCT_TYPE");
        expected.add("PRIMARY KEY (ID)");
        pass1 = this.findDataInFile(f1, expected);
        expected.clear();
        expected.add("DROP TABLE");
        expected.add("SCHEMAGENSIMPLE");
        pass2 = this.findDataInFile(f2, expected);
        logger.log(System.Logger.Level.TRACE, "Execute the create script");
        props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "create");
        props.put("jakarta.persistence.schema-generation.scripts.action", "none");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "true");
        props.put("jakarta.persistence.schema-generation.create-script-source", this.convertToURI(CREATEFILENAME));
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        this.clearEMAndEMF();
        try {
            logger.log(System.Logger.Level.INFO, "Persist some data");
            this.getEntityTransaction(true).begin();
            Simple s = new Simple(1);
            this.getEntityManager().persist((Object)s);
            this.getEntityTransaction().commit();
            this.clearCache();
            Simple s2 = (Simple)this.getEntityManager().find(Simple.class, (Object)1);
            if (s.equals(s2)) {
                logger.log(System.Logger.Level.TRACE, "Received expected result:" + s.toString());
                pass3 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + s.toString());
                logger.log(System.Logger.Level.ERROR, "Actual:" + s2.toString());
            }
        }
        catch (Throwable t) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", t);
        }
        this.clearEMAndEMF();
        logger.log(System.Logger.Level.TRACE, "Execute the drop script");
        props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "drop");
        props.put("jakarta.persistence.schema-generation.scripts.action", "none");
        props.put("jakarta.persistence.schema-generation.drop-script-source", this.convertToURI(DROPFILENAME));
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        this.clearEMAndEMF();
        logger.log(System.Logger.Level.INFO, "Try to persist an entity, it should fail");
        try {
            this.getEntityTransaction(true).begin();
            Simple s3 = new Simple(2);
            this.getEntityManager().persist((Object)s3);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "An exception should have been thrown if drop had occurred successfully");
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.TRACE, "Receive expected exception");
            pass4 = true;
        }
        logger.log(System.Logger.Level.TRACE, "pass1:" + pass1);
        logger.log(System.Logger.Level.TRACE, "pass2:" + pass2);
        logger.log(System.Logger.Level.TRACE, "pass3:" + pass3);
        logger.log(System.Logger.Level.TRACE, "pass4:" + pass4);
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("discriminatorColumnTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Try to drop table SCHEMAGENSIMPLE");
            this.getEntityManager().createNativeQuery("DROP TABLE SCHEMAGENSIMPLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Throwable t) {
            logger.log(System.Logger.Level.INFO, "AN EXCEPTION WAS THROWN DURING DROP TABLE SCHEMAGENSIMPLE, IT MAY OR MAY NOT BE A PROBLEM, " + t.getMessage());
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
                this.clearEntityTransaction();
                this.clearEMAndEMF();
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

