/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.se.entityManagerFactory;

import ee.jakarta.tck.persistence.common.PMClientBase;
import jakarta.persistence.EntityManagerFactory;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client1
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());
    Properties props = null;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Member", pkgName + "Member_", pkgName + "Order", pkgName + "Order_"};
        return this.createDeploymentJar("jpa_se_entityManagerFactory.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupNoData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setupNoData");
        try {
            super.setup();
            this.createDeployment();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanupNoData() throws Exception {
        try {
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    @Test
    public void getMetamodelIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        try {
            EntityManagerFactory emf = this.getEntityManager().getEntityManagerFactory();
            emf.close();
            try {
                emf.getMetamodel();
                logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalStateException");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getMetamodelIllegalStateExceptionTest failed");
        }
    }
}

