/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.se.cache.xml.disableselective;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.se.cache.xml.disableselective.Customer;
import ee.jakarta.tck.persistence.se.cache.xml.disableselective.Order;
import jakarta.persistence.Cache;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] xmlFile = new String[]{"orm.xml"};
        String[] classes = new String[]{pkgName + "Customer", pkgName + "Order"};
        return this.createDeploymentJar("jpa_se_cache_xml_disableselective.jar", pkgNameWithoutSuffix, classes, "persistence.xml", xmlFile);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void containsTest() throws Exception {
        boolean pass2;
        boolean pass1;
        block10: {
            pass1 = false;
            pass2 = false;
            if (this.cachingSupported) {
                try {
                    EntityManager em2 = this.getEntityManager();
                    EntityTransaction et = this.getEntityTransaction();
                    et.begin();
                    Order order = new Order(1, 101);
                    em2.persist((Object)order);
                    logger.log(System.Logger.Level.TRACE, "persisted Order " + order);
                    Customer cust = new Customer("1", "one");
                    em2.persist((Object)cust);
                    logger.log(System.Logger.Level.TRACE, "persisted Customer " + cust);
                    em2.flush();
                    et.commit();
                    EntityManagerFactory emf = this.getEntityManagerFactory();
                    Cache cache = emf.getCache();
                    if (cache != null) {
                        boolean b1 = cache.contains(Order.class, (Object)1);
                        if (b1) {
                            logger.log(System.Logger.Level.TRACE, "Cache returned: " + b1 + ", therefore cache does contain order " + order);
                            pass1 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Cache returned: " + b1 + ", therefore cache does not contain order " + order);
                        }
                        boolean b2 = cache.contains(Customer.class, (Object)"1");
                        if (!b2) {
                            logger.log(System.Logger.Level.TRACE, "Cache returned: " + b2 + ", therefore cache does not contain Customer " + cust);
                            pass2 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Cache returned: " + b2 + ", therefore cache does contain Customer " + cust);
                        }
                        break block10;
                    }
                    logger.log(System.Logger.Level.ERROR, "Cache returned was null");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.INFO, "Cache not supported, bypassing test");
                pass1 = true;
                pass2 = true;
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("containsTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM CUSTOMER_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

