/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.types.auto;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.types.auto.DataTypes;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private DataTypes d0;
    private DataTypes d1;
    private DataTypes d2;
    private DataTypes newD1;
    private DataTypes newD2;
    private DataTypes newD3;
    private DataTypes newD4;
    private DataTypes newD5;
    private DataTypes newD6;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DataTypes"};
        return this.createDeploymentJar("jpa_core_types_auto.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void autoTypeTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin autoTypeTest1");
        boolean pass = false;
        Character newChar = Character.valueOf('b');
        try {
            this.getEntityTransaction().begin();
            this.newD1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)this.d0.getId());
            if (null != this.newD1) {
                if (this.newD1.getCharacterData().equals(Character.valueOf('a'))) {
                    this.newD1.setCharacterData(newChar);
                    this.newD1 = (DataTypes)this.getEntityManager().merge((Object)this.newD1);
                    this.getEntityManager().flush();
                    this.getEntityTransaction().commit();
                    this.clearCache();
                    this.getEntityTransaction().begin();
                    this.newD1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)this.newD1.getId());
                    if (null != this.newD1) {
                        if (this.newD1.getCharacterData().equals(newChar)) {
                            pass = true;
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "EntityManager.find (second) returned null result");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "EntityManager.find returned the wrong result, expected:" + this.d0.getId() + ", actual:" + this.newD1.getId());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("autoTypeTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void autoTypeTest2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin autoTypeTest2");
        boolean pass = false;
        Short newShort = 101;
        try {
            this.getEntityTransaction().begin();
            this.newD2 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)this.d1.getId());
            if (null != this.newD2) {
                if (this.newD2.getShortData().equals((short)100)) {
                    this.newD2.setShortData(newShort);
                }
                this.getEntityManager().merge((Object)this.newD2);
                this.getEntityManager().flush();
                if (this.newD2.getShortData().equals(newShort)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("autoTypeTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void autoTypeTest3() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin autoTypeTest3");
        boolean pass = false;
        Integer newInt = 500;
        try {
            this.getEntityTransaction().begin();
            this.newD3 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)this.d2.getId());
            if (null != this.newD3) {
                if (this.newD3.getIntegerData().equals(500)) {
                    this.newD3.setIntegerData(newInt);
                }
                this.getEntityManager().merge((Object)this.newD3);
                this.getEntityManager().flush();
                if (this.newD3.getIntegerData().equals(newInt)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("autoTypeTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void autoTypeTest4() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin autoTypeTest4");
        boolean pass = false;
        Long newLong = 600L;
        try {
            this.getEntityTransaction().begin();
            this.newD4 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)this.d0.getId());
            if (null != this.newD4) {
                if (this.newD4.getLongData().equals(300L)) {
                    this.newD4.setLongData(newLong);
                }
                this.getEntityManager().merge((Object)this.newD4);
                this.getEntityManager().flush();
                if (this.newD4.getLongData().equals(newLong)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("autoTypeTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void autoTypeTest5() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin autoTypeTest5");
        boolean pass = false;
        Double newDbl = 80.0;
        try {
            this.getEntityTransaction().begin();
            this.newD5 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)this.d1.getId());
            if (null != this.newD5) {
                if (this.newD5.getDoubleData().equals(50.0)) {
                    this.newD5.setDoubleData(newDbl);
                }
                this.getEntityManager().merge((Object)this.newD5);
                this.getEntityManager().flush();
                if (this.newD5.getDoubleData().equals(newDbl)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("autoTypeTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void autoTypeTest6() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin autoTypeTest6");
        boolean pass = false;
        Float newFloat = Float.valueOf(3.0f);
        try {
            this.getEntityTransaction().begin();
            this.newD6 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)this.d2.getId());
            if (null != this.newD6) {
                if (this.newD6.getFloatData().equals(Float.valueOf(1.0f))) {
                    this.newD6.setFloatData(newFloat);
                }
                this.getEntityManager().merge((Object)this.newD6);
                this.getEntityManager().flush();
                if (this.newD6.getFloatData().equals(newFloat)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("autoTypeTest6 failed");
        }
    }

    public void createTestData() {
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "In createTestData");
            this.d0 = new DataTypes(Character.valueOf('a'), (short)100, 500, 300L, 50.0, Float.valueOf(1.0f));
            this.d1 = new DataTypes(Character.valueOf('a'), (short)100, 500, 300L, 50.0, Float.valueOf(1.0f));
            this.d2 = new DataTypes(Character.valueOf('a'), (short)100, 500, 300L, 50.0, Float.valueOf(1.0f));
            logger.log(System.Logger.Level.TRACE, "Persist DataType");
            this.getEntityManager().persist((Object)this.d0);
            this.getEntityManager().persist((Object)this.d1);
            this.getEntityManager().persist((Object)this.d2);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

