/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.relationship.defaults;

import ee.jakarta.tck.persistence.core.relationship.defaults.Person;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToOne;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;

@Entity
public class Project
implements Serializable {
    private static final System.Logger logger = System.getLogger(Project.class.getName());
    private long projId;
    private String name;
    private BigDecimal budget;
    private Person projectLead;
    private Collection<Person> persons = new ArrayList<Person>();

    public Project() {
        logger.log(System.Logger.Level.TRACE, "Project no-arg constructor");
    }

    public Project(long projId, String name, BigDecimal budget) {
        this.projId = projId;
        this.name = name;
        this.budget = budget;
    }

    @Id
    public long getProjId() {
        return this.projId;
    }

    public void setProjId(long projId) {
        this.projId = projId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getBudget() {
        return this.budget;
    }

    public void setBudget(BigDecimal budget) {
        this.budget = budget;
    }

    @OneToOne(mappedBy="project")
    public Person getProjectLead() {
        return this.projectLead;
    }

    public void setProjectLead(Person projectLead) {
        this.projectLead = projectLead;
    }

    @ManyToMany(cascade={CascadeType.ALL})
    public Collection<Person> getPersons() {
        return this.persons;
    }

    public void setPersons(Collection<Person> persons) {
        this.persons = persons;
    }
}

