/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.relationship.bidironexone;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.relationship.bidironexone.BiDir1X1Person;
import ee.jakarta.tck.persistence.core.relationship.bidironexone.BiDir1X1Project;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "BiDir1X1Person", pkgName + "BiDir1X1Project"};
        return this.createDeploymentJar("jpa_core_relationship_bidironexone.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void biDir1X1Test1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin biDir1X1Test1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            BiDir1X1Project project = new BiDir1X1Project(1L, "JavaEE", 500.0f);
            BiDir1X1Person person = new BiDir1X1Person(1L, "Duke");
            project.setBiDir1X1Person(person);
            person.setProject(project);
            this.getEntityManager().persist((Object)project);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.TRACE, "persisted Project this in turn must persist Person too..");
            this.getEntityTransaction().begin();
            BiDir1X1Person newPerson = (BiDir1X1Person)this.getEntityManager().find(BiDir1X1Person.class, (Object)1L);
            if (newPerson != null) {
                logger.log(System.Logger.Level.TRACE, "Found Searched Person Entity");
                if (this.getEntityManager().contains((Object)newPerson) && newPerson.getName().equals("Duke")) {
                    logger.log(System.Logger.Level.TRACE, "biDir1X1Test1: Expected results received");
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "searched Person not found");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("biDir1X1Test1 failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIR1X1PERSON").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIR1X1PROJECT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

