/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.relationship.bidirmanyxone;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.relationship.bidirmanyxone.BiDirMX1Person;
import ee.jakarta.tck.persistence.core.relationship.bidirmanyxone.BiDirMX1Project;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "BiDirMX1Person", pkgName + "BiDirMX1Project"};
        return this.createDeploymentJar("jpa_core_relationship_bidirmanyxone.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void biDirMX1Test1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin biDirMX1Test1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            BiDirMX1Project project1 = new BiDirMX1Project(1L, "JavaEE", Float.valueOf(500.0f));
            BiDirMX1Person person1 = new BiDirMX1Person(1L, "Duke");
            BiDirMX1Person person2 = new BiDirMX1Person(2L, "Foo");
            this.getEntityManager().persist((Object)project1);
            this.getEntityManager().persist((Object)person1);
            this.getEntityManager().persist((Object)person2);
            logger.log(System.Logger.Level.TRACE, "persisted Persons and Project");
            person1.setProject(project1);
            person2.setProject(project1);
            ArrayList<BiDirMX1Person> list = new ArrayList<BiDirMX1Person>();
            list.add(person1);
            list.add(person2);
            project1.setBiDirMX1Persons(list);
            this.getEntityManager().merge((Object)person1);
            logger.log(System.Logger.Level.TRACE, "merged contents of Person1");
            this.getEntityManager().merge((Object)person2);
            logger.log(System.Logger.Level.TRACE, "merged contents of Person2");
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            boolean pass1 = false;
            boolean pass2 = false;
            this.getEntityTransaction().begin();
            BiDirMX1Project newProject = (BiDirMX1Project)this.getEntityManager().find(BiDirMX1Project.class, (Object)1L);
            if (newProject != null) {
                List<BiDirMX1Person> persons = newProject.getBiDirMX1Persons();
                for (BiDirMX1Person person : persons) {
                    if (person.getName().equals("Duke")) {
                        logger.log(System.Logger.Level.TRACE, "Found Searched Person");
                        pass1 = true;
                        continue;
                    }
                    if (person.getName().equals("Foo")) {
                        logger.log(System.Logger.Level.TRACE, "Found Searched Person");
                        pass2 = true;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "searched Person not Found");
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "searched Project not Found");
            }
            if (pass1 && pass2) {
                logger.log(System.Logger.Level.TRACE, "biDirMX1Test1: Expected results received");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Unexpected results received");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("biDirMX1Test1 failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIRMX1PERSON").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIRMX1PROJECT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

