/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.relationship.bidirmanyxmany;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.relationship.bidirmanyxmany.BiDirMXMPerson;
import ee.jakarta.tck.persistence.core.relationship.bidirmanyxmany.BiDirMXMProject;
import java.util.Collection;
import java.util.Vector;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "BiDirMXMPerson", pkgName + "BiDirMXMProject"};
        return this.createDeploymentJar("jpa_core_relationship_bidirmanyxmany.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void biDirMXMTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin biDirMXMTest1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            BiDirMXMProject project1 = new BiDirMXMProject(1L, "JavaEE", Float.valueOf(500.0f));
            BiDirMXMProject project2 = new BiDirMXMProject(2L, "Identity", Float.valueOf(300.0f));
            BiDirMXMPerson person1 = new BiDirMXMPerson(1L, "Duke");
            BiDirMXMPerson person2 = new BiDirMXMPerson(2L, "Foo");
            this.getEntityManager().persist((Object)project1);
            this.getEntityManager().persist((Object)project2);
            this.getEntityManager().persist((Object)person1);
            this.getEntityManager().persist((Object)person2);
            Vector<BiDirMXMProject> projects = new Vector<BiDirMXMProject>();
            projects.add(project1);
            projects.add(project2);
            person1.setProjects(projects);
            Vector<BiDirMXMProject> projects2 = new Vector<BiDirMXMProject>();
            projects2.add(project2);
            person2.setProjects(projects2);
            this.getEntityManager().merge((Object)person1);
            this.getEntityManager().merge((Object)person2);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.TRACE, "persisted Persons and Project");
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "persisted Persons and Project");
            boolean pass1 = false;
            boolean pass2 = false;
            BiDirMXMPerson newPerson = (BiDirMXMPerson)this.getEntityManager().find(BiDirMXMPerson.class, (Object)1L);
            if (newPerson != null) {
                Collection<BiDirMXMProject> newProjects = newPerson.getProjects();
                for (BiDirMXMProject prj : newProjects) {
                    if (prj.getName().equals("Identity")) {
                        logger.log(System.Logger.Level.TRACE, "Found Searched Project Identity");
                        pass1 = true;
                        continue;
                    }
                    if (!prj.getName().equals("JavaEE")) continue;
                    logger.log(System.Logger.Level.TRACE, "Found Searched Project JavaEE");
                    pass2 = true;
                }
            }
            boolean pass3 = false;
            BiDirMXMPerson newPerson2 = (BiDirMXMPerson)this.getEntityManager().find(BiDirMXMPerson.class, (Object)2L);
            if (newPerson2 != null) {
                Collection<BiDirMXMProject> newProjects2 = newPerson2.getProjects();
                for (BiDirMXMProject prj : newProjects2) {
                    if (!prj.getName().equals("Identity")) continue;
                    logger.log(System.Logger.Level.TRACE, "Found Searched Project for Person id=2");
                    pass3 = true;
                }
            }
            if (pass1 && pass2 && pass3) {
                logger.log(System.Logger.Level.TRACE, "biDirMXMTest1: Expected results received");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Unexpected results received");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("biDirMXMTest1 failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIRMXMPERSON_BIDIRMXMPROJECT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIRMXMPERSON").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIRMXMPROJECT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

