/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.query.language;

import com.sun.ts.lib.harness.SetupMethod;
import ee.jakarta.tck.persistence.common.schema30.UtilPhoneData;
import ee.jakarta.tck.persistence.core.query.language.Client1;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client5
extends UtilPhoneData {
    private static final System.Logger logger = System.getLogger(Client5.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_query_language5.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupPhoneData")
    @Test
    public void queryTest55() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "determine which customers have an area code beginning with 9");
            List c = this.getEntityManager().createQuery("SELECT Distinct Object(c) From Customer c, IN(c.home.phones) p where p.area LIKE :area").setParameter("area", (Object)"9%").getResultList();
            String[] expectedPKs = new String[]{"3", "12", "16"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 3 references, got: " + c.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest55 failed");
        }
    }
}

