/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.basictype;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.basictype.Order;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.Type;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Order"};
        return this.createDeploymentJar("jpa_core_metamodelapi_basictype.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void getJavaType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                Attribute attrib = mTypeOrder.getDeclaredAttribute("id");
                if (attrib != null) {
                    String type = attrib.getJavaType().getName();
                    if (type.equals("int")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected type: int");
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: int, actual:" + type);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getDeclaredAttribute(...) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "managedType(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getJavaType Test failed");
        }
    }

    @Test
    public void getPersistenceType() throws Exception {
        boolean pass = false;
        String expected = Type.PersistenceType.ENTITY.name();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(Order.class);
            if (eType != null) {
                Type.PersistenceType type = eType.getPersistenceType();
                if (type != null) {
                    String sType = type.name();
                    if (sType.equals(expected)) {
                        logger.log(System.Logger.Level.TRACE, "Received:" + sType);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: " + expected + ", actual:" + sType);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getPersistenceType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getPersistenceType failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

