/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.detach.oneXmany;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.detach.oneXmany.A;
import ee.jakarta.tck.persistence.core.entitytest.detach.oneXmany.B;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.PersistenceException;
import jakarta.transaction.TransactionRolledbackException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "B"};
        return this.createDeploymentJar("jpa_core_entitytest_remove_oneXone.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void detach1XMTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin detach1XMTest1");
        boolean pass = false;
        A aRef = new A("1", "a1", 1);
        try {
            this.createA(aRef);
            this.clearCache();
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Persist Instance");
            logger.log(System.Logger.Level.TRACE, "Call contains to determined if the instance is detached");
            if (this.getEntityManager().contains((Object)aRef)) {
                logger.log(System.Logger.Level.TRACE, "entity is not detached, cannot proceed with test.");
                pass = false;
            } else {
                try {
                    logger.log(System.Logger.Level.TRACE, "Status is false as expected, try perist()");
                    this.getEntityManager().persist((Object)aRef);
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "IllegalArgumentException thrown trying to persist a detached entity", (Throwable)iae);
                    pass = true;
                }
                catch (EntityExistsException eee) {
                    logger.log(System.Logger.Level.TRACE, "entityExistsException thrown trying to persist a detached entity", (Throwable)eee);
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "or, Transaction commit will fail.  Test the commit failed by testing the transaction is marked for rollback");
            if (!pass && (e instanceof TransactionRolledbackException || e instanceof PersistenceException)) {
                pass = true;
            }
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("detach1XMTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void detach1XMTest2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin detach1XMTest2");
        boolean pass = false;
        try {
            B b1 = new B("1", "b1", 2);
            B b2 = new B("2", "b2", 2);
            B b3 = new B("3", "b3", 2);
            B b4 = new B("4", "b4", 2);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("2", "bean2", 2, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "Begin Transaction and make sure instance is detached prior to remove");
            this.getEntityTransaction().begin();
            if (!this.getEntityManager().contains((Object)aRef) && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                try {
                    logger.log(System.Logger.Level.TRACE, "aref is detached, Try remove");
                    this.getEntityManager().remove((Object)aRef);
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "IllegalArgumentException thrown trying to remove a detached entity", (Throwable)iae);
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "or, Transaction commit will fail.  Test the commit failed by testing the transaction is marked for rollback");
            if (!pass && (e instanceof TransactionRolledbackException || e instanceof PersistenceException)) {
                pass = true;
            }
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception caught trying to  remove entity instance :" + fe);
            }
        }
        if (!pass) {
            throw new Exception("detach1XMTest2 failed");
        }
    }

    private void createA(A a) {
        logger.log(System.Logger.Level.TRACE, "Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    private void dumpCollectionDataB(Collection c) {
        logger.log(System.Logger.Level.TRACE, "collection Data");
        logger.log(System.Logger.Level.TRACE, "---------------");
        logger.log(System.Logger.Level.TRACE, "- size=" + c.size());
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            B v = (B)i.next();
            logger.log(System.Logger.Level.TRACE, "- Element #" + elem++);
            logger.log(System.Logger.Level.TRACE, "  id=" + v.getBId() + ", name=" + v.getBName() + ", value=" + v.getBValue());
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

