/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityManager2;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entityManager2.Employee;
import ee.jakarta.tck.persistence.core.entityManager2.Order;
import jakarta.persistence.LockModeType;
import jakarta.persistence.TransactionRequiredException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client2
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());
    Employee[] empRef = new Employee[5];
    Order[] orders = new Order[5];
    Properties props = null;
    Map map = new HashMap();
    Employee emp = new Employee(1, "foo", "bar", this.getUtilDate("2000-02-14"), 35000.0f);
    String dataBaseName = null;
    static final String ORACLE = "oracle";

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client2.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DoesNotExist", pkgName + "Employee", pkgName + "Order"};
        return this.createDeploymentJar("jpa_core_entityManager2.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupOrderData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setupOrderData");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createOrderData();
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
            this.dataBaseName = System.getProperty("jdbc.db");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanupData() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            this.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    @Test
    public void lockTransactionRequiredExceptionTest() throws Exception {
        Order o;
        boolean pass1 = false;
        boolean pass2 = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        logger.log(System.Logger.Level.INFO, "Testing TransactionRequiredException for lock(Object, LockModeType)");
        try {
            o = (Order)this.getEntityManager().find(Order.class, (Object)1);
            this.getEntityManager().lock((Object)o, LockModeType.WRITE);
            logger.log(System.Logger.Level.ERROR, "TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException e) {
            logger.log(System.Logger.Level.TRACE, "TransactionRequiredException Caught as Expected.");
            pass1 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Testing TransactionRequiredException for lock(Object, LockModeType, Map)");
        try {
            o = (Order)this.getEntityManager().find(Order.class, (Object)1);
            this.getEntityManager().lock((Object)o, LockModeType.WRITE, myMap);
            logger.log(System.Logger.Level.ERROR, "TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException e) {
            logger.log(System.Logger.Level.TRACE, "TransactionRequiredException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("lockTransactionRequiredExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTransactionRequiredExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "Testing refresh(Object, LockModeType)");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)4);
            this.getEntityTransaction().commit();
            o.setdescription("FOOBAR");
            this.getEntityManager().refresh((Object)o, LockModeType.PESSIMISTIC_READ);
            logger.log(System.Logger.Level.ERROR, "TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            logger.log(System.Logger.Level.TRACE, "TransactionRequiredException Caught as Expected.");
            pass1 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        logger.log(System.Logger.Level.INFO, "Testing refresh(Object, LockModeType, Map)");
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)4);
            this.getEntityTransaction().commit();
            o.setdescription("FOOBAR");
            this.getEntityManager().refresh((Object)o, LockModeType.PESSIMISTIC_READ, myMap);
            logger.log(System.Logger.Level.ERROR, "TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            logger.log(System.Logger.Level.TRACE, "TransactionRequiredException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("refreshTransactionRequiredExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lockTransactionRequiredException2Test() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "Testing lock(Object, LockModeType)");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)4);
            this.getEntityTransaction().commit();
            this.removeTestData();
            this.getEntityManager().lock((Object)o, LockModeType.PESSIMISTIC_READ);
            logger.log(System.Logger.Level.ERROR, "TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            logger.log(System.Logger.Level.TRACE, "TransactionRequiredException Caught as Expected.");
            pass1 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        logger.log(System.Logger.Level.INFO, "Testing lock(Object, LockModeType, Map)");
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)4);
            this.getEntityTransaction().commit();
            this.removeTestData();
            this.getEntityManager().lock((Object)o, LockModeType.PESSIMISTIC_READ, myMap);
            logger.log(System.Logger.Level.ERROR, "TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            logger.log(System.Logger.Level.TRACE, "TransactionRequiredException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("lockTransactionRequiredException2Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrderData() {
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Creating Orders");
            this.orders[0] = new Order(1, 111, "desc1");
            this.orders[1] = new Order(2, 222, "desc2");
            this.orders[2] = new Order(3, 333, "desc3");
            this.orders[3] = new Order(4, 444, "desc4");
            this.orders[4] = new Order(5, 555, "desc5");
            for (Order o : this.orders) {
                logger.log(System.Logger.Level.TRACE, "Persisting order:" + o.toString());
                this.getEntityManager().persist((Object)o);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

