/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.strquery;

import com.sun.ts.lib.harness.SetupMethod;
import ee.jakarta.tck.persistence.common.schema30.Product;
import ee.jakarta.tck.persistence.common.schema30.UtilProductData;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.sql.Date;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client4
extends UtilProductData {
    private static final System.Logger logger = System.getLogger(Client4.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client4.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_strquery4.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void queryTest7() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find All Products");
            CriteriaQuery cquery = cbuilder.createQuery(Product.class);
            Root product = cquery.from(Product.class);
            cquery.where((Expression)cbuilder.lt((Expression)product.get("quantity"), (Number)10));
            cquery.select((Selection)product);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List plist = tquery.getResultList();
            String[] expectedPKs = new String[]{"15", "21"};
            if (!this.checkEntityPK(plist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected " + expectedPKs.length + "references, got: " + plist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest7 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void queryTest38() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find orders that have the quantity of 50 available");
            CriteriaQuery cquery = cbuilder.createQuery(Product.class);
            Root product = cquery.from(Product.class);
            cquery.where((Expression)cbuilder.equal(cbuilder.mod(cbuilder.literal((Object)550), Integer.valueOf(100)), (Expression)product.get("quantity")));
            cquery.select((Selection)product);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List plist = tquery.getResultList();
            String[] expectedPKs = new String[]{"5", "20"};
            if (!this.checkEntityPK(plist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 2 references, got: " + plist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest38 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void queryTest40() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Execute two queries composed differently and verify results Execute Query 1");
            CriteriaQuery cquery1 = cbuilder.createQuery(Product.class);
            Root product1 = cquery1.from(Product.class);
            cquery1.where((Expression)cbuilder.between((Expression)product1.get("quantity"), (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)));
            cquery1.select((Selection)product1);
            TypedQuery tquery1 = this.getEntityManager().createQuery(cquery1);
            List plist1 = tquery1.getResultList();
            String[] expectedPKs = new String[]{"8", "9", "17", "27", "28", "31", "36"};
            logger.log(System.Logger.Level.TRACE, "Execute Query 2");
            CriteriaQuery cquery2 = cbuilder.createQuery(Product.class);
            Root product2 = cquery2.from(Product.class);
            cquery2.where((Expression)cbuilder.and((Expression)cbuilder.ge((Expression)product2.get("quantity"), (Number)10), (Expression)cbuilder.le((Expression)product2.get("quantity"), (Number)20))).select((Selection)product2);
            TypedQuery tquery2 = this.getEntityManager().createQuery(cquery2);
            List plist2 = tquery2.getResultList();
            String[] expectedPKs2 = new String[]{"8", "9", "17", "27", "28", "31", "36"};
            if (!this.checkEntityPK(plist1, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results for first query in queryTest40.   Expected 7 references, got: " + plist1.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received for first query in queryTest40.");
                pass1 = true;
            }
            if (!this.checkEntityPK(plist2, expectedPKs2)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results for second query in queryTest40.   Expected 7 references, got: " + plist2.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received for second query in queryTest40.");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest40 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void queryTest41() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Execute two queries composed differently and verify results Execute first query");
            CriteriaQuery cquery1 = cbuilder.createQuery(Product.class);
            Root product1 = cquery1.from(Product.class);
            cquery1.where((Expression)cbuilder.between((Expression)product1.get("quantity"), (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).not());
            cquery1.select((Selection)product1);
            TypedQuery tquery1 = this.getEntityManager().createQuery(cquery1);
            List plist1 = tquery1.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "10", "11", "12", "13", "14", "15", "16", "18", "19", "20", "21", "22", "23", "24", "25", "26", "29", "30", "32", "33", "34", "35", "37", "38"};
            logger.log(System.Logger.Level.TRACE, "Execute second query");
            CriteriaQuery cquery2 = cbuilder.createQuery(Product.class);
            Root product2 = cquery2.from(Product.class);
            cquery2.where((Expression)cbuilder.or((Expression)cbuilder.lt((Expression)product2.get("quantity"), (Number)10), (Expression)cbuilder.gt((Expression)product2.get("quantity"), (Number)20))).select((Selection)product2);
            TypedQuery tquery2 = this.getEntityManager().createQuery(cquery2);
            List plist2 = tquery2.getResultList();
            String[] expectedPKs2 = new String[]{"1", "2", "3", "4", "5", "6", "7", "10", "11", "12", "13", "14", "15", "16", "18", "19", "20", "21", "22", "23", "24", "25", "26", "29", "30", "32", "33", "34", "35", "37", "38"};
            if (!this.checkEntityPK(plist1, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results for first query.  Expected 31 references, got: " + plist1.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received for first query");
                pass1 = true;
            }
            if (!this.checkEntityPK(plist2, expectedPKs2)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results for second query.  Expected 31 references, got: " + plist2.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received for second query");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest41 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void queryTest43() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Check results of AND operator: False AND False = False");
            CriteriaQuery cquery = cbuilder.createQuery(Product.class);
            Root product = cquery.from(Product.class);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.gt((Expression)product.get("quantity"), cbuilder.sum(cbuilder.literal((Object)500), (Expression)cbuilder.parameter(Integer.class, "int1"))), (Expression)cbuilder.isNull((Expression)product.get("partNumber"))));
            cquery.select((Selection)product);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("int1", (Object)100);
            List plist = tquery.getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(plist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 0 references, got: " + plist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest43 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void queryTest44() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "provide a null value for a comparison operation and verify the results");
            CriteriaQuery cquery = cbuilder.createQuery(Product.class);
            Root product = cquery.from(Product.class);
            cquery.where((Expression)cbuilder.equal((Expression)product.get("name"), (Expression)cbuilder.parameter(String.class, "num1")));
            cquery.select((Selection)product);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("num1", null);
            List plist = tquery.getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(plist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 0 references, got: " + plist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest44 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void queryTest68() throws Exception {
        boolean pass = false;
        Double d1 = 33387.14;
        Double d2 = 33387.15;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            logger.log(System.Logger.Level.TRACE, "find SUM of all product prices");
            CriteriaQuery cquery = cbuilder.createQuery(Double.class);
            Root product = cquery.from(Product.class);
            cquery.select((Selection)cbuilder.sum((Expression)product.get("price")));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            Double d3 = (Double)tquery.getSingleResult();
            if (d3 >= d1 && d3 < d2) {
                logger.log(System.Logger.Level.TRACE, "queryTest68 returned expected results: " + d1);
                pass = true;
            } else {
                logger.log(System.Logger.Level.TRACE, "queryTest68 returned " + d3 + "expected: " + d1);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest68 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void queryTest70() throws Exception {
        boolean pass = false;
        Integer expectedValue = 3277;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            logger.log(System.Logger.Level.TRACE, "find SUM of all product prices");
            CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
            Root product = cquery.from(Product.class);
            cquery.select((Selection)cbuilder.sum((Expression)product.get("quantity")));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            Integer result = (Integer)tquery.getSingleResult();
            if (expectedValue.equals(result)) {
                logger.log(System.Logger.Level.TRACE, "queryTest70 returned expected results: " + result);
                pass = true;
            } else {
                logger.log(System.Logger.Level.TRACE, "queryTest70 returned " + result + "expected: " + expectedValue);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest70 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void test_betweenDates() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            Date date1 = this.getSQLDate(2000, 2, 14);
            Date date6 = this.getSQLDate(2005, 2, 18);
            logger.log(System.Logger.Level.TRACE, "The dates used in test_betweenDates is : " + date1 + " and " + date6);
            CriteriaQuery cquery = cbuilder.createQuery(Product.class);
            Root product = cquery.from(Product.class);
            cquery.where((Expression)cbuilder.between((Expression)product.get("shelfLife").get("soldDate"), (Expression)cbuilder.parameter(Date.class, "date1"), (Expression)cbuilder.parameter(Date.class, "date6")));
            cquery.select((Selection)product);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("date1", (Object)date1);
            tquery.setParameter("date6", (Object)date6);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"31", "32", "33", "37"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 3 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_betweenDates failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void test_notBetweenDates() throws Exception {
        boolean pass = false;
        Date date1 = this.getSQLDate("2000-02-14");
        Date newdate = this.getSQLDate("2005-02-17");
        logger.log(System.Logger.Level.TRACE, "The dates used in test_betweenDates is : " + date1 + " and " + newdate);
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Product.class);
            Root product = cquery.from(Product.class);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.between((Expression)product.get("shelfLife").get("soldDate"), (Expression)cbuilder.parameter(Date.class, "date1"), (Expression)cbuilder.parameter(Date.class, "newdate"))));
            cquery.select((Selection)product);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("date1", (Object)date1);
            tquery.setParameter("newdate", (Object)newdate);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"31"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_notBetweenDates failed");
        }
    }
}

