/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.misc;

import com.sun.ts.lib.harness.SetupMethod;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Customer_;
import ee.jakarta.tck.persistence.common.schema30.UtilCustomerData;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client2
extends UtilCustomerData {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client2.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_misc2.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void predicateGetExpressionsTest() throws Exception {
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            ArrayList<Integer> expected = new ArrayList<Integer>();
            expected.add(Integer.parseInt(this.customerRef[0].getId()));
            expected.add(Integer.parseInt(this.customerRef[1].getId()));
            logger.log(System.Logger.Level.INFO, "Testing disjunction");
            this.getEntityTransaction().begin();
            Predicate expr1 = cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)), (Object)"1");
            Predicate expr2 = cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)), (Object)"2");
            Predicate predicate = cbuilder.or((Expression)expr1, (Expression)expr2);
            List c = predicate.getExpressions();
            if (c.size() != 2) {
                logger.log(System.Logger.Level.ERROR, "Expected a predicate expression size of:2, actual:" + c.size());
            } else {
                pass2 = true;
            }
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.or((Expression)c.get(0), (Expression)c.get(1)));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            for (Customer cust : result) {
                logger.log(System.Logger.Level.TRACE, "result:" + cust);
                actual.add(Integer.parseInt(cust.getId()));
            }
            Collections.sort(actual);
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected results");
                pass3 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results");
                for (Integer i : expected) {
                    logger.log(System.Logger.Level.ERROR, "expected:" + i);
                }
                for (Integer i : actual) {
                    logger.log(System.Logger.Level.ERROR, "actual:" + i);
                }
            }
            actual = new ArrayList();
            expected = new ArrayList();
            expected.add(Integer.parseInt(this.customerRef[0].getId()));
            cquery = null;
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            logger.log(System.Logger.Level.INFO, "Testing conjunction");
            expr1 = cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)), (Object)"1");
            expr2 = cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("name", String.class)), (Object)"Alan E. Frechette");
            predicate = cbuilder.and((Expression)expr1, (Expression)expr2);
            c = predicate.getExpressions();
            if (c.size() != 2) {
                logger.log(System.Logger.Level.ERROR, "Expected a predicate expression size of:2, actual:" + c.size());
            } else {
                pass4 = true;
            }
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.and((Expression)c.get(0), (Expression)c.get(1)));
            tquery = this.getEntityManager().createQuery(cquery);
            result = tquery.getResultList();
            for (Customer cust : result) {
                logger.log(System.Logger.Level.TRACE, "result:" + cust);
                actual.add(Integer.parseInt(cust.getId()));
            }
            Collections.sort(actual);
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected results");
                pass5 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results");
                for (Integer i : expected) {
                    logger.log(System.Logger.Level.ERROR, "expected:" + i);
                }
                for (Integer i : actual) {
                    logger.log(System.Logger.Level.ERROR, "actual:" + i);
                }
            }
            this.getEntityTransaction().commit();
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        if (!(pass2 && pass3 && pass4 && pass5)) {
            throw new Exception("predicateGetExpressionsTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void predicateIsNotNullTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[1].getId(), this.customerRef[2].getId(), this.customerRef[3].getId(), this.customerRef[4].getId(), this.customerRef[5].getId(), this.customerRef[6].getId(), this.customerRef[7].getId(), this.customerRef[8].getId(), this.customerRef[9].getId(), this.customerRef[10].getId(), this.customerRef[12].getId(), this.customerRef[13].getId(), this.customerRef[14].getId(), this.customerRef[15].getId(), this.customerRef[16].getId(), this.customerRef[17].getId(), this.customerRef[18].getId(), this.customerRef[19].getId()};
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            if (customer != null) {
                Predicate pred = customer.get("name").isNotNull();
                cquery.where((Expression)pred);
                cquery.select((Selection)customer);
                TypedQuery tquery = this.getEntityManager().createQuery(cquery);
                List clist = tquery.getResultList();
                if (!this.checkEntityPK(clist, expected)) {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + clist.size());
                } else {
                    logger.log(System.Logger.Level.TRACE, "Expected results received");
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("predicateIsNotNullTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void predicateIsNullTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[11].getId()};
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            if (customer != null) {
                Predicate pred = customer.get("name").isNull();
                cquery.where((Expression)pred);
                cquery.select((Selection)customer);
                TypedQuery tquery = this.getEntityManager().createQuery(cquery);
                List clist = tquery.getResultList();
                if (!this.checkEntityPK(clist, expected)) {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + clist.size());
                } else {
                    logger.log(System.Logger.Level.TRACE, "Expected results received");
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("predicateIsNullTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void pathInObjectArrayTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[1].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            EntityType Customer_2 = customer.getModel();
            Path idPath = customer.get(Customer_2.getSingularAttribute("id", String.class));
            Object[] o = new Object[]{"1", "2"};
            cquery.where((Expression)idPath.in(o));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("pathInObjectArrayTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void pathInExpressionTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            EntityType Customer_2 = customer.getModel();
            Path idPath = customer.get(Customer_2.getSingularAttribute("id", String.class));
            Expression e = cbuilder.literal((Object)"1");
            cquery.where((Expression)idPath.in(e));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("pathInExpressionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void pathInExpressionArrayTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[1].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            EntityType Customer_2 = customer.getModel();
            Path idPath = customer.get(Customer_2.getSingularAttribute("id", String.class));
            Expression[] e = new Expression[]{cbuilder.literal((Object)"1"), cbuilder.literal((Object)"2")};
            cquery.where((Expression)idPath.in(e));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("pathInExpressionArrayTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void pathInCollectionTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[1].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            EntityType Customer_2 = customer.getModel();
            Path idPath = customer.get(Customer_2.getSingularAttribute("id", String.class));
            ArrayList<String> col = new ArrayList<String>();
            col.add("1");
            col.add("2");
            cquery.where((Expression)idPath.in(col));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("pathInCollectionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void pathIsNotNullTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[1].getId(), this.customerRef[2].getId(), this.customerRef[3].getId(), this.customerRef[4].getId(), this.customerRef[5].getId(), this.customerRef[6].getId(), this.customerRef[7].getId(), this.customerRef[8].getId(), this.customerRef[9].getId(), this.customerRef[10].getId(), this.customerRef[12].getId(), this.customerRef[13].getId(), this.customerRef[14].getId(), this.customerRef[15].getId(), this.customerRef[16].getId(), this.customerRef[17].getId(), this.customerRef[18].getId(), this.customerRef[19].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            EntityType Customer_2 = customer.getModel();
            Path idPath = customer.get(Customer_2.getSingularAttribute("name", String.class));
            cquery.where((Expression)idPath.isNotNull());
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("pathIsNotNullTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void pathIsNullTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[11].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            EntityType Customer_2 = customer.getModel();
            Path idPath = customer.get(Customer_2.getSingularAttribute("name", String.class));
            cquery.where((Expression)idPath.isNull());
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("pathIsNullTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void subqueryInObjectArrayTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(String.class);
            Root sqc = sq.from(Customer.class);
            Object[] o = new Object[]{"1"};
            sq.where((Expression)sqc.get(Customer_.id).in(o));
            sq.select((Expression)sqc.get(Customer_.id));
            cquery.where((Expression)customer.get(Customer_.id).in(new Expression[]{sq}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("subqueryInObjectArrayTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void subqueryInExpressionArrayTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(String.class);
            Root sqc = sq.from(Customer.class);
            Expression[] exp = new Expression[]{cbuilder.literal((Object)"1")};
            sq.where((Expression)sqc.get(Customer_.id).in(exp));
            sq.select((Expression)sqc.get(Customer_.id));
            cquery.where((Expression)customer.get(Customer_.id).in(new Expression[]{sq}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("subqueryInExpressionArrayTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void subqueryInExpressionTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(String.class);
            Root sqc = sq.from(Customer.class);
            Expression exp = cbuilder.literal((Object)"1");
            sq.where((Expression)sqc.get(Customer_.id).in(exp));
            sq.select((Expression)sqc.get(Customer_.id));
            cquery.where((Expression)customer.get(Customer_.id).in(new Expression[]{sq}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("subqueryInExpressionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void subqueryInCollectionTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(String.class);
            Root sqc = sq.from(Customer.class);
            ArrayList<String> col = new ArrayList<String>();
            col.add("1");
            sq.where((Expression)sqc.get(Customer_.id).in(col));
            sq.select((Expression)sqc.get(Customer_.id));
            cquery.where((Expression)customer.get(Customer_.id).in(new Expression[]{sq}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("subqueryInCollectionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void subqueryIsNotNull() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            Subquery sq = cquery.subquery(String.class);
            Root sqc = sq.from(Customer.class);
            sq.where((Expression)cbuilder.and((Expression)cbuilder.isNotNull((Expression)sqc.get(Customer_.name)), (Expression)cbuilder.equal((Expression)sqc.get(Customer_.id), (Object)"1")));
            sq.select((Expression)sqc.get(Customer_.id));
            cquery.where((Expression)customer.get(Customer_.id).in(new Expression[]{sq}));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("subqueryIsNotNull test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void subqueryIsNull() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[11].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        if (customer != null) {
            Subquery sq = cquery.subquery(String.class);
            Root sqc = sq.from(Customer.class);
            sq.where((Expression)cbuilder.isNull((Expression)sqc.get(Customer_.name)));
            sq.select((Expression)sqc.get(Customer_.id));
            cquery.where((Expression)customer.get(Customer_.id).in(new Expression[]{sq}));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("subqueryIsNull test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void getGroupRestriction() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery();
            if (cquery != null) {
                Root customer = cquery.from(Customer.class);
                Predicate[] pred = new Predicate[]{qbuilder.like((Expression)customer.get(Customer_.name), "K%")};
                cquery.having(pred);
                Predicate restriction = cquery.getGroupRestriction();
                if (restriction != null) {
                    cquery.groupBy(new Expression[]{customer.get("name")});
                    EntityType Customer_2 = customer.getModel();
                    cquery.select((Selection)customer.get(Customer_2.getSingularAttribute("name", String.class)));
                    List actual = this.getEntityManager().createQuery(cquery).getResultList();
                    ArrayList<String> expected = new ArrayList<String>();
                    expected.add(this.customerRef[5].getName());
                    expected.add(this.customerRef[9].getName());
                    expected.add(this.customerRef[13].getName());
                    if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                        logger.log(System.Logger.Level.TRACE, "Received expected results");
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get expected results");
                        for (String s : expected) {
                            logger.log(System.Logger.Level.ERROR, "expected:" + s);
                        }
                        for (String s : actual) {
                            logger.log(System.Logger.Level.ERROR, "actual:" + s);
                        }
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getGroupRestriction returned null instead of groupBy expressions");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception getGroupRestriction: " + e);
        }
        if (!pass) {
            throw new Exception("getGroupRestriction failed");
        }
    }
}

