/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.metamodelquery;

import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.common.schema30.Alias;
import ee.jakarta.tck.persistence.common.schema30.Alias_;
import ee.jakarta.tck.persistence.common.schema30.UtilAliasOnlyData;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client5
extends UtilAliasOnlyData {
    private static final System.Logger logger = System.getLogger(Client5.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client5.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_metamodelquery5.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupAliasOnlyData")
    @Test
    public void queryTest24() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all aliases who have match: stevie");
            CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.equal((Expression)alias.get(Alias_.alias), cbuilder.concat(cbuilder.literal((Object)"ste"), "vie")));
            cquery.select((Selection)alias);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.aliasRef.length);
            List alist = tquery.getResultList();
            String[] expectedPKs = new String[]{"14"};
            if (!this.checkEntityPK(alist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + alist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest24 failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    @Test
    public void queryTest25() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all aliases containing the substring: iris");
            CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.equal((Expression)alias.get(Alias_.alias), cbuilder.substring((Expression)cbuilder.parameter(String.class, "string1"), (Expression)cbuilder.parameter(Integer.class, "int2"), (Expression)cbuilder.parameter(Integer.class, "int3"))));
            cquery.select((Selection)alias);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("string1", (Object)"iris");
            tquery.setParameter("int2", (Object)1);
            tquery.setParameter("int3", (Object)4);
            tquery.setMaxResults(this.aliasRef.length);
            List alist = tquery.getResultList();
            String[] expectedPKs = new String[]{"20"};
            if (!this.checkEntityPK(alist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + alist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest25 failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    @Test
    public void queryTest26() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find aliases whose alias name is greater than 4 characters");
            CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.gt(cbuilder.length((Expression)alias.get(Alias_.alias)), (Number)4));
            cquery.select((Selection)alias);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.aliasRef.length);
            List alist = tquery.getResultList();
            String[] expectedPKs = new String[]{"8", "10", "13", "14", "18", "28", "29"};
            if (!this.checkEntityPK(alist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 7 references, got: " + alist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest26 failed");
        }
    }

    @SetupMethod(name="setupAliasOnlyData")
    @Test
    public void queryTest28() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all aliases who contain the string: ev in their alias name");
            CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.equal(cbuilder.locate((Expression)alias.get(Alias_.alias), "ev"), (Object)3));
            cquery.select((Selection)alias);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.aliasRef.length);
            List alist = tquery.getResultList();
            String[] expectedPKs = new String[]{"13", "14", "18"};
            if (!this.checkEntityPK(alist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 3 references, got: " + alist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest28 failed");
        }
    }
}

