/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.From;

import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.UtilSetup;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Root;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client1
extends UtilSetup {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_from.jar", pkgNameWithoutSuffix, classes);
    }

    @Test
    public void joinStringIllegalArgumentExceptionTest() throws Exception {
        Root customer;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "String Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            try {
                customer.join("doesnotexist");
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected exception");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "String, JoinType Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            try {
                customer.join("doesnotexist", JoinType.INNER);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected exception");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("joinStringIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void joinCollectionIllegalArgumentExceptionTest() throws Exception {
        Root customer;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "String Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            try {
                customer.joinCollection("doesnotexist");
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected exception");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "String, JoinType Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            try {
                customer.joinCollection("doesnotexist", JoinType.INNER);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected exception");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("joinCollectionIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void joinSetIllegalArgumentExceptionTest() throws Exception {
        Root customer;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "String Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            try {
                customer.joinSet("doesnotexist");
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected exception");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "String, JoinType Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            try {
                customer.joinSet("doesnotexist", JoinType.INNER);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected exception");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("joinSetIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void joinListIllegalArgumentExceptionTest() throws Exception {
        Root root;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "Testing String");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            root = cquery.from(Customer.class);
            try {
                root.joinList("doesnotexist");
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Testing String, JoinType");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            root = cquery.from(Customer.class);
            try {
                root.joinList("doesnotexist", JoinType.INNER);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("joinListIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void joinMapIllegalArgumentExceptionTest() throws Exception {
        Root root;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "Testing String");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            root = cquery.from(Customer.class);
            try {
                root.joinMap("doesnotexist");
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Testing String, JoinType");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            root = cquery.from(Customer.class);
            try {
                root.joinMap("doesnotexist", JoinType.INNER);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("joinMapIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void fromGetCorrelationParentIllegalStateExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            boolean isCorr = customer.isCorrelated();
            if (!isCorr) {
                logger.log(System.Logger.Level.TRACE, "isCorrelated() return false");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected isCorrelated() to return false, actual:" + isCorr);
            }
            try {
                customer.getCorrelationParent();
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalStateException");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalStateException");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("fromGetCorrelationParentIllegalStateExceptionTest failed");
        }
    }
}

