/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaQuery;

import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Order;
import ee.jakarta.tck.persistence.common.schema30.UtilSetup;
import ee.jakarta.tck.persistence.core.criteriaapi.CriteriaQuery.A;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.EntityType;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client4
extends UtilSetup {
    private static final System.Logger logger = System.getLogger(Client4.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client4.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A"};
        classes = Client4.concat((String[])this.getSchema30classes(), (String[])classes);
        return this.createDeploymentJar("jpa_core_criteriaapi_CriteriaQuery4.jar", pkgNameWithoutSuffix, classes);
    }

    @Test
    public void fromGetStringIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(A.class);
            try {
                cquery.from(A.class).get("value").get("value2");
                logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalStateException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: ", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("fromGetStringIllegalStateExceptionTest failed");
        }
    }

    @Test
    public void pathGetStringIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(A.class);
            Path path = cquery.from(A.class).get("value");
            try {
                path.get("value2");
                logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalStateException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: ", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("pathGetStringIllegalStateExceptionTest failed");
        }
    }

    @Test
    public void fromGetStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(A.class);
            try {
                cquery.from(A.class).get("doesnotexist");
                logger.log(System.Logger.Level.ERROR, "IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException ise) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: ", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("fromGetStringIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void fromGetModelTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        String expected = "ee.jakarta.tck.persistence.common.schema30.Customer";
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            EntityType bind = cquery.from(Customer.class).getModel();
            String name = bind.getBindableJavaType().getName();
            if (name.equals(expected)) {
                logger.log(System.Logger.Level.TRACE, "Received expected name:" + name);
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:" + expected + ", actual:" + name);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("fromGetModelTest failed");
        }
    }

    @Test
    public void pathGetIllegalArgumentException() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            customer.get("doesnotexist");
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("pathGetIllegalArgumentException failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void executeUpdateIllegalStateException1Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
            CriteriaQuery cquery = cb.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cb.equal((Expression)order.get("id"), (Object)"1"));
            this.getEntityManager().createQuery(cquery).executeUpdate();
            logger.log(System.Logger.Level.ERROR, "IllegalStateException was not thrown");
        }
        catch (IllegalStateException ise) {
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("executeUpdateIllegalStateException1Test failed");
        }
    }
}

