/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaQuery;

import com.sun.ts.lib.harness.SetupMethod;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.UtilAliasData;
import jakarta.persistence.criteria.CompoundSelection;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client2
extends UtilAliasData {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client2.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A"};
        classes = Client2.concat((String[])this.getSchema30classes(), (String[])classes);
        return this.createDeploymentJar("jpa_core_criteriaapi_CriteriaQuery2.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupAliasData")
    @Test
    public void selectIllegalArgumentException() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery();
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            logger.log(System.Logger.Level.TRACE, "Creating select using selection items with the same alias");
            try {
                CompoundSelection c = cbuilder.array(new Selection[]{customer.get("id").alias("SAMEALIAS"), customer.get("name").alias("SAMEALIAS")});
                cquery.select((Selection)c);
                logger.log(System.Logger.Level.ERROR, "Did not thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("selectIllegalArgumentException failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    @Test
    public void multiselectIllegalArgumentExceptionTest() throws Exception {
        Root customer;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        logger.log(System.Logger.Level.INFO, "Testing multiselect invalid item");
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            customer = cquery.from(Customer.class);
            logger.log(System.Logger.Level.TRACE, "Creating multiselect using selection array of items that do not exist");
            try {
                cquery.multiselect(new Selection[]{customer.get("doesnotexist").alias("ALIAS1"), customer.get("doesnotexist2").alias("ALIAS2")});
                logger.log(System.Logger.Level.ERROR, "Did not thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
        }
        logger.log(System.Logger.Level.INFO, "Testing multiselect selection[]");
        cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            customer = cquery.from(Customer.class);
            logger.log(System.Logger.Level.TRACE, "Creating multiselect using selection array of items with the same alias");
            Selection[] selection = new Selection[]{customer.get("id").alias("SAMEALIAS"), customer.get("name").alias("SAMEALIAS")};
            try {
                cquery.multiselect(selection);
                logger.log(System.Logger.Level.ERROR, "Did not thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
        }
        logger.log(System.Logger.Level.INFO, "Testing multiselect List");
        cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            customer = cquery.from(Customer.class);
            logger.log(System.Logger.Level.TRACE, "Creating multiselect using selection items with the same alias");
            try {
                ArrayList<Selection> list = new ArrayList<Selection>();
                list.add(customer.get("id").alias("SAMEALIAS"));
                list.add(customer.get("name").alias("SAMEALIAS"));
                cquery.multiselect(list);
                logger.log(System.Logger.Level.ERROR, "Did not thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "received expected IllegalArgumentException");
                pass3 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("multiselectIllegalArgumentExceptionTest failed");
        }
    }
}

