/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.callback.inheritance;

import ee.jakarta.tck.persistence.core.callback.common.EntityCallbackClientBase;
import ee.jakarta.tck.persistence.core.callback.inheritance.PricedPartProduct;
import ee.jakarta.tck.persistence.core.callback.inheritance.PricedPartProduct_2;
import ee.jakarta.tck.persistence.core.callback.inheritance.Product;
import jakarta.persistence.Query;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends EntityCallbackClientBase {
    private PricedPartProduct p1;
    private PricedPartProduct_2 p2;
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "PartProduct", pkgName + "PartProductListener", pkgName + "PricedPartProduct_2", pkgName + "PricedPartProduct", pkgName + "PricedPartProductCallback", pkgName + "PricedPartProductListener", pkgName + "Product", pkgName + "ProductListener"};
        return this.createDeploymentJar("jpa_core_callback_inheritance.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    private PricedPartProduct_2 newPricedPartProduct_2(String testName) {
        PricedPartProduct_2 product = new PricedPartProduct_2();
        product.setTestName(testName);
        product.setId(testName);
        product.setName(testName);
        product.setPartNumber(1L);
        product.setPrice(1.0);
        product.setQuantity(1);
        return product;
    }

    private PricedPartProduct newPricedPartProduct(String testName) {
        PricedPartProduct product = new PricedPartProduct();
        product.setTestName(testName);
        product.setId(testName);
        product.setName(testName);
        product.setPartNumber(1L);
        product.setPrice(1.0);
        product.setQuantity(1);
        return product;
    }

    @Test
    public void prePersistTest() throws Exception {
        String testName = "prePersistTest";
        try {
            this.getEntityTransaction().begin();
            this.p1 = this.newPricedPartProduct("prePersistTest");
            this.getEntityManager().persist((Object)this.p1);
            if (!this.p1.isPrePersistCalled()) {
                String reason = "PricedPartProduct: prePersist was not called.";
                throw new Exception(reason);
            }
            String reason = "PricedPartProduct: prePersist was called.";
            logger.log(System.Logger.Level.TRACE, reason);
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught during prePersistTest", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Test
    public void prePersistTest2() throws Exception {
        String testName = "prePersistTest2";
        try {
            this.getEntityTransaction().begin();
            this.p2 = this.newPricedPartProduct_2("prePersistTest2");
            this.getEntityManager().persist((Object)this.p2);
            if (!this.p2.isPrePersistCalled()) {
                String reason = "PricedPartProduct_2: prePersist was not called.";
                throw new Exception(reason);
            }
            String reason = "PricedPartProduct_2: prePersist was called.";
            logger.log(System.Logger.Level.TRACE, reason);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught during prePersistTest", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Test
    public void preRemoveTest() throws Exception {
        String testName = "preRemoveTest";
        try {
            this.getEntityTransaction().begin();
            this.p1 = this.newPricedPartProduct("preRemoveTest");
            this.getEntityManager().persist((Object)this.p1);
            this.getEntityManager().remove((Object)this.p1);
            if (!this.p1.isPreRemoveCalled()) {
                String reason = "PricedPartProduct: preRemove was not called.";
                throw new Exception(reason);
            }
            String reason = "PricedPartProduct: preRemove was called.";
            logger.log(System.Logger.Level.TRACE, reason);
            this.p1 = null;
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught during prePersistTest", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Test
    public void preRemoveTest2() throws Exception {
        String testName = "preRemoveTest2";
        try {
            this.getEntityTransaction().begin();
            this.p2 = this.newPricedPartProduct_2("preRemoveTest2");
            this.getEntityManager().persist((Object)this.p2);
            this.getEntityManager().remove((Object)this.p2);
            if (!this.p2.isPreRemoveCalled()) {
                String reason = "PricedPartProduct: preRemove was not called.";
                throw new Exception(reason);
            }
            String reason = "PricedPartProduct: preRemove was called.";
            logger.log(System.Logger.Level.TRACE, reason);
            this.p2 = null;
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught during prePersistTest", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Test
    public void preUpdateTest() throws Exception {
        String testName = "preUpdateTest";
        try {
            this.getEntityTransaction().begin();
            this.p1 = this.newPricedPartProduct("preUpdateTest");
            this.getEntityManager().persist((Object)this.p1);
            this.getEntityManager().flush();
            this.p1.setPrice(2.0);
            this.getEntityManager().persist((Object)this.p1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught during preUpdateTest", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Test
    public void preUpdateTest2() throws Exception {
        String testName = "preUpdateTest2";
        try {
            this.getEntityTransaction().begin();
            this.p2 = this.newPricedPartProduct_2("preUpdateTest2");
            this.getEntityManager().persist((Object)this.p2);
            this.getEntityManager().flush();
            this.p2.setPrice(2.0);
            this.getEntityManager().persist((Object)this.p2);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught during preUpdateTest2", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Test
    public void postLoadTest() throws Exception {
        String testName = "postLoadTest";
        try {
            this.getEntityTransaction().begin();
            this.p1 = this.newPricedPartProduct("postLoadTest");
            this.getEntityManager().persist((Object)this.p1);
            this.getEntityManager().flush();
            this.getEntityManager().refresh((Object)this.p1);
            Query q = this.getEntityManager().createQuery("select distinct p from PricedPartProduct p");
            List results = q.getResultList();
            logger.log(System.Logger.Level.TRACE, results.toString());
            if (!this.p1.isPostLoadCalled()) {
                String reason = "PricedPartProduct: postLoad was not called even after the query result was returned.";
                throw new Exception(reason);
            }
            String reason = "PricedPartProduct: postLoad was called after the query result was returned.";
            logger.log(System.Logger.Level.TRACE, reason);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught during postLoadTest", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Test
    public void postLoadTest2() throws Exception {
        String testName = "postLoadTest2";
        try {
            this.getEntityTransaction().begin();
            this.p2 = this.newPricedPartProduct_2("postLoadTest2");
            this.getEntityManager().persist((Object)this.p2);
            this.getEntityManager().flush();
            this.getEntityManager().refresh((Object)this.p2);
            Query q = this.getEntityManager().createQuery("select p.id from PricedPartProduct_2 p");
            List results = q.getResultList();
            logger.log(System.Logger.Level.TRACE, results.toString());
            if (!this.p2.isPostLoadCalled()) {
                String reason = "PricedPartProduct_2: postLoad was not called even after the query result was returned.";
                throw new Exception(reason);
            }
            String reason = "PricedPartProduct_2: postLoad was called after the query result was returned.";
            logger.log(System.Logger.Level.TRACE, reason);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught during postLoadTest", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Test
    public void findProductTest() throws Exception {
        String testName = "findProductTest";
        try {
            this.getEntityTransaction().begin();
            this.p1 = this.newPricedPartProduct("findProductTest");
            this.getEntityManager().persist((Object)this.p1);
            this.getEntityManager().flush();
            Object o = this.getEntityManager().find(Product.class, (Object)"findProductTest");
            logger.log(System.Logger.Level.TRACE, "finding object using Product.class and id 'findProductTest'");
            if (o instanceof PricedPartProduct) {
                logger.log(System.Logger.Level.TRACE, "Found object of type " + PricedPartProduct.class);
            } else if (o instanceof Product) {
                logger.log(System.Logger.Level.TRACE, "Found object of type " + Product.class);
            } else {
                logger.log(System.Logger.Level.TRACE, "The object found is neither " + PricedPartProduct.class + ", nor " + Product.class);
            }
            Object oo = this.getEntityManager().find(PricedPartProduct.class, (Object)"findProductTest");
            logger.log(System.Logger.Level.TRACE, "finding object using PricedPartProduct.class and id 'findProductTest'");
            if (oo instanceof PricedPartProduct) {
                logger.log(System.Logger.Level.TRACE, "Found object of type " + PricedPartProduct.class);
            } else if (oo instanceof Product) {
                logger.log(System.Logger.Level.TRACE, "Found object of type " + Product.class);
            } else {
                logger.log(System.Logger.Level.TRACE, "The object found is neither " + PricedPartProduct.class + ", nor " + Product.class);
            }
            if (o == oo) {
                logger.log(System.Logger.Level.TRACE, "The two entities are identical");
            } else if (o.equals(oo)) {
                logger.log(System.Logger.Level.TRACE, "The two entities are equal");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught during findProductTest", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PRICED_PRODUCT_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

