/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.cache.basicTests;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.cache.basicTests.Order;
import jakarta.persistence.Cache;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Order"};
        String[] xmlFiles = new String[]{};
        return this.createDeploymentJar("jpa_core_cache_basicTests.jar", pkgNameWithoutSuffix, classes, "persistence_se.xml", xmlFiles);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void getcacheTest() throws Exception {
        boolean pass = false;
        int count = 5;
        if (this.cachingSupported) {
            try {
                EntityManager em2 = this.getEntityManager();
                EntityTransaction et = this.getEntityTransaction();
                Order[] orders = new Order[5];
                et.begin();
                for (int i = 1; i < 5; ++i) {
                    orders[i] = new Order(i, 100 * i);
                    em2.persist((Object)orders[i]);
                    logger.log(System.Logger.Level.TRACE, "persisted order " + orders[i]);
                }
                em2.flush();
                EntityManagerFactory emf = this.getEntityManagerFactory();
                Cache cache = emf.getCache();
                if (cache != null) {
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Cache returned was null");
                }
                for (int i = 1; i < 5; ++i) {
                    em2.remove((Object)orders[i]);
                    logger.log(System.Logger.Level.TRACE, "Removed order " + orders[i]);
                }
                et.commit();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            }
        } else {
            logger.log(System.Logger.Level.INFO, "Cache not supported, bypassing test");
            pass = true;
        }
        if (!pass) {
            throw new Exception("getcacheTest failed");
        }
    }

    @Test
    public void evictTest1() throws Exception {
        boolean pass2;
        boolean pass1;
        block10: {
            int count = 5;
            pass1 = false;
            pass2 = false;
            if (this.cachingSupported) {
                try {
                    this.getEntityTransaction().begin();
                    logger.log(System.Logger.Level.TRACE, "Transaction status after begin:" + this.getEntityTransaction().isActive());
                    Order[] orders = new Order[5];
                    for (int i = 1; i < 5; ++i) {
                        orders[i] = new Order(i, 100 * i);
                        this.getEntityManager().persist((Object)orders[i]);
                        logger.log(System.Logger.Level.TRACE, "persisted order " + orders[i]);
                    }
                    this.getEntityManager().flush();
                    this.getEntityTransaction().commit();
                    logger.log(System.Logger.Level.TRACE, "Transaction status after commit:" + this.getEntityTransaction().isActive());
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        pass1 = true;
                        logger.log(System.Logger.Level.TRACE, "cache was successfully obtained");
                        boolean cacheContains = cache.contains(Order.class, (Object)1);
                        if (cacheContains) {
                            logger.log(System.Logger.Level.TRACE, "Order 1 found, evicting it from cache");
                            cache.evict(Order.class, (Object)1);
                            cacheContains = cache.contains(Order.class, (Object)1);
                            if (!cacheContains) {
                                pass2 = true;
                                logger.log(System.Logger.Level.TRACE, "Order 1 was successfully evicted");
                            }
                        } else {
                            logger.log(System.Logger.Level.ERROR, "cache did not contain Order 1");
                        }
                        break block10;
                    }
                    logger.log(System.Logger.Level.ERROR, "Cache returned was null, eventhough Cache is supported.");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.INFO, "Cache not supported, bypassing test");
                pass1 = true;
                pass2 = true;
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("evictTest1 failed");
        }
    }

    @Test
    public void evictTest2() throws Exception {
        boolean pass1;
        boolean pass2;
        block10: {
            int count = 5;
            pass2 = false;
            pass1 = false;
            if (this.cachingSupported) {
                try {
                    Order[] orders = new Order[5];
                    this.getEntityTransaction().begin();
                    for (int i = 1; i < 5; ++i) {
                        orders[i] = new Order(i, 100 * i);
                        this.getEntityManager().persist((Object)orders[i]);
                        logger.log(System.Logger.Level.TRACE, "persisted order " + orders[i]);
                    }
                    this.getEntityManager().flush();
                    this.getEntityTransaction().commit();
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        pass1 = true;
                        logger.log(System.Logger.Level.TRACE, "cache was successfully obtained");
                        boolean cacheContains = cache.contains(Order.class, (Object)1);
                        if (cacheContains) {
                            logger.log(System.Logger.Level.TRACE, "evicting Order 1 from cache");
                            cache.evict(Order.class);
                            cacheContains = cache.contains(Order.class, (Object)1);
                            if (!cacheContains) {
                                pass2 = true;
                                logger.log(System.Logger.Level.TRACE, "Order 1 was successfully evicted");
                            }
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Cache did not contain Order 1");
                        }
                        break block10;
                    }
                    logger.log(System.Logger.Level.ERROR, "Cache returned was null, eventhough Cache is supported.");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.INFO, "Cache not supported, bypassing test");
                pass1 = true;
                pass2 = true;
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("evictTest2 failed");
        }
    }

    @Test
    public void evictallTest() throws Exception {
        boolean pass2;
        boolean pass1;
        block10: {
            int count = 5;
            pass1 = false;
            pass2 = false;
            int pass2Count = 0;
            Order[] orders = new Order[5];
            int[] ids = new int[5];
            if (this.cachingSupported) {
                try {
                    this.getEntityTransaction().begin();
                    for (int i = 1; i < 5; ++i) {
                        orders[i] = new Order(i, 100 * i);
                        ids[i] = orders[i].getId();
                        this.getEntityManager().persist((Object)orders[i]);
                        logger.log(System.Logger.Level.TRACE, "persisted order " + orders[i]);
                    }
                    this.getEntityManager().flush();
                    this.getEntityTransaction().commit();
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        pass1 = true;
                        logger.log(System.Logger.Level.TRACE, "cache was successfully obtained, evicting all Orders from cache");
                        cache.evictAll();
                        for (int i : ids) {
                            logger.log(System.Logger.Level.TRACE, "Testing order:" + i);
                            boolean cacheContains = cache.contains(Order.class, (Object)i);
                            if (cacheContains) continue;
                            ++pass2Count;
                            logger.log(System.Logger.Level.TRACE, "Order:" + i + " was successfully evicted");
                        }
                        if (pass2Count == orders.length) {
                            pass2 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Not all orders were evicted.");
                        }
                        break block10;
                    }
                    logger.log(System.Logger.Level.ERROR, "Cache returned was null, eventhough Cache is supported.");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.INFO, "Cache not supported, bypassing test");
                pass1 = true;
                pass2 = true;
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("evictallTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

