/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.tableGenerator;

import ee.jakarta.tck.persistence.core.annotations.tableGenerator.Client;
import ee.jakarta.tck.persistence.core.annotations.tableGenerator.DataTypes4;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client4
extends Client {
    private DataTypes4 d4;
    private static final System.Logger logger = System.getLogger(Client4.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = Client.class.getPackageName() + ".";
        String[] classes = new String[]{pkgName + "DataTypes", pkgName + "DataTypes2", pkgName + "DataTypes3", pkgName + "DataTypes4"};
        return this.createDeploymentJar("jpa_core_annotations_tableGenerator4.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup4() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup4");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData4();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void generatorGlobalTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            int id = this.d4.getId();
            logger.log(System.Logger.Level.TRACE, "find id: " + id);
            DataTypes4 d = (DataTypes4)this.getEntityManager().find(DataTypes4.class, (Object)id);
            if (d != null) {
                if (d.getStringData().equals(this.d4.getStringData())) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("generatorGlobalTest failed");
        }
    }

    public void createTestData4() {
        try {
            this.getEntityTransaction().begin();
            this.d4 = new DataTypes4();
            this.d4.setStringData("testData4");
            logger.log(System.Logger.Level.TRACE, "DataType4:" + this.d4.toString());
            this.getEntityManager().persist((Object)this.d4);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
    }
}

