/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.mapsid;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.mapsid.DID1bDependent;
import ee.jakarta.tck.persistence.core.annotations.mapsid.DID1bDependentId;
import ee.jakarta.tck.persistence.core.annotations.mapsid.DID1bEmployee;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DID1bDependent", pkgName + "DID1bDependentId", pkgName + "DID1bEmployee"};
        return this.createDeploymentJar("jpa_core_annotations_mapsid.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void persistMX1Test1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persistMX1Test1");
        boolean pass = false;
        EntityManager em = null;
        EntityTransaction et = null;
        em = this.getEntityManager();
        et = this.getEntityTransaction();
        et.begin();
        try {
            DID1bEmployee employee1 = new DID1bEmployee(1L, "Duke");
            DID1bEmployee employee2 = new DID1bEmployee(2L, "foo");
            DID1bDependent dep1 = new DID1bDependent(new DID1bDependentId("Obama", 1L), employee1);
            DID1bDependent dep2 = new DID1bDependent(new DID1bDependentId("Michelle", 1L), employee1);
            DID1bDependent dep3 = new DID1bDependent(new DID1bDependentId("John", 2L), employee2);
            em.persist((Object)dep1);
            em.persist((Object)dep2);
            em.persist((Object)dep3);
            em.persist((Object)employee1);
            em.persist((Object)employee2);
            logger.log(System.Logger.Level.TRACE, "persisted Employees and Dependents");
            em.flush();
            DID1bDependent newDependent = (DID1bDependent)em.find(DID1bDependent.class, (Object)new DID1bDependentId("Obama", 1L));
            if (newDependent != null) {
                em.refresh((Object)newDependent);
            }
            List depList = em.createQuery("Select d from DID1bDependent d where d.id.name='Obama' and d.emp.name='Duke'").getResultList();
            newDependent = null;
            if (depList.size() > 0) {
                newDependent = (DID1bDependent)depList.get(0);
            }
            if (newDependent == dep1) {
                pass = true;
                logger.log(System.Logger.Level.TRACE, "Received Expected Dependent");
            } else {
                logger.log(System.Logger.Level.TRACE, "searched Dependent not found");
            }
            et.commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            et.rollback();
        }
        if (!pass) {
            throw new Exception("persistMX1Test1 failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from DID1BDEPENDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DID1BEMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

