/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.discriminatorValue;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.discriminatorValue.PartProduct;
import ee.jakarta.tck.persistence.core.annotations.discriminatorValue.PricedPartProduct2;
import ee.jakarta.tck.persistence.core.annotations.discriminatorValue.Product;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "PartProduct", pkgName + "PartProduct2", pkgName + "PricedPartProduct2", pkgName + "Product", pkgName + "Product2"};
        return this.createDeploymentJar("jpa_core_annotations_discrinimatorValue.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    private PricedPartProduct2 newPricedPartProduct(String testName) {
        PricedPartProduct2 product = new PricedPartProduct2();
        product.setId(testName);
        product.setName(testName);
        product.setPartNumber(1L);
        product.setPrice(1.0);
        product.setQuantity(1);
        return product;
    }

    private PartProduct newPartProduct(String testName) {
        PartProduct product = new PartProduct();
        product.setId(testName);
        product.setName(testName);
        product.setPartNumber(1L);
        product.setQuantity(1);
        return product;
    }

    private Product newProduct(String testName) {
        Product product = new Product();
        product.setId(testName);
        product.setName(testName);
        product.setQuantity(1);
        return product;
    }

    @Test
    public void integerDiscriminatorValueTest() throws Exception {
        boolean pass = false;
        String testName = "integerDiscriminatorValueTest";
        try {
            this.getEntityTransaction().begin();
            PricedPartProduct2 p1 = this.newPricedPartProduct("integerDiscriminatorValueTest");
            this.getEntityManager().persist((Object)p1);
            this.getEntityManager().flush();
            this.clearCache();
            PricedPartProduct2 p2 = (PricedPartProduct2)this.getEntityManager().find(PricedPartProduct2.class, (Object)"integerDiscriminatorValueTest");
            logger.log(System.Logger.Level.TRACE, "finding PricedPartProduct2 with id 'integerDiscriminatorValueTest'");
            if (p1.equals(p2)) {
                logger.log(System.Logger.Level.TRACE, "Received expected PricedPartProduct2:" + p2);
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected result.");
                logger.log(System.Logger.Level.ERROR, "Expected:" + p1);
                logger.log(System.Logger.Level.ERROR, "Actual:" + p2);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("integerDiscriminatorValueTest Failed");
        }
    }

    @Test
    public void discriminatorValueTest() throws Exception {
        boolean pass1 = false;
        String testName = "discriminatorValueTest";
        try {
            this.getEntityTransaction().begin();
            PartProduct p1 = this.newPartProduct("discriminatorValueTest");
            this.getEntityManager().persist((Object)p1);
            this.getEntityManager().flush();
            this.clearCache();
            PartProduct p2 = (PartProduct)this.getEntityManager().find(PartProduct.class, (Object)"discriminatorValueTest");
            logger.log(System.Logger.Level.TRACE, "finding PartProduct with id 'discriminatorValueTest'");
            if (p1.equals(p2)) {
                logger.log(System.Logger.Level.TRACE, "Received expected PartProduct:" + p2);
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected result.");
                logger.log(System.Logger.Level.ERROR, "Expected:" + p1);
                logger.log(System.Logger.Level.ERROR, "Actual:" + p2);
            }
            Product p3 = this.newProduct("discriminatorValueTest");
            this.getEntityManager().persist((Object)p3);
            this.getEntityManager().flush();
            this.clearCache();
            Product p4 = (Product)this.getEntityManager().find(Product.class, (Object)"discriminatorValueTest");
            logger.log(System.Logger.Level.TRACE, "finding Product with id 'discriminatorValueTest'");
            if (p3.equals(p4)) {
                logger.log(System.Logger.Level.TRACE, "Received expected Product:" + p2);
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected result.");
                logger.log(System.Logger.Level.ERROR, "Expected:" + p3);
                logger.log(System.Logger.Level.ERROR, "Actual:" + p4);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1) {
            throw new Exception("discriminatorValueTest Failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE_DISCRIMINATOR").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

