/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import com.sun.javatest.ResourceLoader;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18NResourceBundle
extends ResourceBundle {
    private static final String logClassPrefix = System.getProperty("javatest.i18n.log");
    private String name;
    private ResourceBundle delegate;
    private boolean logging;
    private ClassLoader classLoader;

    private I18NResourceBundle(String name, boolean logging, ClassLoader cl) {
        this.name = name;
        this.logging = logging;
        this.classLoader = cl;
    }

    public static I18NResourceBundle getBundleForClass(Class<?> c) {
        String cn = c.getName();
        int dot = cn.lastIndexOf(46);
        String rn = dot == -1 ? "i18n" : cn.substring(0, dot) + ".i18n";
        boolean logging = logClassPrefix == null ? false : cn.startsWith(logClassPrefix);
        return new I18NResourceBundle(rn, logging, c.getClassLoader());
    }

    public String getString(String key, Object arg) {
        return this.getString(key, new Object[]{arg});
    }

    public String getString(String key, Object ... args) {
        try {
            return MessageFormat.format(this.getString(key), args);
        }
        catch (MissingResourceException e) {
            System.err.println("WARNING: missing resource: " + key + " for " + this.name);
            StringBuilder sb = new StringBuilder(key);
            for (Object arg : args) {
                sb.append('\n');
                sb.append(arg.toString());
            }
            return sb.toString();
        }
    }

    public String getOptionalString(String key) {
        try {
            String s = (String)this.getObj(key);
            if (s != null && this.logging) {
                System.out.println("i18n: " + key);
            }
            return s;
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private Object getObj(String key) {
        try {
            if (this.delegate == null) {
                this.delegate = AccessController.doPrivileged(() -> ResourceLoader.getBundle(this.name, Locale.getDefault(), this.classLoader));
            }
            return this.delegate.getObject(key);
        }
        catch (MissingResourceException e) {
            ResourceBundle bundle = AccessController.doPrivileged(() -> ResourceBundle.getBundle(this.name, Locale.getDefault(), this.classLoader));
            return bundle.getObject(key);
        }
    }

    @Override
    protected Object handleGetObject(String key) {
        try {
            if (this.logging) {
                System.out.println("i18n: " + key);
            }
            return this.getObj(key);
        }
        catch (MissingResourceException e) {
            System.err.println("WARNING: missing resource: " + key + " for " + this.name);
            return key;
        }
    }

    @Override
    public Enumeration<String> getKeys() {
        if (this.delegate == null) {
            this.delegate = AccessController.doPrivileged(() -> ResourceLoader.getBundle(this.name, Locale.getDefault(), this.classLoader));
        }
        if (this.delegate.getKeys().hasMoreElements()) {
            return this.delegate.getKeys();
        }
        ResourceBundle bundle = AccessController.doPrivileged(() -> ResourceBundle.getBundle(this.name, Locale.getDefault(), this.classLoader));
        return bundle.getKeys();
    }

    public String getName() {
        return this.name;
    }
}

