/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import com.sun.ant.taskdefs.common.Make2Ant;
import java.io.File;
import java.io.FileFilter;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ArchiveInfo {
    public static final String SUN_EJB_JAR_XML = ".sun-ejb-jar.xml";
    public static final String SUN_WEB_XML = ".sun-web.xml";
    public static final String SUN_APPLICATION_XML = ".sun-application.xml";
    public static final String SUN_APPLICATION_CLIENT_XML = ".sun-application-client.xml";
    public static final String SUN_CONNECTOR_XML = ".sun-connector.xml";
    public static FileFilter convertedXmlFilter = new FileFilter(){

        public boolean accept(File pathname) {
            long justNow;
            if (!pathname.isFile()) {
                return false;
            }
            String fname = pathname.getName();
            if (!fname.endsWith(".xml")) {
                return false;
            }
            if (fname.startsWith(",")) {
                return false;
            }
            if (fname.equals("build.xml")) {
                return false;
            }
            if (fname.indexOf("build.xml") != -1) {
                return false;
            }
            if (fname.indexOf(".props.xml") != -1) {
                return false;
            }
            long t = pathname.lastModified();
            return t >= (justNow = System.currentTimeMillis() - 180000L);
        }
    };
    public static FileFilter xmlDescriptorFilter = new FileFilter(){

        public boolean accept(File pathname) {
            if (!pathname.isFile()) {
                return false;
            }
            String fname = pathname.getName();
            if (!fname.endsWith(".xml")) {
                return false;
            }
            if (fname.startsWith(",")) {
                return false;
            }
            if (fname.equals("build.xml")) {
                return false;
            }
            return fname.indexOf("build.xml") == -1;
        }
    };
    public static FileFilter earFilter = new FileFilter(){

        public boolean accept(File pathname) {
            if (!pathname.isFile()) {
                return false;
            }
            String fname = pathname.getName();
            return fname.endsWith(".ear");
        }
    };
    public static FileFilter classFilter = new FileFilter(){

        public boolean accept(File pathname) {
            if (!pathname.isFile()) {
                return false;
            }
            String fname = pathname.getName();
            return fname.endsWith(".class");
        }
    };
    public static FileFilter otherMakeFileFilter = new FileFilter(){

        public boolean accept(File pathname) {
            if (!pathname.isFile()) {
                return false;
            }
            String fname = pathname.getName();
            if (fname.equals("Makefile")) {
                return false;
            }
            return fname.startsWith("Makefile.");
        }
    };
    public static FileFilter dirFilter = new FileFilter(){

        public boolean accept(File pathname) {
            if (!pathname.isDirectory()) {
                return false;
            }
            String fname = pathname.getName();
            return !fname.equals("SCCS");
        }
    };
    public static FileFilter runtimeFileFilter = new FileFilter(){

        public boolean accept(File pathname) {
            if (!pathname.isFile()) {
                return false;
            }
            String fname = pathname.getName();
            if (fname.startsWith(",")) {
                return false;
            }
            return fname.endsWith(".runtime.xml");
        }
    };
    public static FileFilter s1asRuntimeFileFilter = new FileFilter(){

        public boolean accept(File pathname) {
            if (!pathname.isFile()) {
                return false;
            }
            String fname = pathname.getName();
            if (fname.endsWith(".xml") && (fname.indexOf(".sun-") != -1 || fname.startsWith("sun-"))) {
                return true;
            }
            return fname.endsWith("dbschema");
        }
    };
    public static FileFilter jarWarFilter = new FileFilter(){

        public boolean accept(File pathname) {
            if (!pathname.isFile()) {
                return false;
            }
            String fname = pathname.getName();
            return fname.endsWith(".jar") || fname.endsWith(".war");
        }
    };
    public static FileFilter warFilter = new FileFilter(){

        public boolean accept(File pathname) {
            if (!pathname.isFile()) {
                return false;
            }
            String fname = pathname.getName();
            return fname.endsWith(".war");
        }
    };
    public static FileFilter rarJarWarEarFilter = new FileFilter(){

        public boolean accept(File pathname) {
            if (!pathname.isFile()) {
                return false;
            }
            String fname = pathname.getName();
            return fname.endsWith(".ear") || fname.endsWith(".jar") || fname.endsWith(".war") || fname.endsWith(".rar");
        }
    };
    public static FileFilter uselessFileFilter = new FileFilter(){

        public boolean accept(File pathname) {
            if (!pathname.isFile()) {
                return false;
            }
            String fname = pathname.getName();
            return fname.endsWith(".props.xml");
        }
    };
    public static FileFilter vehicleXmlFilter = new FileFilter(){

        public boolean accept(File pathname) {
            if (!pathname.isFile()) {
                return false;
            }
            String fname = pathname.getName();
            int i = fname.indexOf("_vehicle_");
            return fname.endsWith(".xml") && i != -1;
        }
    };
    public static FileFilter clientJavaFilter = new FileFilter(){

        public boolean accept(File pathname) {
            if (!pathname.isFile()) {
                return false;
            }
            String fname = pathname.getName();
            if (fname.startsWith(",")) {
                return false;
            }
            return fname.endsWith(".java") && (fname.indexOf("Client") != -1 || fname.indexOf("client") != -1);
        }
    };
    public static FileFilter propsFileFilter = new FileFilter(){

        public boolean accept(File pathname) {
            if (!pathname.isFile()) {
                return false;
            }
            String fname = pathname.getName();
            return fname.endsWith(".props") || fname.endsWith(".cprops") || fname.endsWith(".webprops");
        }
    };

    public static void main(String[] args) throws Exception {
        ArchiveInfo arch = new ArchiveInfo();
        ArchiveInfo.jarWarInEar(new File(args[0]));
    }

    public static Properties getAttrs(String archiveName, Properties tokenVal, File leafDir) {
        String clientJar = "clientjar";
        String ejbJar = "ejb-jar";
        String webWar = "webwar";
        String resRar = "resrar";
        Properties attrs = new Properties();
        attrs.setProperty("mainClassElement", "");
        int i = archiveName.indexOf("_client.jar");
        if (i != -1) {
            String appName = archiveName.substring(0, i);
            attrs.setProperty("taskName", "clientjar");
            attrs.setProperty("descriptor", appName + "_client.xml");
            attrs.setProperty("name", appName);
            String mainClass = tokenVal.getProperty("mainClass");
            if (mainClass == null) {
                File[] clientJava = leafDir.listFiles(clientJavaFilter);
                if (clientJava != null) {
                    String temp = clientJava[0].getName();
                    temp = temp.substring(0, temp.indexOf(".java"));
                    String pkgDir = tokenVal.getProperty("pkgDir");
                    if (pkgDir != null) {
                        mainClass = pkgDir.replace('/', '.') + "." + temp;
                        tokenVal.setProperty("mainClass", mainClass);
                    } else {
                        mainClass = "@mainClass@";
                    }
                } else {
                    mainClass = "@mainClass@";
                }
            }
            String mainClassElement = Make2Ant.NL + "        " + "mainclass=\"" + mainClass + "\"";
            attrs.setProperty("mainClassElement", mainClassElement);
            return attrs;
        }
        i = archiveName.indexOf("_ejb.jar");
        if (i != -1) {
            String appName = archiveName.substring(0, i);
            attrs.setProperty("taskName", "ejb-jar");
            attrs.setProperty("descriptor", appName + "_ejb.xml");
            attrs.setProperty("name", appName);
            return attrs;
        }
        i = archiveName.indexOf("_web.war");
        if (i != -1) {
            String appName = archiveName.substring(0, i);
            attrs.setProperty("taskName", "webwar");
            attrs.setProperty("descriptor", appName + "_web.xml");
            attrs.setProperty("name", appName);
            return attrs;
        }
        i = archiveName.indexOf(".war");
        if (i != -1) {
            String appName = archiveName.substring(0, i);
            attrs.setProperty("taskName", "webwar");
            attrs.setProperty("descriptor", appName + ".xml");
            attrs.setProperty("name", appName);
            return attrs;
        }
        return attrs;
    }

    public static Properties getAttrs(File archive, Properties tokenVal, File leafDir) {
        if (archive == null) {
            return null;
        }
        return ArchiveInfo.getAttrs(archive.getName(), tokenVal, leafDir);
    }

    public static String cleanName(String name) {
        int j;
        String result = null;
        int i = name.indexOf("/com/");
        result = i != -1 ? name.substring(i + 1) : ((j = name.indexOf("/classes/")) != -1 ? name.substring(j + "/classes/".length()) : name);
        return result;
    }

    static boolean isIncluded(List inlist, String className) {
        String s = className.replace('/', '.');
        if (inlist.contains(s)) {
            return true;
        }
        int pos = s.indexOf("$");
        if (pos == -1) {
            return false;
        }
        String baseClass = s.substring(0, pos) + ".class";
        return inlist.contains(baseClass);
    }

    public static String jarWarInEar(File file) {
        String result = "";
        try {
            JarFile ear = new JarFile(file);
            Enumeration<JarEntry> enu = ear.entries();
            while (enu.hasMoreElements()) {
                ZipEntry infile = enu.nextElement();
                if (infile.isDirectory()) continue;
                String name = infile.getName();
                if (name.endsWith(".jar")) {
                    result = result + name + ", ";
                    continue;
                }
                if (name.endsWith(".war")) {
                    result = result + name + ", ";
                    continue;
                }
                if (!name.endsWith(".rar")) continue;
                result = result + name + ", ";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (result.endsWith(", ")) {
            result = result.substring(0, result.length() - 2);
            return result;
        }
        System.out.println("WARNING: No jar, war, or rar in ear file:" + file.getPath());
        return null;
    }
}

