/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.services;

import com.sun.javatest.services.Connector;
import com.sun.javatest.services.Message;
import com.sun.javatest.services.MessageHandler;
import com.sun.javatest.services.ServiceExecutor;
import java.io.InputStream;

public class LocalConnector
implements Connector {
    private ServiceExecutor executor;

    public LocalConnector(ServiceExecutor executor) {
        this.executor = executor;
    }

    public void setExecutor(ServiceExecutor executor) {
        this.executor = executor;
    }

    public ServiceExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public Message send(Message msg) {
        switch (msg.getType()) {
            case START: {
                return this.startExecutor(msg);
            }
            case STOP: {
                return this.stopExecutor(msg);
            }
            case IS_ALIVE: {
                return this.isAlive(msg);
            }
        }
        return null;
    }

    @Override
    public InputStream getServiceErrorStream() {
        return this.executor.getServiceErrorStream();
    }

    @Override
    public InputStream getServiceOutputStream() {
        return this.executor.getServiceOutputStream();
    }

    @Override
    public void esteblishConnection() {
    }

    @Override
    public void refuseConnection() {
    }

    @Override
    public boolean connected() {
        return this.executor != null;
    }

    @Override
    public void setMessageHandler(MessageHandler handler) {
    }

    private Message startExecutor(Message income) {
        return this.executor.startService(income);
    }

    private Message stopExecutor(Message income) {
        return this.executor.stopService(income);
    }

    private Message isAlive(Message income) {
        return this.executor.isAlive(income);
    }
}

