/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.defaultmapping.classes;

import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerAccessorsWithoutMatchingField;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerFinalField;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerFinalPublicField;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerNoAccessorsPackagePrivateField;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerNoAccessorsPrivateField;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerNoAccessorsProtectedField;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerNoAccessorsPublicField;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerPackagePrivateAccessors;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerPackagePrivateConstructor;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerPrivateAccessors;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerPrivateAccessorsPublicField;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerPrivateConstructor;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerProtectedAccessors;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerProtectedConstructor;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerProtectedStaticNestedClass;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerPublicAccessors;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerPublicAccessorsPublicField;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerPublicConstructor;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerPublicStaticNestedClass;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerStaticField;
import ee.jakarta.tck.json.bind.defaultmapping.classes.model.StringContainerTransientField;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbException;
import java.lang.reflect.Field;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClassesMappingTest {
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testPublicConstructorAccess() {
        String jsonString = (String)Assertions.assertDoesNotThrow(() -> this.jsonb.toJson((Object)new StringContainerPublicConstructor()), (String)"An exception is not expected when marshalling a class with a public constructor.");
        MatcherAssert.assertThat((String)"Failed to get attribute value when marshalling a class with a public constructor.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}"));
        Assertions.assertDoesNotThrow(() -> (StringContainerPublicConstructor)this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", StringContainerPublicConstructor.class), (String)"An exception is not expected when unmarshalling a class with a public constructor.");
    }

    @Test
    public void testProtectedConstructorAccess() {
        String jsonString = (String)Assertions.assertDoesNotThrow(() -> this.jsonb.toJson((Object)StringContainerProtectedConstructor.getClassInstance()), (String)"An exception is not expected when marshalling a class with a protected constructor.");
        MatcherAssert.assertThat((String)"Failed to get attribute value when marshalling a class with a protected constructor.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}"));
        Assertions.assertDoesNotThrow(() -> (StringContainerProtectedConstructor)this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", StringContainerProtectedConstructor.class), (String)"An exception is not expected when unmarshalling a class with a protected constructor.");
    }

    @Test
    public void testPrivateConstructorAccess() {
        String jsonString = (String)Assertions.assertDoesNotThrow(() -> this.jsonb.toJson((Object)StringContainerPrivateConstructor.getClassInstance()), (String)"An exception is not expected when marshalling a class with a private constructor.");
        MatcherAssert.assertThat((String)"Failed to get attribute value when marshalling a class with a private constructor.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}"));
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", StringContainerPrivateConstructor.class), (String)"An exception is expected when unmarshalling a class with a private constructor.");
    }

    @Test
    public void testPackagePrivateConstructorAccess() {
        String jsonString = (String)Assertions.assertDoesNotThrow(() -> this.jsonb.toJson((Object)StringContainerPackagePrivateConstructor.getClassInstance()), (String)"An exception is not expected when marshalling a class with a package private constructor.");
        MatcherAssert.assertThat((String)"Failed to get attribute value when marshalling a class with a package private constructor.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}"));
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", StringContainerPackagePrivateConstructor.class), (String)"An exception is expected when unmarshalling a class with a package private constructor.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPublicAccessors() {
        String jsonString = this.jsonb.toJson((Object)new StringContainerPublicAccessors());
        MatcherAssert.assertThat((String)"Failed to get attribute value using public getter.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}"));
        try {
            StringContainerPublicAccessors unmarshalledObject = (StringContainerPublicAccessors)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerPublicAccessors.class);
            Field instanceField = StringContainerPublicAccessors.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                MatcherAssert.assertThat((String)"Failed to set attribute value using public setter.", (Object)instanceField.get(unmarshalledObject), (Matcher)Matchers.is((Object)"New Test String"));
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage(), (Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProtectedAccessors() {
        String jsonString = this.jsonb.toJson((Object)new StringContainerProtectedAccessors());
        MatcherAssert.assertThat((String)"Failed to ignore attribute value using protected getter.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
        try {
            StringContainerProtectedAccessors unmarshalledObject = (StringContainerProtectedAccessors)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerProtectedAccessors.class);
            Field instanceField = StringContainerProtectedAccessors.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                MatcherAssert.assertThat((String)"Failed to ignore setting attribute value using protected setter.", (Object)instanceField.get(unmarshalledObject), (Matcher)Matchers.is((Object)"Test String"));
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage(), (Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrivateAccessors() {
        String jsonString = this.jsonb.toJson((Object)new StringContainerPrivateAccessors());
        MatcherAssert.assertThat((String)"Failed to ignore private value using private getter.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
        try {
            StringContainerPrivateAccessors unmarshalledObject = (StringContainerPrivateAccessors)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerPrivateAccessors.class);
            Field instanceField = StringContainerPrivateAccessors.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                MatcherAssert.assertThat((String)"Failed to ignore setting attribute value using private setter.", (Object)instanceField.get(unmarshalledObject), (Matcher)Matchers.is((Object)"Test String"));
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage(), (Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPackagePrivateAccessors() {
        String jsonString = this.jsonb.toJson((Object)new StringContainerPackagePrivateAccessors());
        MatcherAssert.assertThat((String)"Failed to ignore private value using package private getter.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
        try {
            StringContainerPackagePrivateAccessors unmarshalledObject = (StringContainerPackagePrivateAccessors)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerPackagePrivateAccessors.class);
            Field instanceField = StringContainerPackagePrivateAccessors.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                MatcherAssert.assertThat((String)"Failed to ignore setting attribute value using package private setter.", (Object)instanceField.get(unmarshalledObject), (Matcher)Matchers.is((Object)"Test String"));
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage(), (Throwable)x);
        }
    }

    @Test
    public void testPublicAccessorsPublicField() {
        String jsonString = this.jsonb.toJson((Object)new StringContainerPublicAccessorsPublicField());
        MatcherAssert.assertThat((String)"Failed to get attribute value using public getter.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"Getter String\"\\s*\\}"));
        StringContainerPublicAccessorsPublicField unmarshalledObject = (StringContainerPublicAccessorsPublicField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerPublicAccessorsPublicField.class);
        MatcherAssert.assertThat((String)"Failed to set attribute value using public setter.", (Object)unmarshalledObject.instance, (Matcher)Matchers.is((Object)"Setter String"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrivateAccessorsPublicField() {
        String jsonString = this.jsonb.toJson((Object)new StringContainerPrivateAccessorsPublicField());
        MatcherAssert.assertThat((String)"Failed to ignore public value using private getter.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
        try {
            StringContainerPrivateAccessorsPublicField unmarshalledObject = (StringContainerPrivateAccessorsPublicField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerPrivateAccessorsPublicField.class);
            Field instanceField = StringContainerPrivateAccessorsPublicField.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                MatcherAssert.assertThat((String)"Failed to ignore setting public value using private setter.", (Object)instanceField.get(unmarshalledObject), (Matcher)Matchers.is((Object)"Test String"));
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage(), (Throwable)x);
        }
    }

    @Test
    public void testNoAccessorsPublicField() {
        String jsonString = this.jsonb.toJson((Object)new StringContainerNoAccessorsPublicField());
        MatcherAssert.assertThat((String)"Failed to get public field value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}"));
        StringContainerNoAccessorsPublicField unmarshalledObject = (StringContainerNoAccessorsPublicField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerNoAccessorsPublicField.class);
        MatcherAssert.assertThat((String)"Failed to set public field value.", (Object)unmarshalledObject.instance, (Matcher)Matchers.is((Object)"New Test String"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoAccessorsProtectedField() {
        String jsonString = this.jsonb.toJson((Object)new StringContainerNoAccessorsProtectedField());
        MatcherAssert.assertThat((String)"Failed to ignore getting protected field value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
        try {
            StringContainerNoAccessorsProtectedField unmarshalledObject = (StringContainerNoAccessorsProtectedField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerNoAccessorsProtectedField.class);
            Field instanceField = StringContainerNoAccessorsProtectedField.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                MatcherAssert.assertThat((String)"Failed to ignore setting public value using private setter.", (Object)instanceField.get(unmarshalledObject), (Matcher)Matchers.is((Object)"Test String"));
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage(), (Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoAccessorsPrivateField() {
        String jsonString = this.jsonb.toJson((Object)new StringContainerNoAccessorsPrivateField());
        MatcherAssert.assertThat((String)"Failed to ignore getting private field value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
        try {
            StringContainerNoAccessorsPrivateField unmarshalledObject = (StringContainerNoAccessorsPrivateField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerNoAccessorsPrivateField.class);
            Field instanceField = StringContainerNoAccessorsPrivateField.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                MatcherAssert.assertThat((String)"Failed to ignore setting private field value.", (Object)instanceField.get(unmarshalledObject), (Matcher)Matchers.is((Object)"Test String"));
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage(), (Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoAccessorsPackagePrivateField() {
        String jsonString = this.jsonb.toJson((Object)new StringContainerNoAccessorsPackagePrivateField());
        MatcherAssert.assertThat((String)"Failed to ignore getting package private field value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
        try {
            StringContainerNoAccessorsPackagePrivateField unmarshalledObject = (StringContainerNoAccessorsPackagePrivateField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerNoAccessorsPackagePrivateField.class);
            Field instanceField = StringContainerNoAccessorsPackagePrivateField.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                MatcherAssert.assertThat((String)"Failed to ignore setting package private field value.", (Object)instanceField.get(unmarshalledObject), (Matcher)Matchers.is((Object)"Test String"));
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage(), (Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransientField() {
        String jsonString = this.jsonb.toJson((Object)new StringContainerTransientField());
        MatcherAssert.assertThat((String)"Failed to ignore getting transient field value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
        try {
            StringContainerTransientField unmarshalledObject = (StringContainerTransientField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerTransientField.class);
            Field instanceField = StringContainerTransientField.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                MatcherAssert.assertThat((String)"Failed to ignore setting transient field value.", (Object)instanceField.get(unmarshalledObject), (Matcher)Matchers.is((Object)"Test String"));
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage(), (Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStaticField() {
        String jsonString = this.jsonb.toJson((Object)new StringContainerStaticField());
        MatcherAssert.assertThat((String)"Failed to ignore getting static field value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
        try {
            StringContainerStaticField unmarshalledObject = (StringContainerStaticField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerStaticField.class);
            Field instanceField = StringContainerStaticField.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                MatcherAssert.assertThat((String)"Failed to ignore setting static field value.", (Object)instanceField.get(unmarshalledObject), (Matcher)Matchers.is((Object)"Test String"));
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage(), (Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalField() {
        String jsonString = this.jsonb.toJson((Object)new StringContainerFinalField());
        MatcherAssert.assertThat((String)"Failed to get final field value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}"));
        try {
            StringContainerFinalField unmarshalledObject = (StringContainerFinalField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerFinalField.class);
            Field instanceField = StringContainerFinalField.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                MatcherAssert.assertThat((String)"Failed to ignore setting final field value.", (Object)instanceField.get(unmarshalledObject), (Matcher)Matchers.is((Object)"Test String"));
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage(), (Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalPublicField() {
        String jsonString = this.jsonb.toJson((Object)new StringContainerFinalPublicField());
        MatcherAssert.assertThat((String)"Failed to get final public field value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}"));
        try {
            StringContainerFinalPublicField unmarshalledObject = (StringContainerFinalPublicField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerFinalPublicField.class);
            Field instanceField = StringContainerFinalPublicField.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                MatcherAssert.assertThat((String)"Failed to ignore setting final public field value.", (Object)instanceField.get(unmarshalledObject), (Matcher)Matchers.is((Object)"Test String"));
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage(), (Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessorsWithoutCorrespondingField() {
        String jsonString = this.jsonb.toJson((Object)new StringContainerAccessorsWithoutMatchingField());
        MatcherAssert.assertThat((String)"Failed to get value from getter without corresponding field.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}"));
        try {
            StringContainerAccessorsWithoutMatchingField unmarshalledObject = (StringContainerAccessorsWithoutMatchingField)this.jsonb.fromJson("{ \"instance\" : \"New Test String\" }", StringContainerAccessorsWithoutMatchingField.class);
            Field instanceField = StringContainerAccessorsWithoutMatchingField.class.getDeclaredField("field");
            instanceField.setAccessible(true);
            try {
                MatcherAssert.assertThat((String)"Failed to set value using setter without corresponding field.", (Object)instanceField.get(unmarshalledObject), (Matcher)Matchers.is((Object)"New Test String"));
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage(), (Throwable)x);
        }
    }

    @Test
    public void testDeserialisationOfNonExistentField() {
        try {
            StringContainerPublicAccessors unmarshalledObject = (StringContainerPublicAccessors)this.jsonb.fromJson("{ \"field\" : \"New Test String\" }", StringContainerPublicAccessors.class);
            Field instanceField = StringContainerPublicAccessors.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                MatcherAssert.assertThat((String)"Failed to ignore setting value to non existent field.", (Object)instanceField.get(unmarshalledObject), (Matcher)Matchers.is((Object)"Test String"));
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage(), (Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPublicStaticNestedClass() {
        String jsonString = this.jsonb.toJson((Object)new StringContainerPublicStaticNestedClass());
        MatcherAssert.assertThat((String)"Failed to get attribute value from public nested class.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"nestedClass\"\\s*:\\s*\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}\\s*\\}"));
        try {
            String toDeserialize = "{ \"nestedClass\" : { \"instance\" : \"New Test String\" } }";
            StringContainerPublicStaticNestedClass unmarshalledObject = (StringContainerPublicStaticNestedClass)this.jsonb.fromJson(toDeserialize, StringContainerPublicStaticNestedClass.class);
            Field instanceField = StringContainerPublicStaticNestedClass.NestedClass.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                MatcherAssert.assertThat((String)"Failed to set attribute value to public nested class.", (Object)instanceField.get(unmarshalledObject.nestedClass), (Matcher)Matchers.is((Object)"New Test String"));
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage(), (Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProtectedStaticNestedClass() {
        String jsonString = this.jsonb.toJson((Object)new StringContainerProtectedStaticNestedClass());
        MatcherAssert.assertThat((String)"Failed to get attribute value from protected nested class.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"nestedClass\"\\s*:\\s*\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*\\}\\s*\\}"));
        try {
            String toDeserialize = "{ \"nestedClass\" : { \"instance\" : \"New Test String\" } }";
            StringContainerProtectedStaticNestedClass unmarshalledObject = (StringContainerProtectedStaticNestedClass)this.jsonb.fromJson(toDeserialize, StringContainerProtectedStaticNestedClass.class);
            Class<?> nestedClass = StringContainerProtectedStaticNestedClass.class.getDeclaredClasses()[0];
            Field instanceField = nestedClass.getDeclaredField("instance");
            instanceField.setAccessible(true);
            try {
                MatcherAssert.assertThat((String)"Failed to set attribute value to protected nested class.", (Object)instanceField.get(unmarshalledObject.nestedClass), (Matcher)Matchers.is((Object)"New Test String"));
            }
            finally {
                instanceField.setAccessible(false);
            }
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage(), (Throwable)x);
        }
    }

    @Test
    public void testAnonymousClass() {
        Object anonymousInstance = new Object(){
            public String newInstance = "Anonymous";
        };
        String jsonString = this.jsonb.toJson(anonymousInstance);
        MatcherAssert.assertThat((String)"Failed to get attribute value from anonymous class.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"newInstance\"\\s*:\\s*\"Anonymous\"\\s*\\}"));
    }
}

