/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.customizedmapping.numberformat;

import ee.jakarta.tck.json.bind.customizedmapping.numberformat.model.AccessorCustomizedDoubleContainer;
import ee.jakarta.tck.json.bind.customizedmapping.numberformat.model.FieldCustomizedDoubleContainer;
import ee.jakarta.tck.json.bind.customizedmapping.numberformat.model.TypeCustomizedDoubleContainer;
import ee.jakarta.tck.json.bind.customizedmapping.numberformat.model.TypeCustomizedFieldOverriddenDoubleContainer;
import ee.jakarta.tck.json.bind.customizedmapping.numberformat.model.customized.PackageCustomizedDoubleContainer;
import ee.jakarta.tck.json.bind.customizedmapping.numberformat.model.customized.PackageCustomizedTypeOverriddenDoubleContainer;
import ee.jakarta.tck.json.bind.customizedmapping.numberformat.model.customized.PackageCustomizedTypeOverriddenFieldOverriddenDoubleContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class NumberFormatCustomizationTest {
    private static final String FRENCH_NUMBER = "\"123\\u00a0456,789\"";
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testNumberFormatPackage() {
        String jsonString = this.jsonb.toJson((Object)new PackageCustomizedDoubleContainer(){
            {
                this.setInstance(123456.789);
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly customize number format during marshalling using JsonbNumberFormat annotation on package.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"123.456,8\"\\s*\\}"));
        PackageCustomizedDoubleContainer unmarshalledObject = (PackageCustomizedDoubleContainer)this.jsonb.fromJson("{ \"instance\" : \"123.456,789\" }", PackageCustomizedDoubleContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly customize number format during unmarshalling using JsonbNumberFormat annotation on package.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)123456.789));
    }

    @Test
    public void testNumberFormatType() {
        String jsonString = this.jsonb.toJson((Object)new TypeCustomizedDoubleContainer(){
            {
                this.setInstance(123456.789);
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly customize number format during marshalling using JsonbNumberFormat annotation on type.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"123,456.79\"\\s*\\}"));
        TypeCustomizedDoubleContainer unmarshalledObject = (TypeCustomizedDoubleContainer)this.jsonb.fromJson("{ \"instance\" : \"123,456.789\" }", TypeCustomizedDoubleContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly customize number format during unmarshalling using JsonbNumberFormat annotation on type.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)123456.789));
    }

    @Test
    public void testNumberFormatField() {
        String jsonString = this.jsonb.toJson((Object)new FieldCustomizedDoubleContainer(){
            {
                this.setInstance(123456.789);
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly customize number format during marshalling using JsonbNumberFormat annotation on field.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"123\\u00a0456,789\"\\s*\\}"));
        FieldCustomizedDoubleContainer unmarshalledObject = (FieldCustomizedDoubleContainer)this.jsonb.fromJson("{ \"instance\" : \"123\\u00a0456,789\" }", FieldCustomizedDoubleContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly customize number format during unmarshalling using JsonbNumberFormat annotation on field.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)123456.789));
    }

    @Test
    public void testNumberFormatAccessors() {
        String jsonString = this.jsonb.toJson((Object)new AccessorCustomizedDoubleContainer(){
            {
                this.setInstance(123456.789);
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly customize number format during marshalling using JsonbNumberFormat annotation on getter.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"123,456.79\"\\s*\\}"));
        AccessorCustomizedDoubleContainer unmarshalledObject = (AccessorCustomizedDoubleContainer)this.jsonb.fromJson("{ \"instance\" : \"123\\u00a0456,789\" }", AccessorCustomizedDoubleContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly customize number format during unmarshalling using JsonbNumberFormat annotation on setter.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)123456.789));
    }

    @Test
    public void testNumberFormatPackageTypeOverride() {
        String jsonString = this.jsonb.toJson((Object)new PackageCustomizedTypeOverriddenDoubleContainer(){
            {
                this.setInstance(123456.789);
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly override number format customization using JsonbNumberFormat annotation on package during marshalling using JsonbNumberFormat annotation on type.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"123,456.79\"\\s*\\}"));
        PackageCustomizedTypeOverriddenDoubleContainer unmarshalledObject = (PackageCustomizedTypeOverriddenDoubleContainer)this.jsonb.fromJson("{ \"instance\" : \"123,456.789\" }", PackageCustomizedTypeOverriddenDoubleContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly override number format customization using JsonbNumberFormat annotation on package during unmarshalling using JsonbNumberFormat annotation on type.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)123456.789));
    }

    @Test
    public void testNumberFormatTypeFieldOverride() {
        String jsonString = this.jsonb.toJson((Object)new TypeCustomizedFieldOverriddenDoubleContainer(){
            {
                this.setInstance(123456.789);
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly customize number format during marshalling using JsonbNumberFormat annotation on type.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"123,456.8\"\\s*\\}"));
        TypeCustomizedFieldOverriddenDoubleContainer unmarshalledObject = (TypeCustomizedFieldOverriddenDoubleContainer)this.jsonb.fromJson("{ \"instance\" : \"123,456.789\" }", TypeCustomizedFieldOverriddenDoubleContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly customize number format during unmarshalling using JsonbNumberFormat annotation on type.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)123456.789));
    }

    @Test
    public void testNumberFormatPackageTypeOverrideFieldOverride() {
        String jsonString = this.jsonb.toJson((Object)new PackageCustomizedTypeOverriddenFieldOverriddenDoubleContainer(){
            {
                this.setInstance(123456.789);
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly override number format customization using JsonbNumberFormat annotation on package during marshalling using JsonbNumberFormat annotation on type.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"123.456,789\"\\s*\\}"));
        PackageCustomizedTypeOverriddenFieldOverriddenDoubleContainer unmarshalledObject = (PackageCustomizedTypeOverriddenFieldOverriddenDoubleContainer)this.jsonb.fromJson("{ \"instance\" : \"123.456,789\" }", PackageCustomizedTypeOverriddenFieldOverriddenDoubleContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly override number format customization using JsonbNumberFormat annotation on package during unmarshalling using JsonbNumberFormat annotation on type.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)123456.789));
    }
}

