/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.cdi.customizedmapping.serializers.model.serializer;

import ee.jakarta.tck.json.bind.customizedmapping.serializers.model.Animal;
import ee.jakarta.tck.json.bind.customizedmapping.serializers.model.serializer.AnimalBuilder;
import jakarta.inject.Inject;
import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Type;

public class AnimalDeserializerInjected
implements JsonbDeserializer<Animal> {
    @Inject
    private AnimalBuilder animalBuilder;

    public Animal deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Type type) {
        while (jsonParser.hasNext()) {
            JsonParser.Event event = jsonParser.next();
            if (event == JsonParser.Event.START_OBJECT) continue;
            if (event == JsonParser.Event.END_OBJECT) break;
            if (event != JsonParser.Event.KEY_NAME) continue;
            block9 : switch (jsonParser.getString()) {
                case "type": {
                    jsonParser.next();
                    switch (jsonParser.getString()) {
                        case "cat": {
                            this.animalBuilder.setType(AnimalBuilder.TYPE.CAT);
                            break block9;
                        }
                        case "dog": {
                            this.animalBuilder.setType(AnimalBuilder.TYPE.DOG);
                            break block9;
                        }
                    }
                    this.animalBuilder.setType(AnimalBuilder.TYPE.GENERIC);
                    break;
                }
                case "name": {
                    jsonParser.next();
                    this.animalBuilder.setName(jsonParser.getString());
                    break;
                }
                case "age": {
                    jsonParser.next();
                    this.animalBuilder.setAge(jsonParser.getInt());
                    break;
                }
                case "furry": {
                    event = jsonParser.next();
                    this.animalBuilder.setFurry(event == JsonParser.Event.VALUE_TRUE);
                    break;
                }
                case "weight": {
                    jsonParser.next();
                    this.animalBuilder.setWeight(jsonParser.getBigDecimal().floatValue());
                    break;
                }
                case "cuddly": {
                    event = jsonParser.next();
                    this.animalBuilder.setCuddly(event == JsonParser.Event.VALUE_TRUE);
                    break;
                }
                case "barking": {
                    event = jsonParser.next();
                    this.animalBuilder.setBarking(event == JsonParser.Event.VALUE_TRUE);
                }
            }
        }
        return this.animalBuilder.build();
    }
}

