/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind;

import ee.jakarta.tck.json.bind.TypeContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;

public class MappingTester<T> {
    private static final String JSON_PATTERN_PREFIX = "\\{\\s*";
    private static final String JSON_PATTERN_PROPERTY = "\"instance\"\\s*:\\s*";
    private static final String JSON_PATTERN_SUFFIX = "\\s*\\}";
    private static final String JSON_PREFIX = "{ ";
    private static final String JSON_PROPERTY = "\"instance\" : ";
    private static final String JSON_SUFFIX = " }";
    private static final int MAX_BIT_SIZE = 53;
    private static final int MIN_RANGE = -1022;
    private static final int MAX_RANGE = 1023;
    private final Jsonb jsonb = JsonbBuilder.create();
    private final Class<? extends TypeContainer<T>> typeContainerClass;
    private final boolean nillable;
    private T testValue;
    private BiPredicate<T, T> testUnmarshall = Object::equals;
    private String fixedRegExp = null;

    public MappingTester(Class<? extends TypeContainer<T>> typeContainerClass) {
        this(typeContainerClass, true);
    }

    public MappingTester(Class<? extends TypeContainer<T>> typeContainerClass, boolean nillable) {
        this.typeContainerClass = typeContainerClass;
        this.nillable = nillable;
    }

    public void test(T value, String expectedRepresentation) {
        try {
            this.testValue = value;
            this.testMarshalling(value, expectedRepresentation);
            this.testMarshallingToStream(value, expectedRepresentation);
            this.testMarshallingToWriter(value, expectedRepresentation);
            this.testMarshallingByType(value, expectedRepresentation);
            this.testMarshallingByTypeToStream(value, expectedRepresentation);
            this.testMarshallingByTypeToWriter(value, expectedRepresentation);
            this.testUnmarshallingByClass(value, expectedRepresentation);
            this.testUnmarshallingByClassFromStream(value, expectedRepresentation);
            this.testUnmarshallingByClassFromReader(value, expectedRepresentation);
            this.testUnmarshallingByType(value, expectedRepresentation);
            this.testUnmarshallingByTypeFromStream(value, expectedRepresentation);
            this.testUnmarshallingByTypeFromReader(value, expectedRepresentation);
        }
        catch (IllegalAccessException | InstantiationException e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    private String getExpectedJsonString(String expectedRepresentation) {
        if (this.nillable || !expectedRepresentation.isEmpty()) {
            return "\\{\\s*\"instance\"\\s*:\\s*" + this.fixExpectedRepresentation(expectedRepresentation) + JSON_PATTERN_SUFFIX;
        }
        return "\\{\\s*\\s*\\}";
    }

    private String getJsonString(String expectedRepresentation) {
        if (this.nillable || !expectedRepresentation.isEmpty()) {
            return "{ \"instance\" : " + expectedRepresentation + JSON_SUFFIX;
        }
        return "{  }";
    }

    private String fixExpectedRepresentation(String representation) {
        if (this.fixedRegExp != null) {
            return this.fixedRegExp;
        }
        representation = representation.replace("E38", "E[\\+]?\\+38");
        if (!Number.class.isInstance(this.testValue)) {
            representation = Pattern.quote(representation);
        } else if (Long.class.isInstance(this.testValue)) {
            Long longTestValue = (Long)Long.class.cast(this.testValue);
            if (!MappingTester.isIEEE754(BigDecimal.valueOf(longTestValue))) {
                representation = this.quote(representation);
            }
        } else if (BigDecimal.class.isInstance(this.testValue)) {
            if (!MappingTester.isIEEE754((BigDecimal)this.testValue)) {
                representation = this.quote(representation);
            }
        } else if (BigInteger.class.isInstance(this.testValue) && !MappingTester.isIEEE754(new BigDecimal((BigInteger)this.testValue))) {
            representation = this.quote(representation);
        }
        return representation;
    }

    private void testMarshalling(T value, String expectedRepresentation) throws IllegalAccessException, InstantiationException {
        TypeContainer<T> container = this.typeContainerClass.newInstance();
        container.setInstance(value);
        String jsonString = this.jsonb.toJson(container);
        String validationMessage = "[testMarshalling] - Failed to correctly marshal " + value.getClass().getName() + " property with value " + value;
        MatcherAssert.assertThat((String)validationMessage, (Object)jsonString, (Matcher)Matchers.matchesPattern((String)this.getExpectedJsonString(expectedRepresentation)));
    }

    private void testMarshallingToStream(T value, String expectedRepresentation) throws IllegalAccessException, InstantiationException {
        TypeContainer<T> container = this.typeContainerClass.newInstance();
        container.setInstance(value);
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            this.jsonb.toJson(container, (OutputStream)stream);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            String validationMessage = "[testMarshallingToStream] - Failed to correctly marshal " + value.getClass().getName() + " property with value " + value;
            MatcherAssert.assertThat((String)validationMessage, (Object)jsonString, (Matcher)Matchers.matchesPattern((String)this.getExpectedJsonString(expectedRepresentation)));
        }
        catch (IOException e) {
            Assertions.fail();
        }
    }

    private void testMarshallingToWriter(T value, String expectedRepresentation) throws IllegalAccessException, InstantiationException {
        TypeContainer<T> container = this.typeContainerClass.newInstance();
        container.setInstance(value);
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
            this.jsonb.toJson(container, (Writer)writer);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            String validationMessage = "[testMarshallingToStream] - Failed to correctly marshal " + value.getClass().getName() + " property with value " + value;
            MatcherAssert.assertThat((String)validationMessage, (Object)jsonString, (Matcher)Matchers.matchesPattern((String)this.getExpectedJsonString(expectedRepresentation)));
        }
        catch (IOException e) {
            Assertions.fail();
        }
    }

    private void testMarshallingByType(T value, String expectedRepresentation) throws IllegalAccessException, InstantiationException {
        TypeContainer<T> container = this.typeContainerClass.newInstance();
        container.setInstance(value);
        String jsonString = this.jsonb.toJson(container, TypeContainer.class);
        String validationMessage = "[testMarshallingByType] - Failed to correctly marshal " + value.getClass().getName() + " property with value " + value;
        MatcherAssert.assertThat((String)validationMessage, (Object)jsonString, (Matcher)Matchers.matchesPattern((String)this.getExpectedJsonString(expectedRepresentation)));
    }

    private void testMarshallingByTypeToStream(T value, String expectedRepresentation) throws IllegalAccessException, InstantiationException {
        TypeContainer<T> container = this.typeContainerClass.newInstance();
        container.setInstance(value);
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            this.jsonb.toJson(container, TypeContainer.class, (OutputStream)stream);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            String validationMessage = "[testMarshallingByTypeToStream] - Failed to correctly marshal " + value.getClass().getName() + " property with value " + value;
            MatcherAssert.assertThat((String)validationMessage, (Object)jsonString, (Matcher)Matchers.matchesPattern((String)this.getExpectedJsonString(expectedRepresentation)));
        }
        catch (IOException e) {
            Assertions.fail();
        }
    }

    private void testMarshallingByTypeToWriter(T value, String expectedRepresentation) throws IllegalAccessException, InstantiationException {
        TypeContainer<T> container = this.typeContainerClass.newInstance();
        container.setInstance(value);
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
            this.jsonb.toJson(container, TypeContainer.class, (Writer)writer);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            String validationMessage = "[testMarshallingByTypeToWriter] - Failed to correctly marshal " + value.getClass().getName() + " property with value " + value;
            MatcherAssert.assertThat((String)validationMessage, (Object)jsonString, (Matcher)Matchers.matchesPattern((String)this.getExpectedJsonString(expectedRepresentation)));
        }
        catch (IOException e) {
            Assertions.fail();
        }
    }

    private void testUnmarshallingByClass(T value, String expectedRepresentation) {
        String jsonString = this.getJsonString(expectedRepresentation);
        TypeContainer typeContainer = (TypeContainer)this.jsonb.fromJson(jsonString, this.typeContainerClass);
        String validationMessage = "[testUnmarshallingByClass] - Failed to correctly unmarshal " + value.getClass().getName() + " property with value " + value;
        Assertions.assertTrue((boolean)this.testUnmarshall(value, typeContainer.getInstance()), (String)validationMessage);
    }

    private void testUnmarshallingByClassFromStream(T value, String expectedRepresentation) {
        String jsonString = this.getJsonString(expectedRepresentation);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(jsonString.getBytes(StandardCharsets.UTF_8));){
            TypeContainer typeContainer = (TypeContainer)this.jsonb.fromJson((InputStream)stream, this.typeContainerClass);
            String validationMessage = "[testUnmarshallingByClassFromStream] - Failed to correctly unmarshal " + value.getClass().getName() + " property with value " + value;
            Assertions.assertTrue((boolean)this.testUnmarshall(value, typeContainer.getInstance()), (String)validationMessage);
        }
        catch (IOException e) {
            Assertions.fail();
        }
    }

    private void testUnmarshallingByClassFromReader(T value, String expectedRepresentation) {
        String jsonString = this.getJsonString(expectedRepresentation);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(jsonString.getBytes(StandardCharsets.UTF_8));
             InputStreamReader reader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);){
            TypeContainer typeContainer = (TypeContainer)this.jsonb.fromJson((Reader)reader, this.typeContainerClass);
            String validationMessage = "[testUnmarshallingByClassFromReader] - Failed to correctly unmarshal " + value.getClass().getName() + " property with value " + value;
            Assertions.assertTrue((boolean)this.testUnmarshall(value, typeContainer.getInstance()), (String)validationMessage);
        }
        catch (IOException e) {
            Assertions.fail();
        }
    }

    private void testUnmarshallingByType(T value, String expectedRepresentation) {
        String jsonString = this.getJsonString(expectedRepresentation);
        TypeContainer typeContainer = (TypeContainer)this.jsonb.fromJson(jsonString, this.typeContainerClass);
        String validationMessage = "[testUnmarshallingByType] - Failed to correctly unmarshal " + value.getClass().getName() + " property with value " + value;
        Assertions.assertTrue((boolean)this.testUnmarshall(value, typeContainer.getInstance()), (String)validationMessage);
    }

    private void testUnmarshallingByTypeFromStream(T value, String expectedRepresentation) {
        String jsonString = this.getJsonString(expectedRepresentation);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(jsonString.getBytes(StandardCharsets.UTF_8));){
            TypeContainer typeContainer = (TypeContainer)this.jsonb.fromJson((InputStream)stream, this.typeContainerClass);
            String validationMessage = "[testUnmarshallingByTypeFromStream] - Failed to correctly unmarshal " + value.getClass().getName() + " property with value " + value;
            Assertions.assertTrue((boolean)this.testUnmarshall(value, typeContainer.getInstance()), (String)validationMessage);
        }
        catch (IOException e) {
            Assertions.fail();
        }
    }

    private void testUnmarshallingByTypeFromReader(T value, String expectedRepresentation) {
        String jsonString = this.getJsonString(expectedRepresentation);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(jsonString.getBytes(StandardCharsets.UTF_8));
             InputStreamReader reader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);){
            TypeContainer typeContainer = (TypeContainer)this.jsonb.fromJson((Reader)reader, this.typeContainerClass);
            String validationMessage = "[testUnmarshallingByTypeFromReader] - Failed to correctly unmarshal " + value.getClass().getName() + " property with value " + value;
            Assertions.assertTrue((boolean)this.testUnmarshall(value, typeContainer.getInstance()), (String)validationMessage);
        }
        catch (IOException e) {
            Assertions.fail();
        }
    }

    protected boolean testUnmarshall(T value, T fromJson) {
        return this.testUnmarshall.test(value, fromJson);
    }

    public MappingTester<T> setUnmarshallTestPredicate(BiPredicate<T, T> testPredicate) {
        this.testUnmarshall = testPredicate;
        return this;
    }

    public MappingTester<T> setMarshallExpectedRegExp(String regExp) {
        this.fixedRegExp = regExp;
        return this;
    }

    private static boolean isIEEE754(BigDecimal value) {
        int scale = value.scale();
        int valBits = value.unscaledValue().abs().bitLength();
        int intBitsScaled = value.toBigInteger().bitLength();
        return valBits <= 53 && intBitsScaled <= 53 && -1022 <= scale && scale <= 1023;
    }

    private String quote(String value) {
        return "\"" + value + "\"";
    }
}

